/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.views.messages;

import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.actions.Ros2FollowMessageAction;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.AbstractRos2DataProviderTimeGraphView;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.Ros2HideInternalObjectsAction;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.Ros2ObjectTreeLabelProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.messages.Ros2MessagesPresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class Ros2MessagesView
extends AbstractRos2DataProviderTimeGraphView {
    private static final String ID_SUFFIX = ".messages";
    private Ros2FollowMessageAction fFollowAction;

    public Ros2MessagesView() {
        super(Ros2MessagesView.getFullViewId(), new Ros2MessagesPresentationProvider(), Ros2MessagesDataProvider.getFullDataProviderId());
        this.setTreeColumns(Ros2ObjectTreeLabelProvider.TREE_COLUMNS);
        this.setTreeLabelProvider(new Ros2MessagesViewTreeLabelProvider());
        this.setFilterColumns(Ros2ObjectTreeLabelProvider.TREE_COLUMNS);
        this.setFilterLabelProvider(new Ros2MessagesViewTreeLabelProvider());
    }

    public static @NonNull String getFullViewId() {
        return AbstractRos2DataProviderTimeGraphView.getViewIdFromSuffix(ID_SUFFIX);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        IDialogSettings settings = Objects.requireNonNull(Activator.getDefault()).getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        this.fFollowAction = new Ros2FollowMessageAction((TmfView)this, this.getTimeGraphViewer());
        this.fFollowAction.setEnabled(false);
        manager.appendToGroup("additions", (IAction)this.fFollowAction);
        Action hideArrowsAction = this.getTimeGraphViewer().getHideArrowsAction(section);
        manager.appendToGroup("additions", (IAction)hideArrowsAction);
        Ros2HideInternalObjectsAction hideInternalAction = new Ros2HideInternalObjectsAction(this.getTimeGraphViewer());
        manager.appendToGroup("additions", (IAction)hideInternalAction);
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @TmfSignalHandler
    public synchronized void selection(TmfSelectionRangeUpdatedSignal signal) {
        this.updateFollowMessageAction(signal.getSource());
    }

    private void updateFollowMessageAction(Object source) {
        if (this.fFollowAction != null) {
            boolean isValid = false;
            ITimeGraphEntry selection = this.getTimeGraphViewer().getSelection();
            if (selection != null && source == this) {
                @Nullable ITimeEvent event = Ros2MessagesView.getReferenceEvent(selection, this.getTimeGraphViewer().getSelectionBegin());
                isValid = event != null && event.getLabel() != null;
            }
            this.fFollowAction.setEnabled(isValid);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable ITimeEvent getReferenceEvent(ITimeGraphEntry selectedEntry, long timestamp) {
        if (!(selectedEntry instanceof TimeGraphEntry)) {
            return null;
        }
        ITmfTreeDataModel model = ((TimeGraphEntry)selectedEntry).getEntryModel();
        if (!(model instanceof Ros2ObjectTimeGraphEntryModel)) {
            return null;
        }
        Ros2ObjectTimeGraphEntryModel messagesModel = (Ros2ObjectTimeGraphEntryModel)model;
        if (!messagesModel.isLeafObject()) {
            return null;
        }
        ITimeEvent refEvent = null;
        @NonNull Iterator timeEventsIt = selectedEntry.getTimeEventsIterator();
        boolean searchDone = false;
        while (timeEventsIt.hasNext() && !searchDone) {
            ITimeEvent event = (ITimeEvent)timeEventsIt.next();
            long duration = event.getDuration();
            long time = event.getTime();
            if (duration > 0L && time <= timestamp && timestamp < time + duration) {
                refEvent = event;
                searchDone = true;
                continue;
            }
            if (time <= timestamp) continue;
            searchDone = true;
        }
        return refEvent;
    }

    private class Ros2MessagesViewTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private Ros2MessagesViewTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return Ros2ObjectTreeLabelProvider.getColumnText(element, columnIndex);
        }
    }
}

