/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintFilterManager;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintsParameterMode;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

class InlayHintVisitor
extends ASTVisitor {
    private List<InlayHint> hints;
    private int startOffset;
    private int endOffset;
    private ITypeRoot typeRoot;
    private boolean isVariableTypeHintsEnabled;
    private boolean isParameterTypeHintsEnabled;
    private InlayHintsParameterMode inlayHintsParameterMode;
    private boolean inlayHintsSuppressedWhenSameNameNumberedParameter;
    private static final Pattern FIRST_PARAM_PATTERN = Pattern.compile("^([^\\d]+)1$");

    InlayHintVisitor(int startOffset, int endOffset, ITypeRoot typeRoot, PreferenceManager preferenceManager) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.typeRoot = typeRoot;
        this.hints = new ArrayList<InlayHint>();
        this.isVariableTypeHintsEnabled = preferenceManager.getPreferences().isInlayHintsVariableTypesEnabled();
        this.isParameterTypeHintsEnabled = preferenceManager.getPreferences().isInlayHintsParameterTypesEnabled();
        this.inlayHintsParameterMode = preferenceManager.getPreferences().getInlayHintsParameterMode();
        this.inlayHintsSuppressedWhenSameNameNumberedParameter = preferenceManager.getPreferences().isInlayHintsSuppressedWhenSameNameNumberedParameter();
    }

    public boolean visit(EnumConstantDeclaration node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveParameterInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveParameterInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveParameterInlayHints(node.resolveMethodBinding(), node.arguments());
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveParameterInlayHints(node.resolveMethodBinding(), node.arguments());
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveParameterInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveParameterInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(LambdaExpression node) {
        if (this.isOutOfRange((ASTNode)node)) return true;
        if (this.isGenerated((ASTNode)node)) return true;
        if (!this.isParameterTypeHintsEnabled) {
            return true;
        }
        IMethodBinding methodBinding = node.resolveMethodBinding();
        if (methodBinding == null) {
            return true;
        }
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        List parameters = node.parameters();
        if (parameters.size() != parameterTypes.length) {
            return true;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= parameters.size()) {
                    return true;
                }
                Object param = parameters.get(i);
                if (param instanceof SingleVariableDeclaration) {
                    return true;
                }
                SimpleName paramName = null;
                if (param instanceof SimpleName) {
                    paramName = (SimpleName)param;
                } else if (param instanceof VariableDeclaration) {
                    paramName = ((VariableDeclaration)param).getName();
                }
                if (paramName != null) {
                    String typeName = parameterTypes[i].getName();
                    int[] lineAndColumn = JsonRpcHelpers.toLine(this.typeRoot.getBuffer(), paramName.getStartPosition());
                    InlayHint hint = new InlayHint(new Position(lineAndColumn[0], lineAndColumn[1]), Either.forLeft((Object)typeName));
                    hint.setPaddingRight(Boolean.valueOf(true));
                    this.hints.add(hint);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (!this.isVariableTypeHintsEnabled || this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node) || !node.getType().isVar()) {
            return true;
        }
        List fragments = node.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            String inferredType;
            Expression initializer;
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null || this.isUninterestingExpression(initializer = fragment.getInitializer())) continue;
            String string = inferredType = binding.getType() != null ? binding.getType().getName() : null;
            if (inferredType == null || inferredType.isEmpty()) continue;
            SimpleName varName = fragment.getName();
            int nameStart = varName.getStartPosition();
            int nameLength = varName.getLength();
            try {
                int[] lineAndColumn = JsonRpcHelpers.toLine(this.typeRoot.getBuffer(), nameStart + nameLength);
                String label = ": " + inferredType;
                InlayHint hint = new InlayHint(new Position(lineAndColumn[0], lineAndColumn[1]), Either.forLeft((Object)label));
                hint.setPaddingLeft(Boolean.valueOf(true));
                this.hints.add(hint);
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return true;
    }

    private boolean isUninterestingExpression(Expression initializer) {
        return initializer == null || initializer instanceof NumberLiteral || initializer instanceof BooleanLiteral || initializer instanceof CharacterLiteral || initializer instanceof StringLiteral || initializer instanceof ClassInstanceCreation || initializer instanceof ArrayCreation || initializer instanceof ArrayInitializer || initializer instanceof CastExpression;
    }

    public List<InlayHint> getInlayHints() {
        return this.hints;
    }

    private boolean isOutOfRange(ASTNode node) {
        return node.getStartPosition() > this.endOffset || node.getStartPosition() + node.getLength() < this.startOffset;
    }

    private boolean isGenerated(ASTNode node) {
        try {
            return (Boolean)node.getClass().getField("$isGenerated").get(node);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    private void resolveParameterInlayHints(IMethodBinding methodBinding, List<Expression> arguments) {
        if (methodBinding == null || this.inlayHintsParameterMode == InlayHintsParameterMode.NONE) {
            return;
        }
        if (arguments.isEmpty()) {
            return;
        }
        String[] parameterNames = this.getParameterNames(methodBinding);
        if (parameterNames == null) {
            return;
        }
        if (!methodBinding.isVarargs() && arguments.size() != parameterNames.length) {
            return;
        }
        if (InlayHintFilterManager.instance().match((IMethod)methodBinding.getJavaElement())) {
            return;
        }
        if (this.inlayHintsSuppressedWhenSameNameNumberedParameter && this.hasNumberedParameterPattern(parameterNames)) {
            return;
        }
        try {
            int paramNum = Math.min(parameterNames.length, arguments.size());
            int i = 0;
            while (i < paramNum) {
                Expression arg = arguments.get(i);
                if (this.acceptArgument(arg, parameterNames[i])) {
                    String label = parameterNames[i] + ":";
                    if (i == parameterNames.length - 1 && methodBinding.isVarargs()) {
                        label = "..." + label;
                    }
                    int[] lineAndColumn = JsonRpcHelpers.toLine(this.typeRoot.getBuffer(), arg.getStartPosition());
                    InlayHint hint = new InlayHint(new Position(lineAndColumn[0], lineAndColumn[1]), Either.forLeft((Object)label));
                    hint.setPaddingRight(Boolean.valueOf(true));
                    this.hints.add(hint);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }

    private String[] getParameterNames(IMethodBinding methodBinding) {
        if (!this.hasSource(methodBinding)) {
            return null;
        }
        String[] parameterNames = null;
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method != null) {
            try {
                parameterNames = method.getParameterNames();
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        } else if (methodBinding.getDeclaringClass().isRecord()) {
            parameterNames = methodBinding.getParameterNames();
        }
        return parameterNames;
    }

    private boolean hasSource(IMethodBinding methodBinding) {
        IType type = (IType)methodBinding.getDeclaringClass().getJavaElement();
        if (type == null) {
            return false;
        }
        ITypeRoot typeRoot = type.getTypeRoot();
        if (typeRoot == null || !typeRoot.exists()) {
            return false;
        }
        try {
            return typeRoot.getBuffer() != null;
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return false;
        }
    }

    private boolean acceptArgument(Expression argument, String paramName) {
        if (InlayHintsParameterMode.LITERALS.equals((Object)this.inlayHintsParameterMode) && !this.isLiteral(argument)) {
            return false;
        }
        if (argument instanceof LambdaExpression) {
            return false;
        }
        return !this.isSameName(argument, paramName);
    }

    private boolean isLiteral(Expression argument) {
        return argument instanceof BooleanLiteral || argument instanceof CharacterLiteral || argument instanceof NullLiteral || argument instanceof NumberLiteral || argument instanceof StringLiteral || argument instanceof TypeLiteral;
    }

    private boolean isSameName(Expression argument, String paramName) {
        if (argument instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)argument;
            argument = castExpression.getExpression();
        }
        if (!(argument instanceof SimpleName)) {
            return false;
        }
        String argName = ((SimpleName)argument).getIdentifier();
        return Objects.equals(argName, paramName);
    }

    private boolean hasNumberedParameterPattern(String[] parameterNames) {
        if (parameterNames == null || parameterNames.length < 2 || parameterNames[0] == null) {
            return false;
        }
        String firstParam = parameterNames[0];
        Matcher matcher = FIRST_PARAM_PATTERN.matcher(firstParam);
        if (!matcher.matches()) {
            return false;
        }
        String prefix = matcher.group(1);
        int i = 1;
        while (i < parameterNames.length) {
            String expectedParam = prefix + (i + 1);
            if (!expectedParam.equals(parameterNames[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

