/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.osgi.util.NLS;
import org.gradle.tooling.GradleConnector;

public final class FixedVersionGradleDistribution
extends GradleDistribution {
    private final String version;

    FixedVersionGradleDistribution(String version) {
        this.version = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)version));
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void apply(GradleConnector connector) {
        connector.useGradleVersion(this.version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedVersionGradleDistribution other = (FixedVersionGradleDistribution)obj;
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return String.format("GRADLE_DISTRIBUTION(VERSION(%s))", this.version);
    }

    @Override
    public String getDisplayName() {
        return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseGradleVersion_0, (Object)this.version);
    }
}

