/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class AddSpaceBeforeValue
extends AbstractManifestMarkerResolution {
    private static final Logger logger = Logger.getLogger(AddSpaceBeforeValue.class.getName());

    public AddSpaceBeforeValue(int type, IMarker marker) {
        super(type, marker);
    }

    public String getLabel() {
        return PDEUIMessages.AddSpaceAfterColon_add;
    }

    @Override
    protected void createChange(BundleModel model) {
        try {
            IDocument doc = model.getDocument();
            int lineNum = this.marker.getAttribute("lineNumber", -1);
            IRegion lineInfo = doc.getLineInformation(lineNum - 1);
            int offset = lineInfo.getOffset();
            int length = lineInfo.getLength();
            String getLine = doc.get(offset, length);
            int colonInd = getLine.indexOf(58);
            if (colonInd > 0 && getLine.charAt(colonInd + 1) != ' ') {
                Object userHeader = getLine.substring(0, colonInd + 1);
                userHeader = (String)userHeader + " ";
                doc.replace(offset, colonInd + 1, (String)userHeader);
            }
        }
        catch (BadLocationException e) {
            logger.log(Level.SEVERE, "Failed to apply AddSpaceBeforeValue quick fix, unexpected location in the doc", e);
        }
    }
}

