/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console.ansi.utils;

import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;

public class AnsiConsoleColorPalette {
    public static final String PALETTE_VGA = "paletteVGA";
    public static final String PALETTE_WINXP = "paletteXP";
    public static final String PALETTE_WIN10 = "paletteWin10";
    public static final String PALETTE_MAC = "paletteMac";
    public static final String PALETTE_PUTTY = "palettePuTTY";
    public static final String PALETTE_XTERM = "paletteXTerm";
    public static final String PALETTE_MIRC = "paletteMirc";
    public static final String PALETTE_UBUNTU = "paletteUbuntu";
    private static final int PALETTE_SIZE = 256;
    private static final int TRUE_RGB_FLAG = 0x10000000;
    private static final RGB[] paletteVGA = new RGB[]{new RGB(0, 0, 0), new RGB(170, 0, 0), new RGB(0, 170, 0), new RGB(170, 85, 0), new RGB(0, 0, 170), new RGB(170, 0, 170), new RGB(0, 170, 170), new RGB(170, 170, 170), new RGB(85, 85, 85), new RGB(255, 85, 85), new RGB(85, 255, 85), new RGB(255, 255, 85), new RGB(85, 85, 255), new RGB(255, 85, 255), new RGB(85, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteXP = new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(192, 192, 192), new RGB(128, 128, 128), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteWin10 = new RGB[]{new RGB(12, 12, 12), new RGB(197, 15, 31), new RGB(19, 161, 14), new RGB(193, 156, 0), new RGB(0, 55, 218), new RGB(136, 23, 152), new RGB(58, 150, 221), new RGB(204, 204, 204), new RGB(118, 118, 118), new RGB(231, 72, 86), new RGB(22, 198, 12), new RGB(249, 241, 165), new RGB(59, 120, 255), new RGB(180, 0, 158), new RGB(97, 214, 214), new RGB(242, 242, 242)};
    private static final RGB[] paletteMac = new RGB[]{new RGB(0, 0, 0), new RGB(194, 54, 33), new RGB(37, 188, 36), new RGB(173, 173, 39), new RGB(73, 46, 225), new RGB(211, 56, 211), new RGB(51, 187, 200), new RGB(203, 204, 205), new RGB(129, 131, 131), new RGB(252, 57, 31), new RGB(49, 231, 34), new RGB(234, 236, 35), new RGB(88, 51, 255), new RGB(249, 53, 248), new RGB(20, 240, 240), new RGB(233, 235, 235)};
    private static final RGB[] palettePuTTY = new RGB[]{new RGB(0, 0, 0), new RGB(187, 0, 0), new RGB(0, 187, 0), new RGB(187, 187, 0), new RGB(0, 0, 187), new RGB(187, 0, 187), new RGB(0, 187, 187), new RGB(187, 187, 187), new RGB(85, 85, 85), new RGB(255, 85, 85), new RGB(85, 255, 85), new RGB(255, 255, 85), new RGB(85, 85, 255), new RGB(255, 85, 255), new RGB(85, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteXTerm = new RGB[]{new RGB(0, 0, 0), new RGB(205, 0, 0), new RGB(0, 205, 0), new RGB(205, 205, 0), new RGB(0, 0, 238), new RGB(205, 0, 205), new RGB(0, 205, 205), new RGB(229, 229, 229), new RGB(127, 127, 127), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(92, 92, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteMirc = new RGB[]{new RGB(0, 0, 0), new RGB(127, 0, 0), new RGB(0, 147, 0), new RGB(252, 127, 0), new RGB(0, 0, 127), new RGB(156, 0, 156), new RGB(0, 147, 147), new RGB(210, 210, 210), new RGB(127, 127, 127), new RGB(255, 0, 0), new RGB(0, 252, 0), new RGB(255, 255, 0), new RGB(0, 0, 252), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteUbuntu = new RGB[]{new RGB(1, 1, 1), new RGB(222, 56, 43), new RGB(57, 181, 74), new RGB(255, 199, 6), new RGB(0, 111, 184), new RGB(118, 38, 113), new RGB(44, 181, 233), new RGB(204, 204, 204), new RGB(128, 128, 128), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    private static final HashMap<String, RGB[]> KNOWN_PALETTES = new HashMap();
    private static RGB[] palette;
    private static String currentPaletteName;

    static {
        KNOWN_PALETTES.put(PALETTE_MAC, paletteMac);
        KNOWN_PALETTES.put(PALETTE_VGA, paletteVGA);
        KNOWN_PALETTES.put(PALETTE_WINXP, paletteXP);
        KNOWN_PALETTES.put(PALETTE_WIN10, paletteWin10);
        KNOWN_PALETTES.put(PALETTE_XTERM, paletteXTerm);
        KNOWN_PALETTES.put(PALETTE_PUTTY, palettePuTTY);
        KNOWN_PALETTES.put(PALETTE_MIRC, paletteMirc);
        KNOWN_PALETTES.put(PALETTE_UBUNTU, paletteUbuntu);
        palette = paletteXP;
        currentPaletteName = AnsiConsoleColorPalette.getBestPaletteForOS();
    }

    private AnsiConsoleColorPalette() {
    }

    public static boolean isValidIndex(int value) {
        return value >= 0 && value < 256;
    }

    public static int hackRgb(int r, int g, int b) {
        if (!AnsiConsoleColorPalette.isValidIndex(r)) {
            return -1;
        }
        if (!AnsiConsoleColorPalette.isValidIndex(g)) {
            return -1;
        }
        if (!AnsiConsoleColorPalette.isValidIndex(b)) {
            return -1;
        }
        return 0x10000000 | r << 16 | g << 8 | b;
    }

    private static int safe256(int value, int modulo) {
        int result = value * 256 / modulo;
        return result < 256 ? result : 255;
    }

    public static RGB getColor(Integer index) {
        if (index == null) {
            return null;
        }
        if (index >= 0x10000000) {
            int red = index >> 16 & 0xFF;
            int green = index >> 8 & 0xFF;
            int blue = index & 0xFF;
            return new RGB(red, green, blue);
        }
        if (index >= 0 && index < palette.length) {
            return palette[index];
        }
        if (index >= 16 && index < 232) {
            int color = index - 16;
            int blue = color % 6;
            int green = (color /= 6) % 6;
            int red = color / 6;
            return new RGB(AnsiConsoleColorPalette.safe256(red, 6), AnsiConsoleColorPalette.safe256(green, 6), AnsiConsoleColorPalette.safe256(blue, 6));
        }
        if (index >= 232 && index < 256) {
            int gray = AnsiConsoleColorPalette.safe256(index - 232, 24);
            return new RGB(gray, gray, gray);
        }
        return null;
    }

    public static String getPalette() {
        return currentPaletteName;
    }

    public static void setPalette(String paletteName) {
        currentPaletteName = paletteName;
        palette = KNOWN_PALETTES.get(paletteName);
        if (palette == null) {
            currentPaletteName = AnsiConsoleColorPalette.getBestPaletteForOS();
        }
    }

    public static String getBestPaletteForOS() {
        String os = SWT.getPlatform();
        String osVer = System.getProperty("os.version");
        switch (os) {
            case "win32": {
                return osVer == null || !osVer.startsWith("10.") ? PALETTE_WINXP : PALETTE_WIN10;
            }
            case "cocoa": {
                return PALETTE_MAC;
            }
            case "gtk": {
                return PALETTE_XTERM;
            }
        }
        return PALETTE_VGA;
    }
}

