/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator.DecoratorService;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SiriusDecoratorEditPolicy
extends DecorationEditPolicy {
    public void activate() {
        if (this.decorators == null) {
            this.decorators = new HashMap();
            DecoratorService.getInstance().createDecorators((IDecoratorTarget)new SiriusDecoratorTarget());
        }
        if (this.decorators != null) {
            for (IDecorator decorator : this.decorators.values()) {
                decorator.activate();
            }
        }
    }

    public void refresh() {
        if (this.decorators == null) {
            this.decorators = new HashMap();
            DecoratorService.getInstance().createDecorators((IDecoratorTarget)new SiriusDecoratorTarget());
        }
        for (IDecorator decorator : this.decorators.values()) {
            decorator.refresh();
        }
    }

    private final class SiriusDecoratorTarget
    extends DecorationEditPolicy.DecoratorTarget {
        private SiriusDecoratorTarget() {
            super((DecorationEditPolicy)SiriusDecoratorEditPolicy.this);
        }

        public IDecoration addDecoration(IFigure figure, Locator locator, boolean isVolatile) {
            SiriusDecoration decoration = new SiriusDecoration();
            decoration.add(figure);
            decoration.setSize(figure.getSize());
            GraphicalEditPart ownerEditPart = (GraphicalEditPart)this.getAdapter(GraphicalEditPart.class);
            decoration.setOwnerFigure(ownerEditPart.getFigure());
            decoration.setLocator(locator);
            ownerEditPart.getViewer().getVisualPartMap().put(decoration, ownerEditPart);
            IFigure pane = SiriusDecoratorEditPolicy.this.getLayer(isVolatile ? "Decoration Unprintable Layer" : "Decoration Printable Layer");
            pane.add((IFigure)decoration);
            return decoration;
        }

        private final class SiriusDecoration
        extends Decoration {
            private SiriusDecoration() {
            }

            public IFigure findMouseEventTargetAt(int x, int y) {
                IGraphicalEditPart bestChildCandidate;
                if (this.checkHostEditPart(x, y) && (bestChildCandidate = this.findBestChildCandidate((IGraphicalEditPart)SiriusDecoratorEditPolicy.this.getHost(), new Point(x, y))) != null) {
                    return bestChildCandidate.getFigure();
                }
                return super.findMouseEventTargetAt(x, y);
            }

            private boolean checkHostEditPart(int x, int y) {
                if (SiriusDecoratorEditPolicy.this.getHost() instanceof IGraphicalEditPart) {
                    EditPolicy editPolicy = SiriusDecoratorEditPolicy.this.getHost().getEditPolicy((Object)"DecorationPolicy");
                    IFigure figure = ((IGraphicalEditPart)SiriusDecoratorEditPolicy.this.getHost()).getFigure();
                    if (editPolicy instanceof SiriusDecoratorEditPolicy && figure.getBounds().contains(x, y)) {
                        return true;
                    }
                }
                return false;
            }

            private IGraphicalEditPart findBestChildCandidate(IGraphicalEditPart graphicalEditPart, Point startLocation) {
                IAbstractDiagramNodeEditPart bestCandidate = null;
                for (AbstractDiagramBorderNodeEditPart editPart : Iterables.filter((Iterable)graphicalEditPart.getChildren(), AbstractDiagramBorderNodeEditPart.class)) {
                    IGraphicalEditPart bestChildBorderNodeCandidate;
                    if (editPart.getFigure().getBounds().contains(startLocation)) {
                        bestCandidate = editPart;
                    }
                    if ((bestChildBorderNodeCandidate = this.findBestChildCandidate(editPart, startLocation)) == null) continue;
                    bestCandidate = bestChildBorderNodeCandidate;
                }
                if (bestCandidate == null && graphicalEditPart instanceof AbstractDiagramContainerEditPart) {
                    for (AbstractDNodeContainerCompartmentEditPart compartmentEditPart : Iterables.filter((Iterable)graphicalEditPart.getChildren(), AbstractDNodeContainerCompartmentEditPart.class)) {
                        for (AbstractDiagramNodeEditPart editPart : Iterables.filter((Iterable)compartmentEditPart.getChildren(), AbstractDiagramNodeEditPart.class)) {
                            if (!GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)editPart).contains(startLocation)) continue;
                            bestCandidate = editPart;
                            IGraphicalEditPart childBestCandidate = this.findBestChildCandidate(editPart, startLocation);
                            if (childBestCandidate == null) break;
                            bestCandidate = childBestCandidate;
                            break;
                        }
                        if (bestCandidate != null) break;
                    }
                }
                return bestCandidate;
            }
        }
    }
}

