/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.osgi.About;
import aQute.bnd.osgi.AbstractResource;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.MakePlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class MakeJar
implements MakePlugin {
    public Resource make(Builder builder, String destination, Map<String, String> argumentsOnMake) throws Exception {
        String type = argumentsOnMake.get("type");
        if (!"jar".equals(type)) {
            return null;
        }
        String input = argumentsOnMake.get("input");
        if (input == null) {
            builder.error("No input specified on a make instruction for %s, args=%s", new Object[]{destination, argumentsOnMake});
            return null;
        }
        final File folder = builder.getFile(input);
        if (!folder.isDirectory()) {
            return null;
        }
        final boolean noExtra = Boolean.parseBoolean(argumentsOnMake.get("noExtra"));
        final boolean reproducible = Boolean.parseBoolean(argumentsOnMake.get("reproducible"));
        return new AbstractResource(System.currentTimeMillis()){

            protected byte[] getBytes() throws Exception {
                Throwable throwable = null;
                Object var2_3 = null;
                try (Jar jar = new Jar(folder);){
                    Manifest manifest = new Manifest();
                    Attributes mainAttributes = manifest.getMainAttributes();
                    mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                    if (!noExtra) {
                        mainAttributes.putValue("Created-By", String.format("%s (%s)", System.getProperty("java.version"), System.getProperty("java.vendor")));
                        mainAttributes.putValue("Tool", "Bnd-" + About.getBndVersion());
                        if (!reproducible) {
                            mainAttributes.putValue("Bnd-LastModified", Long.toString(this.lastModified()));
                        }
                    }
                    jar.setManifest(manifest);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    jar.write((OutputStream)stream);
                    return stream.toByteArray();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        };
    }
}

