/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.launch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.m2m.atl.adt.ui.common.RegisteredPackageDialog;
import org.eclipse.m2m.atl.adt.ui.common.WorkspaceFileDialog;
import org.eclipse.m2m.atl.common.ATLLaunchConstants;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ui.ATLCoreUIPlugin;
import org.eclipse.m2m.atl.core.ui.Messages;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class MainAtlTab
extends AbstractLaunchConfigurationTab {
    public static final int IS_METAMODEL = 2;
    public static final int IS_MODEL = 4;
    public static final int IS_SOURCE = 8;
    public static final int IS_TARGET = 32;
    public static final int IS_LIBRARY = 64;
    public static final int IS_MODULE = 128;
    private ScrolledComposite scrollContainer;
    private Composite rootContainer;
    private List<String> sourceMetamodelsFromModule = new ArrayList<String>();
    private List<String> targetMetamodelsFromModule = new ArrayList<String>();
    private List<String> sourceModelsFromModule = new ArrayList<String>();
    private List<String> targetModelsFromModule = new ArrayList<String>();
    private List<String> librariesFromModule = new ArrayList<String>();
    private List<String> superimposedFromAdvancedTab = new ArrayList<String>();
    private String launcherNameFromAdvancedTab;
    private List<String> nonLibraries = new ArrayList<String>();
    private List<String> removableMetamodels = new ArrayList<String>();
    private List<String> removableSourceModels = new ArrayList<String>();
    private List<String> removableTargetModels = new ArrayList<String>();
    private List<String> removableLibraries = new ArrayList<String>();
    private Map<String, String> sourceC2RelationshipFromModule = new LinkedHashMap<String, String>();
    private Map<String, String> targetC2RelationshipFromModule = new LinkedHashMap<String, String>();
    private Group moduleGroup;
    private Group metamodelsGroup;
    private Group sourceModelsGroup;
    private Group targetModelsGroup;
    private Group librariesGroup;
    private Group controlGroup;
    private Map<String, Map<String, Object>> metamodelsGroupWidgets = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> sourceModelsGroupWidgets = new LinkedHashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> targetModelsGroupWidgets = new LinkedHashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> librariesGroupWidgets = new HashMap<String, Map<String, Object>>();
    private Pattern asmToAtl = Pattern.compile("\\.asm$");
    private Pattern moduleName = Pattern.compile("^.*/(.*)\\.a(tl|sm)$");
    private Map<IFile, AtlSourceManager> asmFileCache = new HashMap<IFile, AtlSourceManager>();
    private Map<String, String> metamodelLocations = new HashMap<String, String>();
    private Text atlPathText;
    private boolean isRefining;
    private String atlcompiler;
    private ILaunchConfiguration launchConfiguration;

    public void createControl(Composite parent) {
        this.scrollContainer = new ScrolledComposite(parent, 768);
        this.scrollContainer.setExpandHorizontal(true);
        this.scrollContainer.setExpandVertical(true);
        this.rootContainer = new Composite((Composite)this.scrollContainer, 0);
        this.rootContainer.setLayout((Layout)new GridLayout());
        this.scrollContainer.setContent((Control)this.rootContainer);
        this.moduleGroup = new Group(this.rootContainer, 0);
        this.moduleGroup.setLayoutData((Object)new GridData(768));
        this.moduleGroup.setLayout((Layout)new GridLayout(3, false));
        this.moduleGroup.setText(Messages.getString("MainAtlTab.ATL_MODULE"));
        this.atlPathText = new Text((Composite)this.moduleGroup, 2052);
        this.atlPathText.setLayoutData((Object)new GridData(768));
        this.atlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.rebuild();
            }
        });
        Button browseWorkspace = new Button((Composite)this.moduleGroup, 131072);
        browseWorkspace.setText(Messages.getString("MainAtlTab.WORKSPACE"));
        this.atlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editPath(128);
                if (path.trim().length() > 0) {
                    MainAtlTab.this.atlPathText.setText(path);
                }
            }
        });
        this.metamodelsGroup = new Group(this.rootContainer, 0);
        this.metamodelsGroup.setText(Messages.getString("MainAtlTab.METAMODELS"));
        this.metamodelsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.metamodelsGroup.setLayout((Layout)new GridLayout(8, false));
        this.sourceModelsGroup = new Group(this.rootContainer, 0);
        this.sourceModelsGroup.setText(Messages.getString("MainAtlTab.SOURCEMODELS"));
        this.sourceModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.sourceModelsGroup.setLayout((Layout)new GridLayout(4, false));
        this.targetModelsGroup = new Group(this.rootContainer, 0);
        this.targetModelsGroup.setText(Messages.getString("MainAtlTab.TARGETMODELS"));
        this.targetModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.targetModelsGroup.setLayout((Layout)new GridLayout(4, false));
        this.librariesGroup = new Group(this.rootContainer, 0);
        this.librariesGroup.setText(Messages.getString("MainAtlTab.LIBRARIES"));
        this.librariesGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.librariesGroup.setLayout((Layout)new GridLayout(4, false));
        this.controlGroup = new Group(this.rootContainer, 0);
        this.controlGroup.setText(Messages.getString("MainAtlTab.MODIFY"));
        this.controlGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.controlGroup.setLayout((Layout)new GridLayout(7, false));
        Button addSourceModelBtn = new Button((Composite)this.controlGroup, 0);
        addSourceModelBtn.setText(Messages.getString("MainAtlTab.ADDSOURCE"));
        Button addTargetModelBtn = new Button((Composite)this.controlGroup, 0);
        addTargetModelBtn.setText(Messages.getString("MainAtlTab.ADDTARGET"));
        Button addLibBtn = new Button((Composite)this.controlGroup, 0);
        addLibBtn.setText(Messages.getString("MainAtlTab.ADDLIB"));
        addSourceModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainAtlTab.this.getShell(), Messages.getString("MainAtlTab.ADDSOURCEMODEL"), Messages.getString("MainAtlTab.MMNAME"), "MM", null);
                if (dlg.open() == 1) {
                    return;
                }
                String metamodelName = dlg.getValue();
                dlg = new InputDialog(MainAtlTab.this.getShell(), Messages.getString("MainAtlTab.ADDSOURCEMODEL"), Messages.getString("MainAtlTab.MNAME"), "IN", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainAtlTab.this.sourceMetamodelsFromModule.contains(metamodelName)) {
                    MainAtlTab.this.sourceMetamodelsFromModule.add(metamodelName);
                    if (!MainAtlTab.this.targetMetamodelsFromModule.contains(metamodelName)) {
                        MainAtlTab.this.removableMetamodels.add(metamodelName);
                    }
                }
                if (!MainAtlTab.this.sourceModelsFromModule.contains(modelName)) {
                    MainAtlTab.this.sourceModelsFromModule.add(modelName);
                    MainAtlTab.this.sourceC2RelationshipFromModule.put(modelName, metamodelName);
                    MainAtlTab.this.removableSourceModels.add(modelName);
                }
                MainAtlTab.this.build();
                MainAtlTab.this.layout();
            }
        });
        addTargetModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainAtlTab.this.getShell(), Messages.getString("MainAtlTab.ADDTARGETMODEL"), Messages.getString("MainAtlTab.MMNAME"), "MM", null);
                if (dlg.open() == 1) {
                    return;
                }
                String metamodelName = dlg.getValue();
                dlg = new InputDialog(MainAtlTab.this.getShell(), Messages.getString("MainAtlTab.ADDTARGETMODEL"), Messages.getString("MainAtlTab.MNAME"), "OUT", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainAtlTab.this.targetMetamodelsFromModule.contains(metamodelName)) {
                    MainAtlTab.this.targetMetamodelsFromModule.add(metamodelName);
                    if (!MainAtlTab.this.sourceMetamodelsFromModule.contains(metamodelName)) {
                        MainAtlTab.this.removableMetamodels.add(metamodelName);
                    }
                }
                if (!MainAtlTab.this.targetModelsFromModule.contains(modelName)) {
                    MainAtlTab.this.targetModelsFromModule.add(modelName);
                    MainAtlTab.this.targetC2RelationshipFromModule.put(modelName, metamodelName);
                    MainAtlTab.this.removableTargetModels.add(modelName);
                }
                MainAtlTab.this.build();
                MainAtlTab.this.layout();
            }
        });
        addLibBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainAtlTab.this.getShell(), Messages.getString("MainAtlTab.ADDLIBRARY"), Messages.getString("MainAtlTab.LIBRARYNAME"), "LIB", null);
                if (dlg.open() == 1) {
                    return;
                }
                String libName = dlg.getValue();
                if (!MainAtlTab.this.librariesFromModule.contains(libName)) {
                    MainAtlTab.this.librariesFromModule.add(libName);
                    MainAtlTab.this.removableLibraries.add(libName);
                }
                MainAtlTab.this.build();
                MainAtlTab.this.layout();
            }
        });
        this.setControl((Control)this.scrollContainer);
    }

    public void superimposedChanged(List<String> superimposed) {
        this.superimposedFromAdvancedTab = superimposed;
    }

    public void launcherNameChanged(String launcherName) {
        if (!launcherName.equals(this.launcherNameFromAdvancedTab)) {
            this.launcherNameFromAdvancedTab = launcherName;
            boolean visible = launcherName.equals("Regular VM");
            for (Map<String, Object> map : this.metamodelsGroupWidgets.values()) {
                Combo combo = (Combo)map.get("modelHandlers");
                combo.setVisible(visible);
                Label label = (Label)map.get("modelHandlerLabel");
                label.setVisible(visible);
            }
        }
    }

    private void clear() {
        this.sourceModelsFromModule.clear();
        this.sourceMetamodelsFromModule.clear();
        this.targetModelsFromModule.clear();
        this.targetMetamodelsFromModule.clear();
        this.librariesFromModule.clear();
        this.removableMetamodels.clear();
        this.removableSourceModels.clear();
        this.removableTargetModels.clear();
        this.removableLibraries.clear();
        this.sourceC2RelationshipFromModule.clear();
        this.targetC2RelationshipFromModule.clear();
        this.metamodelsGroupWidgets.clear();
        this.sourceModelsGroupWidgets.clear();
        this.targetModelsGroupWidgets.clear();
        this.librariesGroupWidgets.clear();
        this.disposeGroupChildren(this.metamodelsGroup);
        this.disposeGroupChildren(this.sourceModelsGroup);
        this.disposeGroupChildren(this.targetModelsGroup);
        this.disposeGroupChildren(this.librariesGroup);
    }

    private void initializeExtraWidgetsFrom(ILaunchConfiguration configuration) throws CoreException {
        String mmName;
        if (configuration == null) {
            return;
        }
        Map savedLibraries = configuration.getAttribute("Libs", Collections.EMPTY_MAP);
        Map input = configuration.getAttribute("Input", Collections.EMPTY_MAP);
        Map output = configuration.getAttribute("Output", Collections.EMPTY_MAP);
        for (String mName : input.keySet()) {
            mmName = (String)input.get(mName);
            if (!this.sourceMetamodelsFromModule.contains(mmName)) {
                this.sourceMetamodelsFromModule.add(mmName);
                if (!this.targetMetamodelsFromModule.contains(mmName)) {
                    this.removableMetamodels.add(mmName);
                }
            }
            if (this.sourceModelsFromModule.contains(mName)) continue;
            this.sourceModelsFromModule.add(mName);
            this.sourceC2RelationshipFromModule.put(mName, mmName);
            this.removableSourceModels.add(mName);
        }
        for (String mName : output.keySet()) {
            mmName = (String)output.get(mName);
            if (!this.targetMetamodelsFromModule.contains(mmName)) {
                this.targetMetamodelsFromModule.add(mmName);
                if (!this.sourceMetamodelsFromModule.contains(mmName)) {
                    this.removableMetamodels.add(mmName);
                }
            }
            if (this.targetModelsFromModule.contains(mName)) continue;
            this.targetModelsFromModule.add(mName);
            this.targetC2RelationshipFromModule.put(mName, mmName);
            this.removableTargetModels.add(mName);
        }
        for (String libraryName : savedLibraries.keySet()) {
            if (this.librariesFromModule.contains(libraryName)) continue;
            this.librariesFromModule.add(libraryName);
            this.removableLibraries.add(libraryName);
        }
    }

    private void initializeWidgetValuesFrom(ILaunchConfiguration configuration) throws CoreException {
        Map<String, Object> widgets;
        if (configuration == null) {
            return;
        }
        Map savedPaths = configuration.getAttribute("Path", Collections.EMPTY_MAP);
        Map savedModelHandlers = configuration.getAttribute("Model Handler", Collections.EMPTY_MAP);
        Map savedLibraries = configuration.getAttribute("Libs", Collections.EMPTY_MAP);
        for (String modelName : savedPaths.keySet()) {
            if (this.metamodelsGroupWidgets.get(modelName) != null) {
                widgets = this.metamodelsGroupWidgets.get(modelName);
                Text metamodelLocation = (Text)widgets.get("metamodelLocation");
                Button isMetametamodel = (Button)widgets.get("isMetametamodel");
                Combo modelHandlers = (Combo)widgets.get("modelHandlers");
                if (((String)savedPaths.get(modelName)).startsWith("#")) {
                    isMetametamodel.setSelection(true);
                    isMetametamodel.notifyListeners(13, null);
                } else {
                    metamodelLocation.setText((String)savedPaths.get(modelName));
                }
                this.selectModelHandler(modelHandlers, savedModelHandlers.get(modelName));
                continue;
            }
            widgets = null;
            if (this.sourceModelsGroupWidgets.get(modelName) != null) {
                widgets = this.sourceModelsGroupWidgets.get(modelName);
            } else if (this.targetModelsGroupWidgets.get(modelName) != null) {
                widgets = this.targetModelsGroupWidgets.get(modelName);
            }
            if (widgets == null) continue;
            Text modelLocation = (Text)widgets.get("location");
            modelLocation.setText((String)savedPaths.get(modelName));
        }
        for (String libraryName : savedLibraries.keySet()) {
            widgets = this.librariesGroupWidgets.get(libraryName);
            if (widgets == null) continue;
            Text libraryLocation = (Text)widgets.get("location");
            libraryLocation.setText((String)savedLibraries.get(libraryName));
        }
    }

    private void calcNonLibraries() {
        this.nonLibraries.clear();
        String path2 = this.atlPathText.getText();
        Matcher m = this.moduleName.matcher(path2);
        if (m.find()) {
            this.nonLibraries.add(m.group(1));
        }
        for (String path2 : this.superimposedFromAdvancedTab) {
            m = this.moduleName.matcher(path2);
            if (!m.find()) continue;
            this.nonLibraries.add(m.group(1));
        }
    }

    private void getModelsFromATLFiles() {
        String path2;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = wsRoot.findMember(path2 = this.atlPathText.getText());
        if (res instanceof IFile) {
            this.getModelsFromATLFile((IFile)res);
        }
        for (String path2 : this.superimposedFromAdvancedTab) {
            res = wsRoot.findMember(path2 = this.asmToAtl.matcher(path2).replaceFirst(".atl"));
            if (res instanceof IFile) {
                this.getModelsFromATLFile((IFile)res);
                continue;
            }
            ATLLogger.severe((String)(String.valueOf(Messages.getString("MainAtlTab.FILENOTFOUND")) + path2));
        }
    }

    private void rebuild() {
        try {
            this.clear();
            this.build();
            this.initializeExtraWidgetsFrom(this.launchConfiguration);
            this.build();
            this.initializeWidgetValuesFrom(this.launchConfiguration);
            this.layout();
        }
        catch (CoreException ex) {
            ATLLogger.log((Level)Level.SEVERE, (String)ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private void build() {
        this.calcNonLibraries();
        this.getModelsFromATLFiles();
        this.buildMetamodelControls(this.sourceMetamodelsFromModule);
        this.buildMetamodelControls(this.targetMetamodelsFromModule);
        this.buildSourceModelControls(this.sourceModelsFromModule);
        this.buildTargetModelControls(this.targetModelsFromModule);
        this.buildLibraryControls(this.librariesFromModule);
    }

    private void buildMetamodelControls(Collection<String> modelNames) {
        for (String modelName : modelNames) {
            if (this.metamodelsGroupWidgets.containsKey(modelName)) continue;
            this.metamodelsGroupWidgets.put(modelName, this.buildMetamodelsControls(this.metamodelsGroup, modelName, 10, this.removableMetamodels.contains(modelName)));
        }
    }

    private void buildSourceModelControls(Collection<String> modelNames) {
        for (String modelName : modelNames) {
            if (this.sourceModelsGroupWidgets.containsKey(modelName)) continue;
            String mmName = this.sourceC2RelationshipFromModule.get(modelName);
            this.sourceModelsGroupWidgets.put(modelName, this.buildModelsAndLibrariesControls(this.sourceModelsGroup, modelName, mmName, 12, this.removableSourceModels.contains(modelName)));
        }
    }

    private void buildTargetModelControls(Collection<String> modelNames) {
        for (String modelName : modelNames) {
            if (this.targetModelsGroupWidgets.get(modelName) != null) continue;
            String mmName = this.targetC2RelationshipFromModule.get(modelName);
            this.targetModelsGroupWidgets.put(modelName, this.buildModelsAndLibrariesControls(this.targetModelsGroup, modelName, mmName, 36, this.removableTargetModels.contains(modelName)));
        }
    }

    private void buildLibraryControls(Collection<String> libraryNames) {
        for (String libraryName : libraryNames) {
            if (this.librariesGroupWidgets.get(libraryName) != null) continue;
            this.librariesGroupWidgets.put(libraryName, this.buildModelsAndLibrariesControls(this.librariesGroup, libraryName, null, 64, this.removableLibraries.contains(libraryName)));
        }
    }

    private void layout() {
        this.metamodelsGroup.layout();
        this.sourceModelsGroup.layout();
        this.targetModelsGroup.layout();
        this.librariesGroup.layout();
        this.rootContainer.layout();
        this.scrollContainer.setMinSize(this.rootContainer.computeSize(-1, -1));
        this.scrollContainer.layout();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        try {
            String fileName = configuration.getAttribute("ATL File Name", "");
            this.superimposedFromAdvancedTab = configuration.getAttribute("Superimpose", Collections.EMPTY_LIST);
            this.launcherNameFromAdvancedTab = configuration.getAttribute("ATL VM", "EMF-specific VM");
            if (!fileName.equals(this.atlPathText.getText())) {
                this.atlPathText.setText(fileName);
            }
        }
        catch (CoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        this.rebuild();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean isMetametamodel;
        String modelHandler;
        String location;
        HashMap<String, String> savedPaths = new HashMap<String, String>();
        HashMap<String, String> savedModelHandlers = new HashMap<String, String>();
        HashMap<String, String> savedLibraries = new HashMap<String, String>();
        LinkedHashMap<String, String> savedInput = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> savedOutput = new LinkedHashMap<String, String>();
        HashMap<String, String> savedType = new HashMap<String, String>();
        for (String string : this.sourceMetamodelsFromModule) {
            location = ((Text)this.metamodelsGroupWidgets.get(string).get("metamodelLocation")).getText();
            modelHandler = ((Combo)this.metamodelsGroupWidgets.get(string).get("modelHandlers")).getText();
            isMetametamodel = ((Button)this.metamodelsGroupWidgets.get(string).get("isMetametamodel")).getSelection();
            if (isMetametamodel) {
                savedPaths.put(string, "#" + modelHandler);
            } else {
                savedPaths.put(string, location);
            }
            savedModelHandlers.put(string, modelHandler);
        }
        for (String string : this.targetMetamodelsFromModule) {
            location = ((Text)this.metamodelsGroupWidgets.get(string).get("metamodelLocation")).getText();
            modelHandler = ((Combo)this.metamodelsGroupWidgets.get(string).get("modelHandlers")).getText();
            isMetametamodel = ((Button)this.metamodelsGroupWidgets.get(string).get("isMetametamodel")).getSelection();
            if (isMetametamodel) {
                savedPaths.put(string, "#" + modelHandler);
            } else {
                savedPaths.put(string, location);
            }
            savedModelHandlers.put(string, modelHandler);
        }
        for (String string : this.sourceModelsFromModule) {
            location = ((Text)this.sourceModelsGroupWidgets.get(string).get("location")).getText();
            savedPaths.put(string, location);
        }
        for (String string : this.targetModelsFromModule) {
            location = ((Text)this.targetModelsGroupWidgets.get(string).get("location")).getText();
            savedPaths.put(string, location);
        }
        for (String string : this.librariesFromModule) {
            location = ((Text)this.librariesGroupWidgets.get(string).get("location")).getText();
            savedLibraries.put(string, location);
        }
        for (Map.Entry entry : this.sourceC2RelationshipFromModule.entrySet()) {
            savedInput.put((String)entry.getKey(), (String)entry.getValue());
            savedType.put((String)entry.getKey(), "MODELINPUT");
            savedType.put((String)entry.getValue(), "METAMODELINPUT");
        }
        for (Map.Entry entry : this.targetC2RelationshipFromModule.entrySet()) {
            savedOutput.put((String)entry.getKey(), (String)entry.getValue());
            savedType.put((String)entry.getKey(), "MODELOUTPUT");
            savedType.put((String)entry.getValue(), "METAMODELOUTPUT");
        }
        configuration.setAttribute("ATL File Name", this.atlPathText.getText());
        configuration.setAttribute("Path", savedPaths);
        configuration.setAttribute("Model Handler", savedModelHandlers);
        configuration.setAttribute("Libs", savedLibraries);
        configuration.setAttribute("Input", savedInput);
        configuration.setAttribute("Output", savedOutput);
        configuration.setAttribute("ModelType", savedType);
        configuration.setAttribute("IS_REFINING", this.isRefining);
        configuration.setAttribute("ATL_COMPILER", this.atlcompiler);
        configuration.setAttribute("OrderedInput", new ArrayList(savedInput.keySet()));
        configuration.setAttribute("OrderedOutput", new ArrayList(savedOutput.keySet()));
    }

    public String getName() {
        return Messages.getString("ATLLaunchConstants.ATLCONFIGURATION");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.atlPathText.getText().equals("")) {
            this.setErrorMessage(Messages.getString("MainAtlTab.GIVETRANSFORMATIONNAME"));
            return false;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.metamodelsGroupWidgets.entrySet()) {
            String mName = entry.getKey();
            Map<String, Object> widgets = entry.getValue();
            Text metamodelLocation = (Text)widgets.get("metamodelLocation");
            Button isMetametamodel = (Button)widgets.get("isMetametamodel");
            if (metamodelLocation.getText().length() != 0 || isMetametamodel.getSelection()) continue;
            this.setErrorMessage(String.valueOf(Messages.getString("MainAtlTab.GIVEPATHFOR")) + mName);
            return false;
        }
        this.setErrorMessage(null);
        return this.canSaveGroupWidgets(this.sourceModelsGroupWidgets) && this.canSaveGroupWidgets(this.targetModelsGroupWidgets) && this.canSaveGroupWidgets(this.librariesGroupWidgets) && super.isValid(launchConfig);
    }

    private boolean canSaveGroupWidgets(Map<String, Map<String, Object>> modelsGroupWidgets) {
        for (Map.Entry<String, Map<String, Object>> entry : modelsGroupWidgets.entrySet()) {
            String mName = entry.getKey();
            Map<String, Object> widgets = entry.getValue();
            Text location = (Text)widgets.get("location");
            if (location.getText().length() != 0) continue;
            this.setErrorMessage(String.valueOf(Messages.getString("MainAtlTab.GIVEPATHFOR")) + mName);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public Image getImage() {
        return ATLCoreUIPlugin.getImage("atl_logo.gif");
    }

    private String editExternalPath(int type) {
        String ret = "";
        FileDialog fileDialog = type == 36 ? new FileDialog(this.getShell(), 8192) : new FileDialog(this.getShell(), 4096);
        if (type == 128) {
            String[] extensions = new String[ATLLaunchConstants.ATL_EXTENSIONS.length];
            int i = 0;
            while (i < ATLLaunchConstants.ATL_EXTENSIONS.length) {
                extensions[i] = "*." + ATLLaunchConstants.ATL_EXTENSIONS[i];
                ++i;
            }
            fileDialog.setFilterExtensions(extensions);
        } else {
            fileDialog.setFilterExtensions(new String[]{"*"});
        }
        String fileName = fileDialog.open();
        if (fileName != null) {
            ret = "ext:" + fileName;
        }
        return ret;
    }

    private String editPath(int type) {
        String ret = "";
        if (type == 36) {
            SaveAsDialog sad = new SaveAsDialog(this.getShell());
            sad.open();
            IPath outputPath = sad.getResult();
            if (outputPath != null) {
                ret = outputPath.toString();
            }
        } else {
            String[] extensions = null;
            if (type == 128) {
                extensions = ATLLaunchConstants.ATL_EXTENSIONS;
            } else if (type == 64) {
                extensions = new String[]{"asm"};
            }
            WorkspaceFileDialog dialog = new WorkspaceFileDialog(this.getShell(), extensions);
            dialog.open();
            Object result = dialog.getFirstResult();
            if (result != null && result instanceof IFile) {
                IFile currentFile = (IFile)result;
                ret = currentFile.getFullPath().toString();
            }
        }
        return ret;
    }

    private Map<String, Object> buildMetamodelsControls(Group parent, final String metamodelName, final int type, boolean removable) {
        String defaultLocation;
        HashMap<String, Object> thisGroupWidgets = new HashMap<String, Object>();
        final Label metamodelLabel = new Label((Composite)parent, 0);
        metamodelLabel.setText(String.valueOf(metamodelName) + ":");
        final Text metamodelLocation = new Text((Composite)parent, 2048);
        thisGroupWidgets.put("metamodelLocation", metamodelLocation);
        metamodelLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        if (this.metamodelLocations != null && (defaultLocation = this.metamodelLocations.get(metamodelName)) != null) {
            metamodelLocation.setText(defaultLocation);
        }
        final Button remove = new Button((Composite)parent, 0);
        remove.setText(Messages.getString("MainAtlTab.DELETE"));
        if (!removable) {
            new Label((Composite)parent, 0);
        }
        final Button isMetametamodel = new Button((Composite)parent, 32);
        thisGroupWidgets.put("isMetametamodel", isMetametamodel);
        isMetametamodel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        isMetametamodel.setText(Messages.getString("MainAtlTab.IS_METAMETA"));
        isMetametamodel.setToolTipText(Messages.getString("MainAtlTab.MODELHANDLERCHOICE"));
        final Label modelHandlerLabel = new Label((Composite)parent, 0);
        thisGroupWidgets.put("modelHandlerLabel", modelHandlerLabel);
        modelHandlerLabel.setText(Messages.getString("MainAtlTab.MODEL_HANDLER"));
        modelHandlerLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        final Combo modelHandlers = new Combo((Composite)parent, 8);
        thisGroupWidgets.put("modelHandlers", modelHandlers);
        modelHandlers.setItems(MainAtlTab.getModelHandlers());
        this.selectModelHandler(modelHandlers, null);
        modelHandlers.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        modelHandlers.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        boolean modelHandlersEnabled = this.modelHandlersEnabled(this.launcherNameFromAdvancedTab);
        modelHandlerLabel.setVisible(modelHandlersEnabled);
        modelHandlers.setVisible(modelHandlersEnabled);
        final Button browseWorkspace = new Button((Composite)parent, 0);
        browseWorkspace.setText(Messages.getString("MainAtlTab.WORKSPACE"));
        final Button browseFilesystem = new Button((Composite)parent, 0);
        browseFilesystem.setText(Messages.getString("MainAtlTab.FILE_SYSTEM"));
        final Button browseEMFRegistry = new Button((Composite)parent, 0);
        browseEMFRegistry.setText(Messages.getString("MainAtlTab.EMF_REGISTRY"));
        final Label filler = new Label((Composite)parent, 0);
        filler.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        metamodelLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (metamodelLocation.getText().startsWith("uri:")) {
                    MainAtlTab.this.selectModelHandler(modelHandlers, null);
                }
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        isMetametamodel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                metamodelLocation.setEnabled(!isMetametamodel.getSelection());
                browseWorkspace.setEnabled(!isMetametamodel.getSelection());
                browseFilesystem.setEnabled(!isMetametamodel.getSelection());
                browseEMFRegistry.setEnabled(!isMetametamodel.getSelection());
                if (!isMetametamodel.getSelection()) {
                    metamodelLocation.notifyListeners(24, null);
                }
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        modelHandlers.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editPath(type);
                if (path.trim().length() > 0) {
                    metamodelLocation.setText(path);
                }
            }
        });
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editExternalPath(type);
                if (path.trim().length() > 0) {
                    metamodelLocation.setText(path);
                }
            }
        });
        browseEMFRegistry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RegisteredPackageDialog dialog = new RegisteredPackageDialog(MainAtlTab.this.getShell());
                if (dialog.open() == 0) {
                    String text = dialog.getResultAsString();
                    if (!text.startsWith("platform:/plugin/")) {
                        text = "uri:" + text;
                    }
                    metamodelLocation.setText(text);
                }
            }
        });
        SelectionAdapter removeAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MainAtlTab.this.metamodelsGroupWidgets.remove(metamodelName);
                MainAtlTab.this.sourceMetamodelsFromModule.remove(metamodelName);
                MainAtlTab.this.targetMetamodelsFromModule.remove(metamodelName);
                MainAtlTab.this.updateModelsGroupFor(metamodelName);
                metamodelLabel.dispose();
                metamodelLocation.dispose();
                isMetametamodel.dispose();
                modelHandlerLabel.dispose();
                modelHandlers.dispose();
                browseWorkspace.dispose();
                browseFilesystem.dispose();
                browseEMFRegistry.dispose();
                remove.dispose();
                filler.dispose();
                MainAtlTab.this.layout();
            }
        };
        remove.addSelectionListener((SelectionListener)removeAdapter);
        thisGroupWidgets.put("removeAdapter", removeAdapter);
        if (!removable) {
            remove.dispose();
        }
        return thisGroupWidgets;
    }

    private boolean modelHandlersEnabled(String launcherName) {
        return launcherName.startsWith("Regular VM");
    }

    private Map<String, Object> buildModelsAndLibrariesControls(Group parent, final String modelName, String metamodelName, final int type, boolean removable) {
        HashMap<String, Object> thisGroupWidgets = new HashMap<String, Object>();
        final Label modelLabel = new Label((Composite)parent, 0);
        modelLabel.setText(String.valueOf(modelName) + ":");
        final Text location = new Text((Composite)parent, 2048);
        thisGroupWidgets.put("location", location);
        location.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        final Button remove = new Button((Composite)parent, 0);
        remove.setText(Messages.getString("MainAtlTab.DELETE"));
        thisGroupWidgets.put("remove", remove);
        if (!removable) {
            new Label((Composite)parent, 0);
        }
        final Label metamodelLabel = new Label((Composite)parent, 0);
        if (metamodelName != null) {
            metamodelLabel.setText(String.valueOf(Messages.getString("MainAtlTab.CONFORMS_TO")) + metamodelName);
        }
        final Button browseWorkspace = new Button((Composite)parent, 0);
        browseWorkspace.setText(Messages.getString("MainAtlTab.WORKSPACE"));
        browseWorkspace.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        final Button browseFilesystem = new Button((Composite)parent, 0);
        browseFilesystem.setText(Messages.getString("MainAtlTab.FILE_SYSTEM"));
        final Label filler = new Label((Composite)parent, 0);
        filler.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editPath(type);
                if (path.trim().length() > 0) {
                    location.setText(path);
                }
            }
        });
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editExternalPath(type);
                if (path.trim().length() > 0) {
                    location.setText(path);
                }
            }
        });
        SelectionAdapter removeAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (MainAtlTab.this.sourceModelsGroupWidgets.get(modelName) != null) {
                    MainAtlTab.this.sourceModelsGroupWidgets.remove(modelName);
                    MainAtlTab.this.sourceModelsFromModule.remove(modelName);
                    String mmName = (String)MainAtlTab.this.sourceC2RelationshipFromModule.remove(modelName);
                    MainAtlTab.this.updateMetamodelsGroupFor(mmName);
                } else if (MainAtlTab.this.targetModelsGroupWidgets.get(modelName) != null) {
                    MainAtlTab.this.targetModelsGroupWidgets.remove(modelName);
                    MainAtlTab.this.targetModelsFromModule.remove(modelName);
                    String mmName = (String)MainAtlTab.this.targetC2RelationshipFromModule.remove(modelName);
                    MainAtlTab.this.updateMetamodelsGroupFor(mmName);
                } else {
                    MainAtlTab.this.librariesGroupWidgets.remove(modelName);
                    MainAtlTab.this.librariesFromModule.remove(modelName);
                }
                modelLabel.dispose();
                metamodelLabel.dispose();
                location.dispose();
                browseWorkspace.dispose();
                browseFilesystem.dispose();
                remove.dispose();
                filler.dispose();
                MainAtlTab.this.layout();
            }
        };
        remove.addSelectionListener((SelectionListener)removeAdapter);
        thisGroupWidgets.put("removeAdapter", removeAdapter);
        if (!removable) {
            remove.dispose();
        }
        return thisGroupWidgets;
    }

    private void updateMetamodelsGroupFor(String metamodelName) {
        Map<String, Object> widgets;
        if (!this.sourceC2RelationshipFromModule.values().contains(metamodelName) && !this.targetC2RelationshipFromModule.values().contains(metamodelName) && (widgets = this.metamodelsGroupWidgets.get(metamodelName)) != null) {
            SelectionAdapter removeAdapter = (SelectionAdapter)widgets.get("removeAdapter");
            removeAdapter.widgetSelected(null);
        }
    }

    private void updateModelsGroupFor(String metamodelName) {
        SelectionAdapter removeAdapter;
        Map<String, Object> widgets;
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> i = this.sourceC2RelationshipFromModule.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (!entry.getValue().equals(metamodelName)) continue;
            i.remove();
            widgets = this.sourceModelsGroupWidgets.get(entry.getKey());
            if (widgets == null) continue;
            removeAdapter = (SelectionAdapter)widgets.get("removeAdapter");
            removeAdapter.widgetSelected(null);
        }
        i = this.targetC2RelationshipFromModule.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (!entry.getValue().equals(metamodelName)) continue;
            i.remove();
            widgets = this.targetModelsGroupWidgets.get(entry.getKey());
            if (widgets == null) continue;
            removeAdapter = (SelectionAdapter)widgets.get("removeAdapter");
            removeAdapter.widgetSelected(null);
        }
    }

    private void disposeGroupChildren(Group group) {
        Control[] controls = group.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    private void getModelsFromATLFile(IFile file) {
        AtlSourceManager sourceManager;
        IFile atlFile = null;
        String extension = file.getFileExtension().toLowerCase();
        if (extension.equals("asm")) {
            String atlPath = String.valueOf(file.getFullPath().toString().substring(0, file.getFullPath().toString().length() - extension.length())) + "atl";
            atlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(atlPath));
        } else if (extension.equals("atl")) {
            atlFile = file;
        } else {
            return;
        }
        if (!atlFile.isAccessible()) {
            return;
        }
        if (this.asmFileCache.containsKey(atlFile)) {
            sourceManager = this.asmFileCache.get(atlFile);
        } else {
            sourceManager = new AtlSourceManager();
            try {
                sourceManager.updateDataSource(atlFile.getContents());
            }
            catch (CoreException e) {
                return;
            }
            catch (IOException e) {
                return;
            }
            this.asmFileCache.put(atlFile, sourceManager);
        }
        this.atlcompiler = sourceManager.getAtlCompiler();
        switch (sourceManager.getATLFileType()) {
            case 1: {
                String metamodelName;
                String modelName;
                this.isRefining = sourceManager.isRefining();
                for (Map.Entry entry : sourceManager.getInputModels().entrySet()) {
                    modelName = (String)entry.getKey();
                    metamodelName = (String)entry.getValue();
                    if (!this.sourceMetamodelsFromModule.contains(metamodelName)) {
                        this.sourceMetamodelsFromModule.add(metamodelName);
                    }
                    if (this.sourceModelsFromModule.contains(modelName)) continue;
                    this.sourceModelsFromModule.add(modelName);
                    this.sourceC2RelationshipFromModule.put(modelName, metamodelName);
                }
                for (Map.Entry entry : sourceManager.getOutputModels().entrySet()) {
                    modelName = (String)entry.getKey();
                    metamodelName = (String)entry.getValue();
                    if (!this.targetMetamodelsFromModule.contains(metamodelName)) {
                        this.targetMetamodelsFromModule.add(metamodelName);
                    }
                    if (this.targetModelsFromModule.contains(modelName)) continue;
                    this.targetModelsFromModule.add(modelName);
                    this.targetC2RelationshipFromModule.put(modelName, metamodelName);
                }
                for (String library : sourceManager.getLibrariesImports()) {
                    if (this.nonLibraries.contains(library) || this.librariesFromModule.contains(library)) continue;
                    this.librariesFromModule.add(library);
                }
                break;
            }
            case 3: {
                for (Map.Entry entry : sourceManager.getInputModels().entrySet()) {
                    String modelName = (String)entry.getKey();
                    String metamodelName = (String)entry.getValue();
                    if (!this.sourceMetamodelsFromModule.contains(metamodelName)) {
                        this.sourceMetamodelsFromModule.add(metamodelName);
                    }
                    if (this.sourceModelsFromModule.contains(modelName)) continue;
                    this.sourceModelsFromModule.add(modelName);
                    this.sourceC2RelationshipFromModule.put(modelName, metamodelName);
                }
                for (String library : sourceManager.getLibrariesImports()) {
                    if (this.nonLibraries.contains(library) || this.librariesFromModule.contains(library)) continue;
                    this.librariesFromModule.add(library);
                }
                break;
            }
        }
        this.metamodelLocations = sourceManager.getMetamodelLocations();
    }

    private static String[] getModelHandlers() {
        ArrayList<String> mhs = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.vm.modelhandler");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                mhs.add(elements[j].getAttribute("name"));
                ++j;
            }
            ++i;
        }
        Collections.sort(mhs);
        return mhs.toArray(new String[0]);
    }

    private void selectModelHandler(Combo modelHandlers, Object modelHandlerName) {
        String modelHandlerToSet = "EMF";
        if (modelHandlerName != null || Arrays.asList(modelHandlers.getItems()).contains(modelHandlerName)) {
            modelHandlerToSet = modelHandlerName.toString();
        }
        int j = 0;
        while (j < modelHandlers.getItems().length) {
            if (modelHandlers.getItems()[j].equals(modelHandlerToSet)) {
                modelHandlers.select(j);
                break;
            }
            ++j;
        }
    }
}

