/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.services.format.DOMAttributeFormatter;
import org.eclipse.lemminx.services.format.DOMCDATAFormatter;
import org.eclipse.lemminx.services.format.DOMCommentFormatter;
import org.eclipse.lemminx.services.format.DOMDocTypeFormatter;
import org.eclipse.lemminx.services.format.DOMElementFormatter;
import org.eclipse.lemminx.services.format.DOMProcessingInstructionFormatter;
import org.eclipse.lemminx.services.format.DOMTextFormatter;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.TextEditUtils;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Text;

public class XMLFormatterDocument {
    private static final Logger LOGGER = Logger.getLogger(XMLFormatterDocument.class.getName());
    private static final String XML_SPACE_ATTR = "xml:space";
    private static final String XML_SPACE_ATTR_DEFAULT = "default";
    private static final String XML_SPACE_ATTR_PRESERVE = "preserve";
    private final DOMDocument xmlDocument;
    private final TextDocument textDocument;
    private final String lineDelimiter;
    private final SharedSettings sharedSettings;
    private final DOMProcessingInstructionFormatter processingInstructionFormatter;
    private final DOMDocTypeFormatter docTypeFormatter;
    private final DOMElementFormatter elementFormatter;
    private final DOMAttributeFormatter attributeFormatter;
    private final DOMTextFormatter textFormatter;
    private final DOMCommentFormatter commentFormatter;
    private final DOMCDATAFormatter cDATAFormatter;
    private final Collection<IFormatterParticipant> formatterParticipants;
    private final Map<String, Collection<CMDocument>> formattingContext;
    private int startOffset = -1;
    private int endOffset = -1;
    private CancelChecker cancelChecker;

    public XMLFormatterDocument(DOMDocument xmlDocument, Range range, SharedSettings sharedSettings, Collection<IFormatterParticipant> formatterParticipants) {
        this.xmlDocument = xmlDocument;
        this.textDocument = xmlDocument.getTextDocument();
        this.lineDelimiter = XMLFormatterDocument.computeLineDelimiter(this.textDocument);
        if (range != null) {
            try {
                this.startOffset = this.textDocument.offsetAt(range.getStart());
                this.endOffset = this.textDocument.offsetAt(range.getEnd());
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.sharedSettings = sharedSettings;
        this.formatterParticipants = formatterParticipants;
        this.docTypeFormatter = new DOMDocTypeFormatter(this);
        this.attributeFormatter = new DOMAttributeFormatter(this);
        this.elementFormatter = new DOMElementFormatter(this, this.attributeFormatter);
        this.processingInstructionFormatter = new DOMProcessingInstructionFormatter(this, this.attributeFormatter);
        this.textFormatter = new DOMTextFormatter(this);
        this.commentFormatter = new DOMCommentFormatter(this);
        this.cDATAFormatter = new DOMCDATAFormatter(this);
        this.formattingContext = new HashMap<String, Collection<CMDocument>>();
    }

    private static String computeLineDelimiter(TextDocument textDocument) {
        try {
            return textDocument.lineDelimiter(0);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return System.lineSeparator();
        }
    }

    public List<? extends TextEdit> format() throws BadLocationException {
        return this.format(this.xmlDocument, this.startOffset, this.endOffset);
    }

    public List<? extends TextEdit> format(DOMDocument document, int start, int end) {
        char c;
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        DOMNode currentDOMNode = XMLFormatterDocument.getDOMNodeToFormat(document, start, end);
        if (currentDOMNode != null) {
            int startOffset = currentDOMNode.getStart();
            XMLFormattingConstraints parentConstraints = this.getNodeConstraints(currentDOMNode);
            if (this.isMaxLineWidthSupported()) {
                int lineWidth = this.getMaxLineWidth();
                try {
                    int lineOffset = this.textDocument.lineOffsetAt(startOffset);
                    lineWidth -= startOffset - lineOffset;
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                parentConstraints.setAvailableLineWidth(lineWidth);
            }
            if (currentDOMNode.isElement()) {
                parentConstraints.setFormatElementCategory(this.getFormatElementCategory((DOMElement)currentDOMNode, null));
            } else {
                parentConstraints.setFormatElementCategory(FormatElementCategory.IgnoreSpace);
            }
            this.formatSiblings(edits, currentDOMNode, parentConstraints, start, end);
        }
        boolean insertFinalNewline = this.isInsertFinalNewline();
        String xml = this.textDocument.getText();
        int endDocument = xml.length() - 1;
        if (this.isTrimFinalNewlines() && (end == -1 || endDocument < end)) {
            this.trimFinalNewlines(insertFinalNewline, edits);
        }
        if (insertFinalNewline && endDocument >= 0 && (c = xml.charAt(endDocument)) != '\n' && (end == -1 || endDocument < end)) {
            try {
                Position pos = this.textDocument.positionAt(endDocument);
                pos.setCharacter(pos.getCharacter() + 1);
                Range range = new Range(pos, pos);
                edits.add(new TextEdit(range, this.lineDelimiter));
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.isTrimTrailingWhitespace()) {
            int i = xml.length() - 1;
            int lineDelimiterOffset = i + 1;
            char curr = xml.charAt(i);
            boolean removeSpaces = true;
            if (this.isTrimFinalNewlines() && !XMLFormatterDocument.isLineSeparator(curr) && (end == -1 || endDocument < end)) {
                while (Character.isWhitespace(curr) && i > 0) {
                    curr = xml.charAt(--i);
                }
                this.removeLeftSpaces(i, lineDelimiterOffset, edits);
                removeSpaces = false;
            }
            if (!this.isTrimFinalNewlines()) {
                while (i >= 0) {
                    curr = xml.charAt(i);
                    if (XMLFormatterDocument.isLineSeparator(curr)) {
                        if (removeSpaces) {
                            this.removeLeftSpaces(i + 1, lineDelimiterOffset, edits);
                        }
                        removeSpaces = true;
                        lineDelimiterOffset = i;
                    } else if (removeSpaces && (!Character.isWhitespace(curr) || XMLFormatterDocument.isLineSeparator(curr))) {
                        this.removeLeftSpaces(i, lineDelimiterOffset, edits);
                        removeSpaces = false;
                        return edits;
                    }
                    --i;
                }
            }
        }
        return edits;
    }

    private static DOMNode getDOMNodeToFormat(DOMDocument document, int start, int end) {
        if (start != -1 && end != -1) {
            DOMNode startNode = document.findNodeAt(start);
            DOMNode endNode = document.findNodeBefore(end);
            if (endNode.getStart() == start) {
                return endNode;
            }
            if (XMLFormatterDocument.isCoverNode(startNode, endNode)) {
                return startNode;
            }
            if (XMLFormatterDocument.isCoverNode(endNode, startNode)) {
                return endNode;
            }
            DOMNode startParent = startNode.getParentNode();
            for (DOMNode endParent = endNode.getParentNode(); startParent != null && endParent != null; startParent = startParent.getParentNode(), endParent = endParent.getParentNode()) {
                if (XMLFormatterDocument.isCoverNode(startParent, endParent)) {
                    return startParent;
                }
                if (!XMLFormatterDocument.isCoverNode(endParent, startParent)) continue;
                return endParent;
            }
        }
        return document;
    }

    private static boolean isCoverNode(DOMNode startNode, DOMNode endNode) {
        return startNode.getStart() < endNode.getStart() && startNode.getEnd() > endNode.getEnd() || startNode == endNode;
    }

    private XMLFormattingConstraints getNodeConstraints(DOMNode node) {
        XMLFormattingConstraints result = new XMLFormattingConstraints();
        int indentLevel = 0;
        while (node != null) {
            if ((node = node.getParentElement()) == null) continue;
            ++indentLevel;
        }
        result.setIndentLevel(indentLevel);
        return result;
    }

    private void formatSiblings(List<TextEdit> edits, DOMNode domNode, XMLFormattingConstraints parentConstraints, int start, int end) {
        for (DOMNode currentDOMNode = domNode; currentDOMNode != null; currentDOMNode = currentDOMNode.getNextSibling()) {
            if (this.cancelChecker != null) {
                this.cancelChecker.checkCanceled();
            }
            this.format(currentDOMNode, parentConstraints, start, end, edits);
        }
    }

    public void format(DOMNode child, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        switch (child.getNodeType()) {
            case 10: {
                DOMDocumentType docType = (DOMDocumentType)child;
                this.docTypeFormatter.formatDocType(docType, parentConstraints, start, end, edits);
                break;
            }
            case 9: {
                DOMDocument document = (DOMDocument)child;
                this.formatChildren(document, parentConstraints, start, end, edits);
                break;
            }
            case 7: {
                DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)child;
                this.processingInstructionFormatter.formatProcessingInstruction(processingInstruction, parentConstraints, edits);
                break;
            }
            case 1: {
                DOMElement element = (DOMElement)child;
                this.elementFormatter.formatElement(element, parentConstraints, start, end, edits);
                break;
            }
            case 3: {
                DOMText textNode = (DOMText)child;
                this.textFormatter.formatText(textNode, parentConstraints, start, end, edits);
                break;
            }
            case 8: {
                DOMComment commentNode = (DOMComment)child;
                this.commentFormatter.formatComment(commentNode, parentConstraints, start, end, edits);
                break;
            }
            case 4: {
                DOMCDATASection cDATANode = (DOMCDATASection)child;
                this.cDATAFormatter.formatCDATASection(cDATANode, parentConstraints, edits);
                break;
            }
            default: {
                if (!this.isMaxLineWidthSupported()) break;
                int width = this.updateLineWidthWithLastLine(child, parentConstraints.getAvailableLineWidth());
                parentConstraints.setAvailableLineWidth(width);
            }
        }
    }

    public void formatChildren(DOMNode currentDOMNode, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        for (DOMNode child : currentDOMNode.getChildren()) {
            this.format(child, parentConstraints, start, end, edits);
        }
    }

    public void formatAttributeValue(DOMAttr attr, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        if (this.formatterParticipants != null) {
            for (IFormatterParticipant formatterParticipant : this.formatterParticipants) {
                try {
                    if (!formatterParticipant.formatAttributeValue(attr, this, parentConstraints, this.getFormattingSettings(), edits)) continue;
                    return;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while processing format attributes for the participant '" + formatterParticipant.getClass().getName() + "'.", e);
                }
            }
        }
    }

    public void removeLeftSpaces(int leftLimit, int to, List<TextEdit> edits) {
        this.replaceLeftSpacesWith(leftLimit, to, "", edits);
    }

    public void replaceLeftSpacesWithOneSpace(int leftLimit, int to, List<TextEdit> edits) {
        this.replaceLeftSpacesWith(leftLimit, to, " ", edits);
    }

    void replaceLeftSpacesWith(int leftLimit, int to, String replacement, List<TextEdit> edits) {
        int from = this.adjustOffsetWithLeftWhitespaces(leftLimit, to);
        if (from >= 0) {
            this.createTextEditIfNeeded(from, to, replacement, edits);
        }
    }

    void replaceQuoteWithPreferred(int from, int to, List<TextEdit> edits) {
        this.createTextEditIfNeeded(from, to, this.getQuotationAsString(), edits);
    }

    public int adjustOffsetWithLeftWhitespaces(int leftLimit, int to) {
        return TextEditUtils.adjustOffsetWithLeftWhitespaces(leftLimit, to, this.textDocument.getText());
    }

    public int replaceLeftSpacesWithIndentation(int indentLevel, int leftLimit, int to, boolean addLineSeparator, List<TextEdit> edits) {
        int from = this.adjustOffsetWithLeftWhitespaces(leftLimit, to);
        if (from >= 0) {
            String expectedSpaces = this.getIndentSpaces(indentLevel, addLineSeparator);
            this.createTextEditIfNeeded(from, to, expectedSpaces, edits);
            return expectedSpaces.length();
        }
        return 0;
    }

    public int replaceLeftSpacesWithIndentationWithMultiNewLines(int indentLevel, int leftLimit, int offset, int newLineCount, List<TextEdit> edits) {
        int from = this.adjustOffsetWithLeftWhitespaces(leftLimit, offset);
        if (from >= 0) {
            String expectedSpaces = this.getIndentSpacesWithMultiNewLines(indentLevel, newLineCount);
            this.createTextEditIfNeeded(from, offset, expectedSpaces, edits);
            return expectedSpaces.length();
        }
        return 0;
    }

    public int replaceLeftSpacesWithIndentationWithOffsetSpaces(int indentSpace, int leftLimit, int to, boolean addLineSeparator, List<TextEdit> edits) {
        int from = this.adjustOffsetWithLeftWhitespaces(leftLimit, to);
        if (from >= 0) {
            String expectedSpaces = this.getIndentSpacesWithOffsetSpaces(indentSpace, addLineSeparator);
            this.createTextEditIfNeeded(from, to, expectedSpaces, edits);
            return expectedSpaces.length();
        }
        return 0;
    }

    public void replaceLeftSpacesWithIndentationPreservedNewLines(int spaceStart, int spaceEnd, int indentLevel, List<TextEdit> edits) {
        int preservedNewLines = this.getFormattingSettings().getPreservedNewlines();
        int currentNewLineCount = XMLFormatterDocument.getExistingNewLineCount(this.textDocument.getText(), spaceEnd, this.lineDelimiter);
        if (currentNewLineCount > preservedNewLines) {
            this.replaceLeftSpacesWithIndentationWithMultiNewLines(indentLevel, spaceStart, spaceEnd, preservedNewLines + 1, edits);
        } else {
            int newLineCount = currentNewLineCount == 0 ? 1 : currentNewLineCount;
            this.replaceLeftSpacesWithIndentationWithMultiNewLines(indentLevel, spaceStart, spaceEnd, newLineCount, edits);
        }
    }

    boolean hasLineBreak(int from, int to) {
        String text = this.textDocument.getText();
        for (int i = from; i < to; ++i) {
            char c = text.charAt(i);
            if (!XMLFormatterDocument.isLineSeparator(c)) continue;
            return true;
        }
        return false;
    }

    public int getNormalizedLength(int from, int to) {
        String text = this.textDocument.getText();
        int contentOffset = 0;
        for (int i = from; i < to; ++i) {
            if (Character.isWhitespace(text.charAt(i)) && !Character.isWhitespace(text.charAt(i + 1))) {
                to -= contentOffset;
                contentOffset = 0;
                continue;
            }
            if (!Character.isWhitespace(text.charAt(i))) continue;
            ++contentOffset;
        }
        return to;
    }

    public int getOffsetWithPreserveLineBreaks(int from, int to, int tabSize, boolean isInsertSpaces) {
        int initialTo = to;
        String text = this.textDocument.getText();
        for (int i = to; i > from; --i) {
            if (text.charAt(i) == '\t') {
                to -= tabSize;
                continue;
            }
            if (XMLFormatterDocument.isLineSeparator(text.charAt(i))) {
                int prevIndent = 0;
                for (int j = i + 1; j < initialTo; ++j) {
                    if (text.charAt(j) == '\t' && !isInsertSpaces) {
                        prevIndent += tabSize;
                        continue;
                    }
                    if (Character.isWhitespace(text.charAt(j))) {
                        ++prevIndent;
                        continue;
                    }
                    return to += prevIndent - tabSize;
                }
                continue;
            }
            if (text.charAt(i) == ' ' && StringUtils.isQuote(text.charAt(i - 1))) {
                int j = 1;
                while (text.charAt(i + j) == ' ') {
                    ++to;
                    ++j;
                }
                --to;
                continue;
            }
            --to;
        }
        return to;
    }

    int updateLineWidthWithLastLine(DOMNode child, int availableLineWidth) {
        char c;
        String text = this.textDocument.getText();
        int lineWidth = availableLineWidth;
        int end = child.getEnd();
        if (end < text.length() && XMLFormatterDocument.isLineSeparator(c = text.charAt(end))) {
            return this.getMaxLineWidth();
        }
        for (int i = end - 1; i > child.getStart(); --i) {
            char c2 = text.charAt(i);
            if (XMLFormatterDocument.isLineSeparator(c2)) {
                return lineWidth;
            }
            --lineWidth;
        }
        return lineWidth;
    }

    private static boolean isLineSeparator(char c) {
        return c == '\r' || c == '\n';
    }

    public int getLineBreakOffset(int startAttr, int start) {
        String text = this.textDocument.getText();
        for (int i = startAttr; i < start; ++i) {
            char c = text.charAt(i);
            if (!XMLFormatterDocument.isLineSeparator(c)) continue;
            return i;
        }
        return -1;
    }

    void insertLineBreak(int start, int end, List<TextEdit> edits) {
        this.createTextEditIfNeeded(start, end, this.lineDelimiter, edits);
    }

    void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        if (spaceStart >= 0) {
            spaceEnd = spaceEnd == -1 ? spaceStart + 1 : spaceEnd + 1;
            this.replaceLeftSpacesWithOneSpace(spaceStart, spaceEnd, edits);
        }
    }

    public FormatElementCategory getFormatElementCategory(DOMElement element, XMLFormattingConstraints parentConstraints) {
        if (!element.isClosed()) {
            return parentConstraints.getFormatElementCategory();
        }
        FormatElementCategory fromSettings = this.getFormattingSettings().getFormatElementCategory(element);
        if (fromSettings != null) {
            return fromSettings;
        }
        for (IFormatterParticipant participant : this.formatterParticipants) {
            FormatElementCategory fromParticipant = participant.getFormatElementCategory(element, parentConstraints, this.formattingContext, this.sharedSettings);
            if (fromParticipant == null) continue;
            return fromParticipant;
        }
        if (XML_SPACE_ATTR_PRESERVE.equals(element.getAttribute(XML_SPACE_ATTR))) {
            return FormatElementCategory.PreserveSpace;
        }
        if (parentConstraints != null && parentConstraints.getFormatElementCategory() == FormatElementCategory.PreserveSpace && !XML_SPACE_ATTR_DEFAULT.equals(element.getAttribute(XML_SPACE_ATTR))) {
            return FormatElementCategory.PreserveSpace;
        }
        boolean hasElement = false;
        boolean hasText = false;
        boolean onlySpaces = true;
        for (DOMNode child : element.getChildren()) {
            if (child.isElement() || child.isComment() || child.isProcessingInstruction()) {
                hasElement = true;
            } else if (child.isText() && !(onlySpaces = ((Text)((Object)child)).isElementContentWhitespace())) {
                hasText = true;
            }
            if (!hasElement || !hasText) continue;
            return FormatElementCategory.MixedContent;
        }
        if (hasElement && onlySpaces) {
            return FormatElementCategory.IgnoreSpace;
        }
        return FormatElementCategory.NormalizeSpace;
    }

    void createTextEditIfNeeded(int from, int to, String expectedContent, List<TextEdit> edits) {
        TextEdit edit = TextEditUtils.createTextEditIfNeeded(from, to, expectedContent, this.textDocument);
        if (edit != null) {
            edits.add(edit);
        }
    }

    public boolean shouldCollapseEmptyElement(DOMElement element, SharedSettings sharedSettings) {
        for (IFormatterParticipant participant : this.formatterParticipants) {
            if (participant.shouldCollapseEmptyElement(element, sharedSettings)) continue;
            return false;
        }
        return true;
    }

    private String getIndentSpaces(int level, boolean addLineSeparator) {
        StringBuilder spaces = new StringBuilder();
        if (addLineSeparator) {
            spaces.append(this.lineDelimiter);
        }
        for (int i = 0; i < level; ++i) {
            if (this.isInsertSpaces()) {
                for (int j = 0; j < this.getTabSize(); ++j) {
                    spaces.append(" ");
                }
                continue;
            }
            spaces.append("\t");
        }
        return spaces.toString();
    }

    private String getIndentSpacesWithMultiNewLines(int level, int newLineCount) {
        StringBuilder spaces = new StringBuilder();
        while (newLineCount != 0) {
            spaces.append(this.lineDelimiter);
            --newLineCount;
        }
        for (int i = 0; i < level; ++i) {
            if (this.isInsertSpaces()) {
                for (int j = 0; j < this.getTabSize(); ++j) {
                    spaces.append(" ");
                }
                continue;
            }
            spaces.append("\t");
        }
        return spaces.toString();
    }

    private String getIndentSpacesWithOffsetSpaces(int spaceCount, boolean addLineSeparator) {
        int i;
        StringBuilder spaces = new StringBuilder();
        if (addLineSeparator) {
            spaces.append(this.lineDelimiter);
        }
        int spaceOffset = spaceCount % this.getTabSize();
        for (i = 0; i < spaceCount / this.getTabSize(); ++i) {
            if (this.isInsertSpaces()) {
                for (int j = 0; j < this.getTabSize(); ++j) {
                    spaces.append(" ");
                }
                continue;
            }
            spaces.append("\t");
        }
        for (i = 0; i < spaceOffset; ++i) {
            spaces.append(" ");
        }
        return spaces.toString();
    }

    private void trimFinalNewlines(boolean insertFinalNewline, List<TextEdit> edits) {
        int end;
        int i;
        String xml = this.textDocument.getText();
        for (i = end = xml.length() - 1; i >= 0 && XMLFormatterDocument.isLineSeparator(xml.charAt(i)); --i) {
        }
        if (end > i) {
            if (insertFinalNewline) {
                ++i;
                if (xml.charAt(end - 1) == '\r') {
                    ++i;
                }
            }
            if (end > i) {
                try {
                    Position endPos = this.textDocument.positionAt(end + 1);
                    Position startPos = this.textDocument.positionAt(i + 1);
                    Range range = new Range(startPos, endPos);
                    edits.add(new TextEdit(range, ""));
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public static int getExistingNewLineCount(String text, int offset, String delimiter) {
        boolean delimiterHasTwoCharacters = delimiter.length() == 2;
        int newLineCounter = 0;
        for (int i = offset; i > 1; --i) {
            String c;
            if (!Character.isWhitespace(text.charAt(i - 1))) {
                if (!delimiterHasTwoCharacters && delimiter.equals(c = String.valueOf(text.charAt(i)))) {
                    ++newLineCounter;
                }
                return newLineCounter;
            }
            if (delimiterHasTwoCharacters) {
                c = text.substring(i - 2, i);
                if (!delimiter.equals(c)) continue;
                ++newLineCounter;
                --i;
                continue;
            }
            c = String.valueOf(text.charAt(i));
            if (!delimiter.equals(c)) continue;
            ++newLineCounter;
        }
        return newLineCounter;
    }

    public boolean isMaxLineWidthSupported() {
        return this.getMaxLineWidth() != 0;
    }

    public int getMaxLineWidth() {
        return this.getFormattingSettings().getMaxLineWidth();
    }

    private int getTabSize() {
        return this.getFormattingSettings().getTabSize();
    }

    private boolean isInsertSpaces() {
        return this.getFormattingSettings().isInsertSpaces();
    }

    private boolean isTrimFinalNewlines() {
        return this.getFormattingSettings().isTrimFinalNewlines();
    }

    private boolean isInsertFinalNewline() {
        return this.getFormattingSettings().isInsertFinalNewline();
    }

    private boolean isTrimTrailingWhitespace() {
        return this.getFormattingSettings().isTrimTrailingWhitespace();
    }

    private String getQuotationAsString() {
        return this.sharedSettings.getPreferences().getQuotationAsString();
    }

    private XMLFormattingOptions getFormattingSettings() {
        return this.getSharedSettings().getFormattingSettings();
    }

    SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    String getLineDelimiter() {
        return this.lineDelimiter;
    }

    String getText() {
        return this.textDocument.getText();
    }

    public int getLineAtOffset(int offset) {
        try {
            return this.textDocument.lineOffsetAt(offset);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }
}

