/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.utils.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.TypeInfo;

public class DOMAttr
extends DOMNode
implements Attr {
    public static final String XMLNS_ATTR = "xmlns";
    public static final String XMLNS_NO_DEFAULT_ATTR = "xmlns:";
    private String name;
    private final AttrName nodeAttrName;
    private int delimiter;
    private AttrValue nodeAttrValue;
    private String quotelessValue;
    private String originalValue;
    private final DOMNode ownerElement;

    public DOMAttr(String name, DOMNode ownerElement) {
        this(name, -1, -1, ownerElement);
    }

    public DOMAttr(String name, int start, int end, DOMNode ownerElement) {
        super(-1, -1);
        this.name = name;
        this.delimiter = -1;
        this.nodeAttrName = start != -1 ? new AttrName(start, end) : null;
        this.ownerElement = ownerElement;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.name == null && this.nodeAttrName != null) {
            this.name = this.nodeAttrName.getContent();
        }
        return this.name;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public String getLocalName() {
        String name = this.getName();
        int colonIndex = name.indexOf(":");
        if (colonIndex > 0) {
            return name.substring(colonIndex + 1);
        }
        return name;
    }

    @Override
    public DOMElement getOwnerElement() {
        return this.ownerElement.isElement() ? (DOMElement)this.ownerElement : null;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return this.ownerElement != null ? this.ownerElement.getOwnerDocument() : null;
    }

    @Override
    public String getValue() {
        this.getOriginalValue();
        return this.quotelessValue;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getSpecified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.setValue(value, -1, -1);
    }

    public DOMRange getNodeAttrName() {
        return this.nodeAttrName;
    }

    public void setDelimiter(int delimiter) {
        this.delimiter = delimiter;
    }

    public boolean hasDelimiter() {
        return this.delimiter != -1;
    }

    public String getOriginalValue() {
        if (this.originalValue == null && this.nodeAttrValue != null) {
            this.originalValue = this.nodeAttrValue.getContent();
            this.quotelessValue = StringUtils.convertToQuotelessValue(this.originalValue);
        }
        return this.originalValue;
    }

    public void setValue(String value, int start, int end) {
        this.originalValue = value;
        this.quotelessValue = StringUtils.convertToQuotelessValue(value);
        this.nodeAttrValue = start != -1 ? new AttrValue(start, end) : null;
    }

    public DOMRange getNodeAttrValue() {
        return this.nodeAttrValue;
    }

    public boolean valueContainsOffset(int offset) {
        return this.nodeAttrValue != null && offset >= this.nodeAttrValue.getStart() && offset < this.nodeAttrValue.getEnd();
    }

    @Override
    public String getPrefix() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        String prefix = null;
        int index = name.indexOf(":");
        if (index != -1) {
            prefix = name.substring(0, index);
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI() {
        if (this.ownerElement == null || this.ownerElement.getNodeType() != 1) {
            return null;
        }
        String prefix = this.getPrefix();
        return ((DOMElement)this.ownerElement).getNamespaceURI(prefix);
    }

    public boolean isXmlns() {
        return DOMAttr.isXmlns(this.getName());
    }

    public static boolean isXmlns(String attributeName) {
        return attributeName.startsWith(XMLNS_ATTR);
    }

    public boolean isDefaultXmlns() {
        return DOMAttr.isDefaultXmlns(this.getName());
    }

    public static boolean isDefaultXmlns(String attributeName) {
        return attributeName.equals(XMLNS_ATTR);
    }

    public String extractPrefixFromXmlns() {
        String name = this.getName();
        if (this.isDefaultXmlns()) {
            return name.substring(XMLNS_ATTR.length(), name.length());
        }
        return name.substring(XMLNS_NO_DEFAULT_ATTR.length(), name.length());
    }

    public String getPrefixIfMatchesURI(String uri) {
        String value;
        if (this.isXmlns() && (value = this.getValue()) != null && value.equals(uri)) {
            if (this.isDefaultXmlns()) {
                return null;
            }
            return this.extractPrefixFromXmlns();
        }
        return null;
    }

    public boolean isNoDefaultXmlns() {
        return DOMAttr.isNoDefaultXmlns(this.getName());
    }

    public static boolean isNoDefaultXmlns(String attributeName) {
        return attributeName.startsWith(XMLNS_NO_DEFAULT_ATTR);
    }

    @Override
    public DOMNode getNextSibling() {
        DOMElement parentNode = this.getOwnerElement();
        if (parentNode == null) {
            return null;
        }
        List<DOMAttr> children = parentNode.getAttributeNodes();
        int nextIndex = children.indexOf(this) + 1;
        return nextIndex < children.size() ? (DOMNode)children.get(nextIndex) : null;
    }

    public boolean isIncluded(int offset) {
        return DOMNode.isIncluded(this.getStart(), this.getEnd(), offset);
    }

    @Override
    public int getStart() {
        return this.nodeAttrName.getStart();
    }

    @Override
    public int getEnd() {
        if (this.nodeAttrValue != null) {
            return this.nodeAttrValue.getEnd();
        }
        if (this.hasDelimiter()) {
            return this.delimiter + 1;
        }
        return this.nodeAttrName.getEnd();
    }

    public int hashCode() {
        String name = this.getName();
        int prime = 31;
        int result = 1;
        result = 31 * result + (name == null ? 0 : name.hashCode());
        result = 31 * result + (this.quotelessValue == null ? 0 : this.quotelessValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMAttr other = (DOMAttr)obj;
        String name = this.getName();
        if (name == null ? other.getName() != null : !name.equals(other.getName())) {
            return false;
        }
        String value = this.getValue();
        return !(value == null ? other.getValue() != null : !value.equals(other.getValue()));
    }

    public int getDelimiterOffset() {
        return this.delimiter;
    }

    class AttrValue
    extends AttrNameOrValue {
        public AttrValue(int start, int end) {
            super(start, end);
        }

        @Override
        public String getContent() {
            if (this.getOwnerAttr().delimiter < this.getStart()) {
                return super.getContent();
            }
            return null;
        }
    }

    class AttrName
    extends AttrNameOrValue {
        public AttrName(int start, int end) {
            super(start, end);
        }
    }

    abstract class AttrNameOrValue
    implements DOMRange {
        private final int start;
        private final int end;

        public AttrNameOrValue(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        public DOMAttr getOwnerAttr() {
            return DOMAttr.this;
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return this.getOwnerAttr().getOwnerDocument();
        }

        public String getContent() {
            return this.getOwnerDocument().getText().substring(this.getStart(), this.getEnd());
        }
    }
}

