/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.properties;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.cxf.core.CXFClasspathContainer;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;

public class CXFPropertyPage
extends PropertyPage {
    private IJavaProject javaProject;
    private IProject project;
    private ComboViewer installationsComboViewer;
    private Link link;
    private CXFInstall defaultInstall;
    private CXFContext context = CXFCorePlugin.getDefault().getJava2WSContext();

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        if (!(element instanceof IJavaProject)) {
            return null;
        }
        this.javaProject = (IJavaProject)element;
        this.project = this.javaProject.getProject();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.link = new Link(composite, 0);
        this.link.setText(CXFUIMessages.CXF_CONFIGURE_INSTALLED_RUNTIMES_LABEL);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = CXFPropertyPage.this.installationsComboViewer.getCombo().getSelectionIndex();
                int result = PreferencesUtil.createPreferenceDialogOn((Shell)CXFPropertyPage.this.getShell(), (String)"org.eclipse.jst.ws.cxf.ui.CXFRuntimePreferencesPage", (String[])new String[]{"org.eclipse.jst.ws.cxf.ui.CXFRuntimePreferencesPage"}, null).open();
                if (result == 0) {
                    CXFPropertyPage.this.installationsComboViewer.refresh();
                    CXFPropertyPage.this.installationsComboViewer.getCombo().select(selectedIndex);
                }
            }
        });
        GridData gridData = new GridData(0x1000008, 4, true, false);
        gridData.horizontalSpan = 2;
        this.link.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(CXFUIMessages.CXF_PROPERTY_PAGE_RUNTIME_LABEL);
        this.installationsComboViewer = new ComboViewer(composite, 2056);
        gridData = new GridData(4, 4, true, false);
        this.installationsComboViewer.getCombo().setLayoutData((Object)gridData);
        this.installationsComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.installationsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CXFInstall) {
                    CXFInstall cxfInstall = (CXFInstall)element;
                    return String.valueOf(cxfInstall.getType()) + " " + cxfInstall.getVersion();
                }
                return "";
            }
        });
        Collection installations = this.context.getInstallations().values();
        this.installationsComboViewer.setInput(installations);
        String intalledVersion = CXFCorePlugin.getDefault().getCXFRuntimeVersion(this.project);
        this.defaultInstall = (CXFInstall)this.context.getInstallations().get(intalledVersion);
        if (this.defaultInstall != null) {
            this.installationsComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.defaultInstall), true);
        }
        return composite;
    }

    public boolean performOk() {
        CXFInstall selectedInstall = this.getSelectedInstall();
        if (selectedInstall != null) {
            CXFCorePlugin.getDefault().setCXFRuntimeVersion(this.project, selectedInstall.getVersion());
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jst.ws.cxf.core.CXF_CLASSPATH_CONTAINER");
            if (classpathContainerInitializer != null) {
                Path containerPath = new Path("org.eclipse.jst.ws.cxf.core.CXF_CLASSPATH_CONTAINER");
                CXFClasspathContainer cxfClasspathContainer = new CXFClasspathContainer((IPath)containerPath, this.javaProject);
                try {
                    classpathContainerInitializer.requestClasspathContainerUpdate((IPath)containerPath, this.javaProject, (IClasspathContainer)cxfClasspathContainer);
                }
                catch (CoreException ce) {
                    CXFCorePlugin.log((IStatus)ce.getStatus());
                }
            }
        }
        return true;
    }

    private CXFInstall getSelectedInstall() {
        StructuredSelection structuredSelection = (StructuredSelection)this.installationsComboViewer.getSelection();
        if (!structuredSelection.isEmpty()) {
            CXFInstall selectedInstall = (CXFInstall)structuredSelection.getFirstElement();
            return selectedInstall;
        }
        return null;
    }

    protected void performDefaults() {
        CXFInstall defaultInstall = (CXFInstall)this.context.getInstallations().get(this.context.getDefaultRuntimeVersion());
        if (defaultInstall != null) {
            this.installationsComboViewer.setSelection((ISelection)new StructuredSelection((Object)defaultInstall), true);
        }
        super.performDefaults();
    }
}

