/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.IJSFCoreConstants;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public enum JSFVersion {
    UNKNOWN,
    V1_0,
    V1_1,
    V1_2,
    V2_0,
    V2_1,
    V2_2,
    V2_3;


    public String toString() {
        switch (this) {
            case V1_0: {
                return "1.0";
            }
            case V1_1: {
                return "1.1";
            }
            case V1_2: {
                return "1.2";
            }
            case V2_0: {
                return "2.0";
            }
            case V2_1: {
                return "2.1";
            }
            case V2_2: {
                return "2.2";
            }
            case V2_3: {
                return "2.3";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        throw new IllegalStateException("Missing string conversion: " + this.name());
    }

    public static JSFVersion valueOfString(String valueAsString) {
        if ("1.0".equals(valueAsString)) {
            return V1_0;
        }
        if ("1.1".equals(valueAsString)) {
            return V1_1;
        }
        if ("1.2".equals(valueAsString)) {
            return V1_2;
        }
        if ("2.0".equals(valueAsString)) {
            return V2_0;
        }
        if ("2.1".equals(valueAsString)) {
            return V2_1;
        }
        if ("2.2".equals(valueAsString)) {
            return V2_2;
        }
        if ("2.3".equals(valueAsString)) {
            return V2_3;
        }
        if ("unknown".equals(valueAsString)) {
            return UNKNOWN;
        }
        return null;
    }

    public static JSFVersion valueOfFacetVersion(IProjectFacetVersion facetVersion) {
        if (!IJSFCoreConstants.isJSFFacet(facetVersion.getProjectFacet())) {
            throw new IllegalArgumentException("Not a JSF facet: " + facetVersion.getProjectFacet().toString());
        }
        String versionString = facetVersion.getVersionString();
        if (versionString != null) {
            return JSFVersion.valueOfString(versionString);
        }
        return null;
    }

    public static JSFVersion valueOfProject(IProject project) {
        try {
            IProjectFacetVersion projectFacetVersion;
            IFacetedProject fProj;
            if (project != null && FacetedProjectFramework.isFacetedProject((IProject)project) && (fProj = ProjectFacetsManager.create((IProject)project)) != null && (projectFacetVersion = fProj.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jst.jsf"))) != null) {
                return JSFVersion.valueOfFacetVersion(projectFacetVersion);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static JSFVersion guessJSFVersion(IProject project) {
        JSFVersion jsfVersion = JSFVersion.valueOfProject(project);
        if (jsfVersion == null) {
            try {
                IJavaProject javaProj = JavaCore.create((IProject)project);
                if (javaProj != null && javaProj.exists() && javaProj.findType("javax.faces.component.html.HtmlBody") != null) {
                    jsfVersion = V2_0;
                    if (javaProj.findType("javax.faces.view.facelets.FaceletCacheFactory") != null) {
                        jsfVersion = V2_1;
                    }
                }
            }
            catch (JavaModelException jme) {
                JSFCorePlugin.log((Exception)((Object)jme), "Trying to guess jsf version");
            }
        }
        return jsfVersion;
    }

    public static boolean guessAtLeast(JSFVersion atLeastThisVersion, IProject project) {
        if (project != null && project.isAccessible()) {
            JSFVersion guessJSFVersion = JSFVersion.guessJSFVersion(project);
            return guessJSFVersion != null && guessJSFVersion.compareTo(atLeastThisVersion) >= 0;
        }
        return false;
    }
}

