/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IAuthenticator2;
import org.eclipse.net4j.util.security.SecurityUtil;

public class DefaultRepositoryProtector
extends Container<IRepositoryProtector.UserInfo>
implements IRepositoryProtector,
IAuthenticator2,
IPermissionManager,
IRepository.WriteAccessHandler {
    private static final String PROP_PROTECTOR_INITIALIZED = "org.eclipse.emf.cdo.server.protectorInitialized";
    private IRepository repository;
    private final ConcurrentMap<IRepository, SecondaryRepository> secondaryRepositories = new ConcurrentHashMap<IRepository, SecondaryRepository>();
    private final MessageDigest passwordDigester;
    private final byte[] salt;
    private final Map<String, SessionUserInfo> sessionUserInfos = new HashMap<String, SessionUserInfo>();
    private final IListener sessionManagerListener = new ContainerEventAdapter<ISession>(){

        protected void onAdded(IContainer<ISession> container, ISession session) {
            DefaultRepositoryProtector.this.sessionAdded(session);
        }

        protected void onRemoved(IContainer<ISession> container, ISession session) {
            DefaultRepositoryProtector.this.sessionRemoved(session);
        }
    };
    private IRepositoryProtector.UserAuthenticator userAuthenticator;
    private IRepositoryProtector.AuthorizationStrategy authorizationStrategy;
    private final ConcurrentArray<IRepositoryProtector.RevisionAuthorizer> revisionAuthorizers = new ConcurrentArray<IRepositoryProtector.RevisionAuthorizer>(){

        protected IRepositoryProtector.RevisionAuthorizer[] newArray(int length) {
            return new IRepositoryProtector.RevisionAuthorizer[length];
        }
    };
    private final ConcurrentArray<IRepositoryProtector.CommitHandler> commitHandlers = new ConcurrentArray<IRepositoryProtector.CommitHandler>(){

        protected IRepositoryProtector.CommitHandler[] newArray(int length) {
            return new IRepositoryProtector.CommitHandler[length];
        }
    };
    private boolean firstTime;

    public DefaultRepositoryProtector() {
        try {
            this.passwordDigester = MessageDigest.getInstance("MD5");
            this.salt = new byte[32];
            new Random(System.currentTimeMillis()).nextBytes(this.salt);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public final boolean isFirstTime() {
        return this.firstTime;
    }

    public final IManagedContainer getContainer() {
        return this.repository == null ? null : ((InternalRepository)this.repository).getContainer();
    }

    @Override
    public final IRepository getRepository() {
        return this.repository;
    }

    @Override
    public final void setRepository(IRepository repository) {
        this.checkInactive();
        this.repository = repository;
    }

    @Override
    public final IRepository[] getSecondaryRepositories() {
        return this.secondaryRepositories.keySet().toArray(new InternalRepository[0]);
    }

    @Override
    public final void addSecondaryRepository(IRepository repository) {
        this.secondaryRepositories.computeIfAbsent(repository, k -> new SecondaryRepository((IRepository)k));
    }

    @Override
    public final void removeSecondaryRepository(IRepository repository) {
        SecondaryRepository secondaryRepository = (SecondaryRepository)this.secondaryRepositories.remove(repository);
        if (secondaryRepository != null) {
            secondaryRepository.dispose();
        }
    }

    @Override
    public final IRepositoryProtector.UserAuthenticator getUserAuthenticator() {
        return this.userAuthenticator;
    }

    @Override
    @AnnotationFactory.InjectElement(name="userAuthenticator", productGroup="org.eclipse.emf.cdo.server.repositoryProtectorUserAuthenticators")
    public final void setUserAuthenticator(IRepositoryProtector.UserAuthenticator userAuthenticator) {
        this.checkInactive();
        this.userAuthenticator = userAuthenticator;
    }

    @Override
    public final IRepositoryProtector.AuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    @Override
    @AnnotationFactory.InjectElement(name="authorizationStrategy", productGroup="org.eclipse.emf.cdo.server.repositoryProtectorAuthorizationStrategies", defaultFactoryType="additive")
    public final void setAuthorizationStrategy(IRepositoryProtector.AuthorizationStrategy authorizationStrategy) {
        this.checkInactive();
        this.authorizationStrategy = authorizationStrategy;
    }

    @Override
    public final IRepositoryProtector.RevisionAuthorizer[] getRevisionAuthorizers() {
        return (IRepositoryProtector.RevisionAuthorizer[])this.revisionAuthorizers.get();
    }

    @Override
    @AnnotationFactory.InjectElement(name="revisionAuthorizer", productGroup="org.eclipse.emf.cdo.server.repositoryProtectorRevisionAuthorizers", defaultFactoryType="default")
    public final void addRevisionAuthorizer(IRepositoryProtector.RevisionAuthorizer authorizer) {
        this.checkInactive();
        this.revisionAuthorizers.add((Object)authorizer);
    }

    @Override
    public final void removeRevisionAuthorizer(IRepositoryProtector.RevisionAuthorizer authorizer) {
        this.checkInactive();
        this.revisionAuthorizers.remove((Object)authorizer);
    }

    @Override
    public final IRepositoryProtector.CommitHandler[] getCommitHandlers() {
        return (IRepositoryProtector.CommitHandler[])this.commitHandlers.get();
    }

    @Override
    @AnnotationFactory.InjectElement(name="commitHandler", productGroup="org.eclipse.emf.cdo.server.repositoryProtectorCommitHandlers")
    public final void addCommitHandler(IRepositoryProtector.CommitHandler handler) {
        this.checkInactive();
        this.commitHandlers.add((Object)handler);
    }

    @Override
    public final void removeCommitHandler(IRepositoryProtector.CommitHandler handler) {
        this.checkInactive();
        this.commitHandlers.remove((Object)handler);
    }

    public boolean isAdministrator(String userID) {
        this.checkActive();
        return this.userAuthenticator.isAdministrator(userID);
    }

    public void updatePassword(String userID, char[] oldPassword, char[] newPassword) {
        this.checkActive();
        if (this.userAuthenticator instanceof IRepositoryProtector.UserAuthenticator.PasswordChangeSupport) {
            ((IRepositoryProtector.UserAuthenticator.PasswordChangeSupport)((Object)this.userAuthenticator)).updatePassword(userID, oldPassword, newPassword);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void resetPassword(String adminID, char[] adminPassword, String userID, char[] newPassword) {
        this.checkActive();
        if (this.userAuthenticator instanceof IRepositoryProtector.UserAuthenticator.PasswordChangeSupport) {
            ((IRepositoryProtector.UserAuthenticator.PasswordChangeSupport)((Object)this.userAuthenticator)).resetPassword(adminID, adminPassword, userID, newPassword);
            return;
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<String, SessionUserInfo> map = this.sessionUserInfos;
        synchronized (map) {
            return this.sessionUserInfos.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRepositoryProtector.UserInfo[] getElements() {
        ArrayList<IRepositoryProtector.UserInfo> userInfos = new ArrayList<IRepositoryProtector.UserInfo>();
        Map<String, SessionUserInfo> map = this.sessionUserInfos;
        synchronized (map) {
            for (SessionUserInfo sessionUserInfo : this.sessionUserInfos.values()) {
                userInfos.add(sessionUserInfo.userInfo);
            }
        }
        return userInfos.toArray(new IRepositoryProtector.UserInfo[userInfos.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String userID, char[] password) throws SecurityException {
        this.checkActive();
        try {
            byte[] digest;
            SessionUserInfo sessionUserInfo;
            IRepositoryProtector.UserInfo newUserInfo = this.userAuthenticator.authenticateUser(userID, password);
            IRepositoryProtector.UserInfo oldUserInfo = null;
            Map<String, SessionUserInfo> map = this.sessionUserInfos;
            synchronized (map) {
                sessionUserInfo = this.sessionUserInfos.get(userID);
                if (newUserInfo != null) {
                    if (sessionUserInfo != null) {
                        oldUserInfo = sessionUserInfo.userInfo;
                        if (oldUserInfo.equalsStructurally(newUserInfo)) {
                            oldUserInfo = null;
                        } else {
                            sessionUserInfo.userInfo = newUserInfo;
                        }
                    } else {
                        sessionUserInfo = new SessionUserInfo();
                        sessionUserInfo.userInfo = newUserInfo;
                        this.sessionUserInfos.put(userID, sessionUserInfo);
                    }
                    sessionUserInfo.passwordDigest = this.digestPassword(password);
                }
            }
            if (newUserInfo != null) {
                if (oldUserInfo != null) {
                    this.fireEvent((IEvent)new IRepositoryProtector.UserInfoChangedEvent(this, oldUserInfo, newUserInfo));
                }
                return;
            }
            if (sessionUserInfo != null && Arrays.equals(digest = this.digestPassword(password), sessionUserInfo.passwordDigest)) {
                for (ISession session : sessionUserInfo.sessions) {
                    OM.LOG.info("Closing session because user " + userID + " is no longer authenticated: " + session);
                    try {
                        session.close();
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            }
        }
        catch (SecurityException ex) {
            OM.LOG.info((Throwable)ex);
        }
        this.denyAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryProtector.UserInfo getUserInfo(String userID) {
        SessionUserInfo sessionUserInfo;
        Map<String, SessionUserInfo> map = this.sessionUserInfos;
        synchronized (map) {
            sessionUserInfo = this.sessionUserInfos.get(userID);
        }
        if (sessionUserInfo != null) {
            return sessionUserInfo.userInfo;
        }
        return null;
    }

    protected IRepositoryProtector.UserInfo getUserInfo(ISession session) {
        String userID = session.getUserID();
        if (userID != null) {
            return this.getUserInfo(userID);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionAdded(ISession session) {
        String userID = session.getUserID();
        if (userID != null) {
            IRepositoryProtector.UserInfo userInfo = null;
            Map<String, SessionUserInfo> map = this.sessionUserInfos;
            synchronized (map) {
                SessionUserInfo sessionUserInfo = this.sessionUserInfos.get(userID);
                if (sessionUserInfo != null && sessionUserInfo.addSession(session)) {
                    userInfo = sessionUserInfo.userInfo;
                }
            }
            if (userInfo != null) {
                this.fireElementAddedEvent(userInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionRemoved(ISession session) {
        String userID = session.getUserID();
        if (userID != null) {
            IRepositoryProtector.UserInfo userInfo = null;
            Map<String, SessionUserInfo> map = this.sessionUserInfos;
            synchronized (map) {
                SessionUserInfo sessionUserInfo = this.sessionUserInfos.get(userID);
                if (sessionUserInfo != null && sessionUserInfo.removeSession(session)) {
                    this.sessionUserInfos.remove(userID);
                    userInfo = sessionUserInfo.userInfo;
                }
            }
            if (userInfo != null) {
                this.fireElementRemovedEvent(userInfo);
            }
        }
    }

    @Override
    @Deprecated
    public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, String userID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, ISession session) {
        return this.getPermission(revision, securityContext, session, this.repository);
    }

    protected CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, ISession session, IRepository repository) {
        IRepositoryProtector.UserInfo userInfo = this.getUserInfo(session);
        CDORevisionProvider revisionProvider = securityContext == null ? null : id -> ManagedRevisionProvider.provideRevision((CDORevisionManager)session.getRevisionManager(), (CDOID)id, (CDOBranchPoint)securityContext);
        return this.authorizeRevision(session, userInfo, securityContext, revisionProvider, revision);
    }

    @Override
    public boolean hasAnyRule(ISession session, Set<? extends Object> rules) {
        return false;
    }

    @Override
    public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
        ISession session = transaction.getSession();
        IRepositoryProtector.UserInfo userInfo = this.getUserInfo(session);
        this.forEachCommitHandler(handler -> handler.beforeCommit(commitContext, userInfo));
        CDOBranchPoint securityContext = commitContext.getBranchPoint();
        this.authorizeCommit(session, userInfo, securityContext, (CDORevisionProvider)transaction, commitContext);
        CommitSecurityImpact securityImpact = this.computeCommitSecurityImpact(commitContext);
        if (securityImpact != null) {
            ((InternalCommitContext)commitContext).setSecurityImpact(securityImpact.getSeverity(), securityImpact.getImpactedRules());
        }
    }

    @Override
    public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        ISession session = transaction.getSession();
        IRepositoryProtector.UserInfo userInfo = this.getUserInfo(session);
        this.forEachCommitHandler(handler -> handler.afterCommit(commitContext, userInfo));
    }

    protected void doBeforeActivate() throws Exception {
        this.checkState(this.repository, "repository");
        this.checkState((Object)this.userAuthenticator, "userAuthenticator");
        if (this.authorizationStrategy == null) {
            String name = this.repository.getName();
            OM.LOG.warn("No authorization strategy specified for repository " + name);
            OM.LOG.warn("Granting WRITE access to all users of repository " + name);
            this.authorizationStrategy = new IRepositoryProtector.AuthorizationStrategy.Constant.Write();
        }
    }

    protected void doActivate() throws Exception {
        IStore store = this.repository.getStore();
        Map<String, String> properties = store.getPersistentProperties(PROP_PROTECTOR_INITIALIZED, new String[0]);
        this.firstTime = !Boolean.parseBoolean(properties.get(PROP_PROTECTOR_INITIALIZED));
        this.init(this.firstTime);
        if (this.firstTime) {
            properties.put(PROP_PROTECTOR_INITIALIZED, Boolean.TRUE.toString());
            store.setPersistentProperties(properties);
        }
        InternalSessionManager sessionManager = (InternalSessionManager)this.repository.getSessionManager();
        sessionManager.setAuthenticator((IAuthenticator)this);
        sessionManager.setPermissionManager(this);
        sessionManager.addListener(this.sessionManagerListener);
        this.repository.addHandler(this);
        this.userAuthenticator.setRepositoryProtector(this);
        LifecycleUtil.activate((Object)((Object)this.userAuthenticator));
        this.authorizationStrategy.setRepositoryProtector(this);
        LifecycleUtil.activate((Object)this.authorizationStrategy);
        IRepositoryProtector.Element[] elementArray = this.getRevisionAuthorizers();
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryProtector.RevisionAuthorizer revisionAuthorizer = elementArray[n2];
            revisionAuthorizer.setRepositoryProtector(this);
            LifecycleUtil.activate((Object)((Object)revisionAuthorizer));
            ++n2;
        }
        elementArray = this.getCommitHandlers();
        n = elementArray.length;
        n2 = 0;
        while (n2 < n) {
            IRepositoryProtector.Element commitHandler = elementArray[n2];
            commitHandler.setRepositoryProtector(this);
            LifecycleUtil.activate((Object)((Object)commitHandler));
            ++n2;
        }
    }

    protected void doDeactivate() throws Exception {
        IRepositoryProtector.Element[] elementArray = this.getCommitHandlers();
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryProtector.CommitHandler commitHandler = elementArray[n2];
            LifecycleUtil.deactivate((Object)((Object)commitHandler));
            commitHandler.setRepositoryProtector(null);
            ++n2;
        }
        elementArray = this.getRevisionAuthorizers();
        n = elementArray.length;
        n2 = 0;
        while (n2 < n) {
            IRepositoryProtector.Element revisionAuthorizer = elementArray[n2];
            LifecycleUtil.deactivate((Object)((Object)revisionAuthorizer));
            revisionAuthorizer.setRepositoryProtector(null);
            ++n2;
        }
        LifecycleUtil.deactivate((Object)this.authorizationStrategy);
        this.authorizationStrategy.setRepositoryProtector(null);
        LifecycleUtil.deactivate((Object)((Object)this.userAuthenticator));
        this.userAuthenticator.setRepositoryProtector(null);
        this.repository.removeHandler(this);
        InternalSessionManager sessionManager = (InternalSessionManager)this.repository.getSessionManager();
        if (sessionManager != null) {
            sessionManager.setAuthenticator(null);
            sessionManager.setPermissionManager(null);
            sessionManager.removeListener(this.sessionManagerListener);
        }
    }

    protected void init(boolean firstTime) {
    }

    protected boolean isReplicateSecondaryPackageUnits() {
        return false;
    }

    protected CDOPermission authorizeRevision(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
        CDOPermission result = this.authorizationStrategy.getInitialPermission();
        CDOPermission terminalPermission = this.authorizationStrategy.getTerminalPermission();
        IRepositoryProtector.RevisionAuthorizer[] revisionAuthorizerArray = this.getRevisionAuthorizers();
        int n = revisionAuthorizerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPermission permission;
            IRepositoryProtector.RevisionAuthorizer authorizer = revisionAuthorizerArray[n2];
            if (!authorizer.isDisabled() && (permission = authorizer.authorizeRevision(session, userInfo, securityContext, revisionProvider, revision)) != null) {
                switch (authorizer.getOperation()) {
                    case COMBINE: {
                        result = this.authorizationStrategy.getCombinedPermission(result, permission);
                        break;
                    }
                    case OVERRIDE: {
                        result = permission;
                        break;
                    }
                    case VETO: {
                        return permission;
                    }
                }
                if (!this.authorizationStrategy.test(result, terminalPermission)) break;
            }
            ++n2;
        }
        return result;
    }

    protected void authorizeRevisionModification(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision, String operation) throws SecurityException {
        CDOPermission permission = this.authorizeRevision(session, userInfo, securityContext, revisionProvider, revision);
        if (permission != CDOPermission.WRITE) {
            throw new SecurityException("User " + userInfo.userID() + " is not allowed to " + operation + " " + revision);
        }
    }

    protected void authorizeCommit(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, IStoreAccessor.CommitContext commitContext) throws SecurityException {
        CDOID[] detachedObjects;
        InternalCDORevision[] modifiedObjects;
        InternalCDORevision revision;
        int i;
        InternalCDORevision[] attachedObjects;
        if (this.authorizationStrategy.isAuthorizeAttach() && (attachedObjects = commitContext.getNewObjects()) != null && attachedObjects.length != 0) {
            i = 0;
            while (i < attachedObjects.length) {
                revision = attachedObjects[i];
                this.authorizeRevisionModification(session, userInfo, securityContext, revisionProvider, (CDORevision)revision, "attach");
                ++i;
            }
        }
        if (this.authorizationStrategy.isAuthorizeModify() && (modifiedObjects = commitContext.getDirtyObjects()) != null && modifiedObjects.length != 0) {
            i = 0;
            while (i < modifiedObjects.length) {
                revision = modifiedObjects[i];
                this.authorizeRevisionModification(session, userInfo, securityContext, revisionProvider, (CDORevision)revision, "modify");
                ++i;
            }
        }
        if (this.authorizationStrategy.isAuthorizeDetach() && (detachedObjects = commitContext.getDetachedObjects()) != null && detachedObjects.length != 0) {
            i = 0;
            while (i < detachedObjects.length) {
                CDOID id = detachedObjects[i];
                CDORevision revision2 = revisionProvider.getRevision(id);
                this.authorizeRevisionModification(session, userInfo, securityContext, revisionProvider, revision2, "detach");
                ++i;
            }
        }
    }

    protected CommitSecurityImpact computeCommitSecurityImpact(IStoreAccessor.CommitContext commitContext) {
        return null;
    }

    protected void replicateSecondaryPackageUnits(InternalCDOPackageUnit[] newPackageUnits) {
        InternalRepository primaryRepository = (InternalRepository)this.repository;
        InternalCDOPackageRegistry primaryPackageRegistry = primaryRepository.getPackageRegistry(false);
        ArrayList<InternalCDOPackageUnit> unknownPackageUnits = new ArrayList<InternalCDOPackageUnit>();
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = newPackageUnits;
        int n = newPackageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            String nsURI = packageUnit.getID();
            if (primaryPackageRegistry.getPackageUnit(nsURI) == null) {
                unknownPackageUnits.add((InternalCDOPackageUnit)CDOModelUtil.copyPackageUnit((CDOPackageUnit)packageUnit));
            }
            ++n2;
        }
        if (!unknownPackageUnits.isEmpty()) {
            InternalCDOPackageUnit[] unitArray = unknownPackageUnits.toArray(new InternalCDOPackageUnit[unknownPackageUnits.size()]);
            try {
                RunnableWithException.forkAndWait(() -> {
                    InternalCDOPackageRegistry internalCDOPackageRegistry2 = primaryPackageRegistry;
                    synchronized (internalCDOPackageRegistry2) {
                        primaryPackageRegistry.putPackageUnits(unitArray, CDOPackageUnit.State.LOADED);
                    }
                    this.commitPrimaryPackageUnits(unitArray);
                });
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
    }

    protected void commitPrimaryPackageUnits(InternalCDOPackageUnit[] packageUnits) {
        IStoreAccessor writer = this.getRepository().getStore().getWriter(null);
        StoreThreadLocal.setAccessor(writer);
        try {
            writer.writePackageUnits(packageUnits, (OMMonitor)new Monitor());
            writer.commit((OMMonitor)new Monitor());
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void denyAccess() throws SecurityException {
        throw new SecurityException("Access denied");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] digestPassword(char[] password) {
        if (password == null) {
            return null;
        }
        byte[] bytes = SecurityUtil.toString((char[])password).getBytes();
        MessageDigest messageDigest = this.passwordDigester;
        synchronized (messageDigest) {
            this.passwordDigester.update(this.salt);
            return this.passwordDigester.digest(bytes);
        }
    }

    private void forEachCommitHandler(Consumer<IRepositoryProtector.CommitHandler> consumer) {
        IRepositoryProtector.CommitHandler[] commitHandlerArray = this.getCommitHandlers();
        int n = commitHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryProtector.CommitHandler handler = commitHandlerArray[n2];
            try {
                consumer.accept(handler);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    public static final class CommitSecurityImpact {
        public static final CommitSecurityImpact NONE = new CommitSecurityImpact(0, null);
        public static final CommitSecurityImpact REALM = new CommitSecurityImpact(2, null);
        private final byte severity;
        private final Set<? extends Object> impactedRules;

        public CommitSecurityImpact(byte severity, Set<? extends Object> impactedRules) {
            this.severity = severity;
            this.impactedRules = impactedRules;
        }

        public byte getSeverity() {
            return this.severity;
        }

        public Set<? extends Object> getImpactedRules() {
            return this.impactedRules;
        }
    }

    public static final class RepositoryConfiguratorExtension
    extends RepositoryConfigurator.TreeExtension {
        @Override
        protected String configureRepository(InternalRepository repository, Tree config, Map<String, String> parameters, IManagedContainer container) {
            String type = config.attribute("type");
            if (StringUtil.isEmpty((String)type)) {
                type = "default";
            }
            IRepositoryProtector protector = (IRepositoryProtector)container.createElement("org.eclipse.emf.cdo.server.repositoryProtectors", type, config);
            repository.setProtector(protector);
            return "protected: " + type;
        }
    }

    private final class SecondaryRepository
    extends LifecycleEventAdapter
    implements IPermissionManager,
    IRepository.WriteAccessHandler {
        private final IRepository delegate;

        public SecondaryRepository(IRepository delegate) {
            this.delegate = delegate;
            InternalSessionManager sessionManager = (InternalSessionManager)delegate.getSessionManager();
            sessionManager.setAuthenticator((IAuthenticator)DefaultRepositoryProtector.this);
            sessionManager.setPermissionManager(this);
            sessionManager.addListener(DefaultRepositoryProtector.this.sessionManagerListener);
            delegate.addListener((IListener)this);
            delegate.addHandler(this);
        }

        @Override
        @Deprecated
        public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, String userID) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, ISession session) {
            return DefaultRepositoryProtector.this.getPermission(revision, securityContext, session, this.delegate);
        }

        @Override
        public boolean hasAnyRule(ISession session, Set<? extends Object> rules) {
            return DefaultRepositoryProtector.this.hasAnyRule(session, rules);
        }

        @Override
        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            Object[] newPackageUnits;
            if (DefaultRepositoryProtector.this.isReplicateSecondaryPackageUnits() && !ObjectUtil.isEmpty((Object[])(newPackageUnits = commitContext.getNewPackageUnits()))) {
                DefaultRepositoryProtector.this.replicateSecondaryPackageUnits((InternalCDOPackageUnit[])newPackageUnits);
            }
            ISession session = transaction.getSession();
            IRepositoryProtector.UserInfo userInfo = DefaultRepositoryProtector.this.getUserInfo(session);
            DefaultRepositoryProtector.this.forEachCommitHandler(handler -> handler.beforeCommit(commitContext, userInfo));
            CDOBranchPoint securityContext = commitContext.getBranchPoint();
            DefaultRepositoryProtector.this.authorizeCommit(session, userInfo, securityContext, (CDORevisionProvider)transaction, commitContext);
        }

        @Override
        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
            ISession session = transaction.getSession();
            IRepositoryProtector.UserInfo userInfo = DefaultRepositoryProtector.this.getUserInfo(session);
            DefaultRepositoryProtector.this.forEachCommitHandler(handler -> handler.afterCommit(commitContext, userInfo));
        }

        public void dispose() {
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            DefaultRepositoryProtector.this.removeSecondaryRepository(this.delegate);
        }
    }

    private static final class SessionUserInfo {
        private IRepositoryProtector.UserInfo userInfo;
        private byte[] passwordDigest;
        private final List<ISession> sessions = new ArrayList<ISession>();

        private SessionUserInfo() {
        }

        public boolean addSession(ISession session) {
            boolean first = this.sessions.isEmpty();
            this.sessions.add(session);
            return first;
        }

        public boolean removeSession(ISession session) {
            this.sessions.remove(session);
            return this.sessions.isEmpty();
        }

        public String toString() {
            return "SessionUserInfo[userInfo=" + this.userInfo + ", sessions=" + this.sessions + "]";
        }
    }
}

