/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.memory.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.memory.transport.FileImport;
import org.eclipse.cdt.debug.core.memory.transport.IScrollMemory;
import org.eclipse.cdt.debug.core.memory.transport.ImportRequest;
import org.eclipse.cdt.debug.internal.core.memory.transport.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.osgi.framework.FrameworkUtil;

public class SRecordImport
extends FileImport<BufferedReader> {
    private final boolean transfer;

    public SRecordImport(File input, ImportRequest request, IScrollMemory scroll, boolean transfer) {
        super(input, request, scroll);
        this.transfer = transfer;
    }

    @Override
    protected BufferedReader input(File file) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
    }

    @Override
    protected void transfer(BufferedReader reader, BigInteger factor, IProgressMonitor monitor) throws IOException, DebugException {
        boolean CHECKSUM_LENGTH = true;
        BigInteger scrollToAddress = null;
        BigInteger offset = null;
        if (!this.transfer) {
            offset = BigInteger.ZERO;
        }
        String line = reader.readLine();
        int lineNo = 1;
        while (line != null && !monitor.isCanceled()) {
            String recordType = line.substring(0, 2);
            int recordCount = 0;
            try {
                recordCount = Integer.parseInt(line.substring(2, 4), 16);
            }
            catch (NumberFormatException ex) {
                throw new DebugException((IStatus)new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), 5012, String.format(Messages.SRecordImport_e_invalid_line_length, lineNo), (Throwable)ex));
            }
            int bytesRead = 4 + recordCount;
            int position = 4;
            int addressSize = 0;
            BigInteger recordAddress = null;
            if ("S3".equals(recordType)) {
                addressSize = 4;
            } else if ("S1".equals(recordType)) {
                addressSize = 2;
            } else if ("S2".equals(recordType)) {
                addressSize = 3;
            } else if ("S0".equals(recordType) || "S5".equals(recordType) || "S7".equals(recordType) || "S8".equals(recordType) || "S9".equals(recordType)) {
                line = reader.readLine();
                ++lineNo;
                continue;
            }
            try {
                recordAddress = new BigInteger(line.substring(position, position + addressSize * 2), 16);
            }
            catch (NumberFormatException ex) {
                throw new DebugException((IStatus)new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), 5012, String.format(Messages.SRecordImport_e_invalid_address, lineNo), (Throwable)ex));
            }
            recordCount -= addressSize;
            position += addressSize * 2;
            if (offset == null) {
                offset = this.start.subtract(recordAddress);
            }
            recordAddress = recordAddress.add(offset);
            byte[] data = new byte[recordCount - 1];
            int i = 0;
            while (i < data.length) {
                try {
                    data[i] = new BigInteger(line.substring(position++, position++ + 1), 16).byteValue();
                }
                catch (NumberFormatException ex) {
                    throw new DebugException((IStatus)new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), 5012, String.format(Messages.SRecordImport_e_invalid_data, lineNo), (Throwable)ex));
                }
                ++i;
            }
            StringBuilder buf = new StringBuilder(line.substring(2));
            int checksum = 0;
            int i2 = 0;
            while (i2 < buf.length()) {
                BigInteger value = null;
                try {
                    value = new BigInteger(buf.substring(i2, i2 + 2), 16);
                }
                catch (NumberFormatException ex) {
                    throw new DebugException((IStatus)new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), 5012, String.format(Messages.SRecordImport_e_invalid_checksum_format, lineNo), (Throwable)ex));
                }
                checksum = (byte)(checksum + value.byteValue());
                i2 += 2;
            }
            if (checksum != -1) {
                monitor.done();
                throw new DebugException((IStatus)new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), String.format(Messages.SRecordImport_e_checksum_failure, line)));
            }
            if (scrollToAddress == null) {
                scrollToAddress = recordAddress;
            }
            this.write.to(recordAddress.subtract(this.base), data);
            BigInteger jobCount = BigInteger.valueOf(bytesRead).divide(factor);
            monitor.worked(jobCount.intValue());
            line = reader.readLine();
            ++lineNo;
        }
        this.scroll.accept(scrollToAddress);
    }
}

