/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;

public class DeleteHelper {
    public static void removeTableFromStatement(QueryDeleteStatement statement) {
        statement.setTargetTable(null);
    }

    public static void setTargetTable(QueryDeleteStatement statement, TableInDatabase targetTable) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement, targetTable});
        }
        if (statement != null) {
            statement.setTargetTable(targetTable);
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)statement));
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void clearStatementContents(QueryDeleteStatement stmt) {
        if (stmt != null) {
            stmt.setTargetTable(null);
            stmt.setWhereClause(null);
            stmt.setWhereCurrentOfClause(null);
            stmt.setName(null);
            stmt.setLabel(null);
        }
    }

    public static void replaceStatementContents(QueryDeleteStatement oldStmt, QueryDeleteStatement newStmt) {
        if (oldStmt != null && newStmt != null) {
            oldStmt.setLabel(newStmt.getLabel());
            oldStmt.setName(newStmt.getName());
            oldStmt.setSourceInfo(newStmt.getSourceInfo());
            oldStmt.setWhereClause(newStmt.getWhereClause());
            oldStmt.setWhereCurrentOfClause(newStmt.getWhereCurrentOfClause());
            oldStmt.setTargetTable(newStmt.getTargetTable());
        }
    }

    public static void refresh(QueryDeleteStatement stmt) {
        stmt.setWhereClause(stmt.getWhereClause());
    }
}

