/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSStorage;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.ResponsiveSocketFactory;

public class Util {
    public static String getLastSegment(String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            return path;
        }
        if (index == path.length() - 1) {
            return Util.getLastSegment(path.substring(0, index));
        }
        return path.substring(index + 1);
    }

    public static String removeLastSegment(String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            return "";
        }
        return path.substring(0, index);
    }

    public static String asPath(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - "/".length());
        }
        return path;
    }

    public static String getRelativePath(String rootName, String resourceName) throws CVSException {
        if (!resourceName.startsWith(rootName) || rootName.length() > resourceName.length()) {
            throw new CVSException(CVSMessages.Util_Internal_error__resource_does_not_start_with_root_3);
        }
        if (rootName.length() == resourceName.length()) {
            return "";
        }
        String result = resourceName.substring(rootName.length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String appendPath(String prefix, String suffix) {
        if (prefix.length() == 0 || prefix.equals(".")) {
            return suffix;
        }
        if (prefix.endsWith("/")) {
            if (suffix.startsWith("/")) {
                return String.valueOf(prefix) + suffix.substring(1);
            }
            return String.valueOf(prefix) + suffix;
        }
        if (suffix.startsWith("/")) {
            return String.valueOf(prefix) + suffix;
        }
        return String.valueOf(prefix) + "/" + suffix;
    }

    public static void logError(String message, Throwable throwable) {
        CVSProviderPlugin.log(4, message, throwable);
    }

    public static String toTruncatedPath(ICVSResource resource, ICVSFolder root, int split) {
        try {
            String stringPath = resource.getRelativePath(root);
            if (stringPath.equals(".")) {
                return resource.getName();
            }
            String truncatedPath = Util.toTruncatedPath(stringPath, split);
            return truncatedPath;
        }
        catch (CVSException cVSException) {
            return resource.getName();
        }
    }

    public static String toTruncatedPath(String stringPath, int split) {
        int count = 0;
        int index = stringPath.length();
        while (count++ < split && index != -1) {
            index = stringPath.lastIndexOf("/", index - 1);
        }
        if (index == -1) {
            return stringPath;
        }
        return NLS.bind((String)CVSMessages.Util_truncatedPath, (Object[])new String[]{stringPath.substring(index)});
    }

    public static Socket createSocket(String host, int port, IProgressMonitor monitor) throws UnknownHostException, IOException {
        int timeout = CVSProviderPlugin.getPlugin().getTimeout();
        if (timeout == 0) {
            timeout = 60;
        }
        ResponsiveSocketFactory factory = new ResponsiveSocketFactory(monitor, timeout);
        return factory.createSocket(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Process createProcess(final String[] command, IProgressMonitor monitor) throws IOException {
        final Process[] process = new Process[1];
        final Exception[] exception = new Exception[1];
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Process newProcess = Runtime.getRuntime().exec(command);
                    Process[] processArray = process;
                    synchronized (process) {
                        if (Thread.interrupted()) {
                            newProcess.destroy();
                        } else {
                            process[0] = newProcess;
                        }
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                    }
                }
                catch (IOException e) {
                    exception[0] = e;
                }
                {
                    return;
                }
            }
        });
        thread.start();
        int timeout = CVSProviderPlugin.getPlugin().getTimeout();
        if (timeout == 0) {
            timeout = 60;
        }
        int i = 0;
        while (i < timeout) {
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
            Process[] processArray = process;
            // MONITORENTER : process
            if (monitor.isCanceled()) {
                if (thread.isAlive()) {
                    thread.interrupt();
                }
                if (process[0] != null) {
                    process[0].destroy();
                }
                Policy.checkCanceled(monitor);
            }
            // MONITOREXIT : processArray
            ++i;
        }
        Process[] processArray = process;
        // MONITORENTER : process
        if (thread.isAlive()) {
            thread.interrupt();
        }
        // MONITOREXIT : processArray
        if (exception[0] != null) {
            throw (IOException)exception[0];
        }
        if (process[0] != null) return process[0];
        throw new InterruptedIOException(NLS.bind((String)CVSMessages.Util_processTimeout, (Object[])new String[]{command[0]}));
    }

    public static String[] parseIntoSubstrings(String string, String delimiter) {
        String next;
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int index = string.indexOf(delimiter);
        while (index != -1) {
            next = string.substring(start, index);
            result.add(next);
            start = index + 1;
            index = string.indexOf(delimiter, start);
        }
        next = start >= string.length() ? "" : string.substring(start);
        result.add(next);
        return result.toArray(new String[result.size()]);
    }

    public static String getSubstring(byte[] bytes, byte delimiter, int index, boolean includeRest) {
        byte[] bytesForSlot = Util.getBytesForSlot(bytes, delimiter, index, includeRest);
        if (bytesForSlot == null) {
            return null;
        }
        return new String(bytesForSlot);
    }

    public static int getOffsetOfDelimeter(byte[] bytes, byte delimiter, int start, int n) {
        int count = 0;
        int i = start;
        while (i < bytes.length) {
            if (bytes[i] == delimiter) {
                ++count;
            }
            if (count == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static byte[] getBytesForSlot(byte[] bytes, byte delimiter, int index, boolean includeRest) {
        int start;
        if (index == 0) {
            start = -1;
        } else {
            start = Util.getOffsetOfDelimeter(bytes, delimiter, 0, index);
            if (start == -1) {
                return null;
            }
        }
        int end = Util.getOffsetOfDelimeter(bytes, delimiter, start + 1, 1);
        int length = end == -1 || includeRest ? bytes.length - start - 1 : end - start - 1;
        byte[] result = new byte[length];
        System.arraycopy(bytes, start + 1, result, 0, length);
        return result;
    }

    public static boolean equals(byte[] syncBytes, byte[] oldBytes) {
        if (syncBytes == null || oldBytes == null) {
            return syncBytes == oldBytes;
        }
        if (syncBytes.length != oldBytes.length) {
            return false;
        }
        int i = 0;
        while (i < oldBytes.length) {
            if (oldBytes[i] != syncBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static CVSTag getAccurateFolderTag(IResource resource, CVSTag tag) {
        FolderSyncInfo projectSyncInfo;
        if (resource.getType() != 2) {
            return tag;
        }
        IResource[] members = null;
        try {
            members = ((IFolder)resource).members();
        }
        catch (CoreException coreException) {
            return tag;
        }
        int i = 0;
        while (i < members.length) {
            if (members[i].getType() == 1) {
                return tag;
            }
            ++i;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return tag;
        }
        ICVSFolder projectFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        try {
            projectSyncInfo = projectFolder.getFolderSyncInfo();
        }
        catch (CVSException cVSException) {
            return tag;
        }
        if (projectSyncInfo == null) {
            return tag;
        }
        CVSEntryLineTag projectTag = projectSyncInfo.getTag();
        if (projectTag != null && ((CVSTag)projectTag).getName().equals(tag.getName())) {
            return projectTag;
        }
        return tag;
    }

    public static CVSTag getAccurateFileTag(ICVSResource cvsResource) throws CVSException {
        CVSTag tag = null;
        ResourceSyncInfo info = cvsResource.getSyncInfo();
        if (info != null) {
            tag = info.getTag();
        }
        FolderSyncInfo parentInfo = cvsResource.getParent().getFolderSyncInfo();
        CVSEntryLineTag parentTag = null;
        if (parentInfo != null) {
            parentTag = parentInfo.getTag();
        }
        if (tag != null) {
            if (tag.getName().equals(info.getRevision())) {
                tag = new CVSTag(tag.getName(), 2);
            } else if (parentTag != null) {
                tag = new CVSTag(tag.getName(), ((CVSTag)parentTag).getType());
            }
        }
        return tag;
    }

    public static CVSTag getAccurateFileTag(ICVSResource cvsResource, CVSTag[] existing) throws CVSException {
        List<CVSTag> tags = Arrays.asList(existing);
        CVSTag tag = null;
        ResourceSyncInfo info = cvsResource.getSyncInfo();
        if (info != null) {
            tag = info.getTag();
        }
        FolderSyncInfo parentInfo = cvsResource.getParent().getFolderSyncInfo();
        CVSEntryLineTag parentTag = null;
        if (parentInfo != null) {
            parentTag = parentInfo.getTag();
        }
        if (tag != null) {
            CVSTag newTag;
            if (tag.getName().equals(info.getRevision())) {
                tag = new CVSTag(tag.getName(), 2);
            } else if (parentTag != null) {
                tag = new CVSTag(tag.getName(), ((CVSTag)parentTag).getType());
            } else if (!tags.contains(tag) && !tags.contains(tag) && tags.contains(newTag = new CVSTag(tag.getName(), 2))) {
                tag = newTag;
            }
        }
        return tag;
    }

    public static String getFullestPath(ICVSResource resource) {
        IResource local = resource.getIResource();
        if (local != null) {
            return local.getFullPath().toString();
        }
        try {
            String remotePath = resource.getRepositoryRelativePath();
            if (remotePath != null) {
                return remotePath;
            }
        }
        catch (CVSException cVSException) {}
        return resource.getName();
    }

    public static String getVariablePattern(String pattern, String variableName) {
        return "(" + variableName + ":" + pattern + ":" + variableName + ")";
    }

    public static int[] convertToDigits(String localRevision) {
        try {
            String[] digitStrings = localRevision.split("\\.");
            int[] digits = new int[digitStrings.length];
            int i = 0;
            while (i < digitStrings.length) {
                String digitString = digitStrings[i];
                digits[i] = Integer.parseInt(digitString);
                ++i;
            }
            return digits;
        }
        catch (NumberFormatException e) {
            CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e)));
            return new int[0];
        }
    }

    public static String toTruncatedPath(ICVSStorage file, ICVSFolder localRoot, int i) {
        if (file instanceof ICVSResource) {
            return Util.toTruncatedPath((ICVSResource)((Object)file), localRoot, i);
        }
        return file.getName();
    }

    public static String removeAtticSegment(String path) {
        int lastSeparator = path.lastIndexOf("/");
        if (lastSeparator == -1) {
            return path;
        }
        int secondLastSeparator = path.lastIndexOf("/", lastSeparator - 1);
        if (secondLastSeparator == -1) {
            return path;
        }
        String secondLastSegment = path.substring(secondLastSeparator + 1, lastSeparator);
        if (secondLastSegment.equals("Attic")) {
            return String.valueOf(path.substring(0, secondLastSeparator)) + path.substring(lastSeparator);
        }
        return path;
    }

    public static String flattenText(String string) {
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append("/");
                }
                skipAdjacentLineSeparator = true;
            } else {
                buffer.append(c);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return buffer.toString();
    }
}

