/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.serial.internal.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.serial.internal.ui.Activator;
import org.eclipse.remote.serial.ui.NewSerialPortConnectionWizard;
import org.eclipse.remote.ui.AbstractRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class SerialPortConnectionsUI
extends AbstractRemoteUIConnectionService {
    private final IRemoteConnectionType connectionType;

    private SerialPortConnectionsUI(IRemoteConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public IRemoteConnectionType getConnectionType() {
        return this.connectionType;
    }

    public IRemoteUIConnectionWizard getConnectionWizard(Shell shell) {
        return new NewSerialPortConnectionWizard(shell, this.connectionType);
    }

    public void openConnectionWithProgress(Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        try {
            context.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        Activator.log(e.getStatus());
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    public ILabelProvider getLabelProvider() {
        return new AbstractRemoteUIConnectionService.DefaultLabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("org.eclipse.remote.serial.ui.connectionType");
            }
        };
    }

    /* synthetic */ SerialPortConnectionsUI(IRemoteConnectionType iRemoteConnectionType, SerialPortConnectionsUI serialPortConnectionsUI) {
        this(iRemoteConnectionType);
    }

    public static class Factory
    implements IRemoteConnectionType.Service.Factory {
        public <T extends IRemoteConnectionType.Service> T getService(IRemoteConnectionType connectionType, Class<T> service) {
            if (IRemoteUIConnectionService.class.equals(service)) {
                return (T)((Object)new SerialPortConnectionsUI(connectionType, null));
            }
            return null;
        }
    }
}

