/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.ui.internal.launchconfiguration.local;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.debug.ui.launchConfigurations.MainLaunchConfigurationTab;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptLaunchConfigurationConstants;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ldt.core.LuaUtils;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.ldt.debug.core.interpreter.LuaInterpreterUtil;
import org.eclipse.ldt.debug.ui.internal.Activator;
import org.eclipse.ldt.debug.ui.internal.launchconfiguration.local.tab.Messages;
import org.eclipse.ldt.ui.SWTUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LuaMainLaunchConfigurationTab
extends MainLaunchConfigurationTab {
    private Button defaultInterpreterButton;
    private Label defaultInterpreterLabel;
    private Button alternateInterpreterButton;
    private ComboViewer interpretersViewer;
    private Button manageButton;

    public LuaMainLaunchConfigurationTab(String mode) {
        super(mode);
    }

    public String getNatureID() {
        return "org.eclipse.ldt.nature";
    }

    public Image getImage() {
        return org.eclipse.ldt.ui.internal.Activator.getDefault().getImageRegistry().get("icons/obj16/module.gif");
    }

    protected void doCreateControl(Composite composite) {
        super.doCreateControl(composite);
        this.createInterpreterSelectionComponent(composite);
    }

    private void createInterpreterSelectionComponent(Composite parent) {
        int nbColumn = 3;
        Group group = new Group(parent, 0);
        group.setText(Messages.LuaInterpreterTabComboBlockRuntimeInterpreterLabel);
        GridLayoutFactory.swtDefaults().numColumns(nbColumn).applyTo((Composite)group);
        GridDataFactory.swtDefaults().span(nbColumn, 1).grab(true, false).align(4, 4).applyTo((Control)group);
        this.defaultInterpreterButton = new Button((Composite)group, 16);
        this.defaultInterpreterButton.setText(Messages.LuaInterpreterTabComboBlockDefaultInterpreterLabel);
        this.defaultInterpreterLabel = new Label((Composite)group, 16);
        GridDataFactory.swtDefaults().span(nbColumn - 1, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)this.defaultInterpreterLabel);
        this.alternateInterpreterButton = new Button((Composite)group, 16);
        this.alternateInterpreterButton.setText(Messages.LuaInterpreterTabComboBlockAlternateInterpreterLabel);
        this.interpretersViewer = new ComboViewer((Composite)group, 12);
        this.interpretersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo(this.interpretersViewer.getControl());
        this.manageButton = new Button((Composite)group, 0);
        this.manageButton.setText(Messages.LuaInterpreterTabComboBlockManageInterpretersButton);
        GridDataFactory.swtDefaults().hint(SWTUtil.getButtonWidthHint((Button)this.manageButton), -1).applyTo((Control)this.manageButton);
    }

    protected void doInitializeForm(ILaunchConfiguration config) {
        super.doInitializeForm(config);
        try {
            this.refreshInterpretersInformation();
            String path = config.getAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
            if (path == null) {
                this.defaultInterpreterButton.setSelection(true);
                this.alternateInterpreterButton.setSelection(false);
                if (this.interpretersViewer.getCombo().getItemCount() > 0) {
                    this.interpretersViewer.getCombo().select(0);
                }
            } else {
                this.alternateInterpreterButton.setSelection(true);
                this.defaultInterpreterButton.setSelection(false);
                String id = EnvironmentManager.getLocalEnvironment().getId();
                IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((String)this.getNatureID(), (String)id, (IPath)new Path(path));
                if (install != null) {
                    this.interpretersViewer.setSelection((ISelection)new StructuredSelection((Object)install));
                }
            }
            this.refreshUISelection();
            this.refreshScriptField();
            this.addListeners();
        }
        catch (CoreException e) {
            Activator.logError("Launch Configuration main tab for lua application failed at initialization", e);
        }
    }

    private void addListeners() {
        this.defaultInterpreterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LuaMainLaunchConfigurationTab.this.refreshUISelection();
                LuaMainLaunchConfigurationTab.this.refreshScriptField();
                LuaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.alternateInterpreterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LuaMainLaunchConfigurationTab.this.refreshUISelection();
                LuaMainLaunchConfigurationTab.this.refreshScriptField();
                LuaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.interpretersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LuaMainLaunchConfigurationTab.this.refreshScriptField();
                LuaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LuaMainLaunchConfigurationTab.this.showInterpreterPreferencePage();
                LuaMainLaunchConfigurationTab.this.refreshInterpretersInformation();
                if (LuaMainLaunchConfigurationTab.this.interpretersViewer.getCombo().getItemCount() > 0) {
                    LuaMainLaunchConfigurationTab.this.interpretersViewer.getCombo().select(0);
                }
                LuaMainLaunchConfigurationTab.this.refreshScriptField();
                LuaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void refreshInterpretersInformation() {
        String interpreterName = null;
        IInterpreterInstall defaultInterpreter = LuaInterpreterUtil.getDefaultInterpreter();
        if (defaultInterpreter != null) {
            interpreterName = defaultInterpreter.getName();
        }
        if (interpreterName != null) {
            this.defaultInterpreterLabel.setText(interpreterName);
        } else {
            this.defaultInterpreterLabel.setText(Messages.LuaInterpreterTabUndefinedInterpreterName);
        }
        this.interpretersViewer.setInput((Object)LuaInterpreterUtil.getInterpreters());
    }

    private void refreshUISelection() {
        this.interpretersViewer.getControl().setEnabled(this.alternateInterpreterButton.getSelection());
        this.defaultInterpreterLabel.setEnabled(!this.alternateInterpreterButton.getSelection());
    }

    private void refreshScriptField() {
        IInterpreterInstall selectedInterpreter = this.getSelectedInterpreter();
        boolean interpreterHandlesFilesAsArgument = LuaInterpreterUtil.interpreterHandlesFilesAsArgument((IInterpreterInstall)selectedInterpreter);
        this.setEnableScriptField(interpreterHandlesFilesAsArgument);
    }

    protected void showInterpreterPreferencePage() {
        String pageId;
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)this.getNatureID());
        if (toolkit != null && (pageId = toolkit.getInterpreterPreferencePage()) != null) {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{pageId}, null).open();
        }
    }

    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        super.doPerformApply(config);
        if (this.defaultInterpreterButton.getSelection()) {
            config.setAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
        } else {
            IPath containerPath;
            IInterpreterInstall selectedInterpreter = this.getSelectedAlternateInterpreter();
            if (selectedInterpreter != null && (containerPath = ScriptRuntime.newInterpreterContainerPath((IInterpreterInstall)selectedInterpreter)) != null) {
                config.setAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, containerPath.toPortableString());
            }
        }
    }

    protected boolean canSelectDebugConsoleType() {
        return true;
    }

    private IInterpreterInstall getSelectedInterpreter() {
        IInterpreterInstall selectedInterpreter = this.alternateInterpreterButton.getSelection() ? this.getSelectedAlternateInterpreter() : LuaInterpreterUtil.getDefaultInterpreter();
        return selectedInterpreter;
    }

    private IInterpreterInstall getSelectedAlternateInterpreter() {
        Object firstElement;
        ISelection selection = this.interpretersViewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IInterpreterInstall) {
            return (IInterpreterInstall)firstElement;
        }
        return null;
    }

    protected boolean validateScript() {
        IInterpreterInstall selectedInterpreter = this.getSelectedInterpreter();
        boolean interpreterHandlesFilesAsArgument = LuaInterpreterUtil.interpreterHandlesFilesAsArgument((IInterpreterInstall)selectedInterpreter);
        if (interpreterHandlesFilesAsArgument) {
            return super.validateScript();
        }
        return true;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setWarningMessage(null);
        boolean valid = super.isValid(launchConfig);
        if (valid) {
            String eeVersion;
            IPath eePath;
            String eeid;
            IInterpreterInstall selectedInterpreter;
            if (this.defaultInterpreterButton.getSelection()) {
                IInterpreterInstall defaultInterpreter = LuaInterpreterUtil.getDefaultInterpreter();
                if (defaultInterpreter == null) {
                    this.setErrorMessage(Messages.LuaInterpreterTabComboBlockNoDefaultInterpreter);
                    return false;
                }
            } else if (this.getSelectedAlternateInterpreter() == null) {
                if (this.interpretersViewer.getCombo().getItemCount() > 0) {
                    this.setErrorMessage(Messages.LuaInterpreterTabComboBlockSelectAnInterpreter);
                    return false;
                }
                this.setErrorMessage(Messages.LuaInterpreterTabComboBlockNoInterpreter);
                return false;
            }
            if ((selectedInterpreter = this.getSelectedInterpreter()) != null && !LuaInterpreterUtil.isExecutionEnvironmentCompatible((IInterpreterInstall)selectedInterpreter, (String)(eeid = LuaExecutionEnvironmentBuildpathUtil.getEEID((IPath)(eePath = LuaUtils.getLuaExecutionEnvironmentPath((IScriptProject)this.getProject())))), (String)(eeVersion = LuaExecutionEnvironmentBuildpathUtil.getEEVersion((IPath)eePath)))) {
                this.setWarningMessage(Messages.LuaInterpreterTabComboBlockIncompatibleInterpreter);
            }
        }
        return valid;
    }

    protected void setDefaults(ILaunchConfigurationWorkingCopy configuration, IModelElement element) {
        super.setDefaults(configuration, element);
        configuration.setAttribute("org.eclipse.dltk.launching.debugConsole", false);
    }
}

