/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.eclipse.emf.ecore.util.QueryDelegate;

public final class EcoreAnnotationValidator
extends BasicEAnnotationValidator {
    public static final EcoreAnnotationValidator INSTANCE = new EcoreAnnotationValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore.annotation";

    static {
        if (!EAnnotationValidator.Registry.INSTANCE.containsKey("http://www.eclipse.org/emf/2002/Ecore")) {
            EAnnotationValidator.Registry.INSTANCE.put("http://www.eclipse.org/emf/2002/Ecore", INSTANCE);
        }
        PropertySwitch.VALID_KEYS.isEmpty();
    }

    public EcoreAnnotationValidator() {
        super("http://www.eclipse.org/emf/2002/Ecore", "Ecore", DIAGNOSTIC_SOURCE);
    }

    @Override
    protected ResourceLocator getResourceLocator() {
        return this.getEcoreResourceLocator();
    }

    @Override
    protected boolean isValidLocation(EAnnotation eAnnotation, EModelElement eModelElement) {
        return !this.getProperties(eModelElement).isEmpty();
    }

    @Override
    protected List<EClass> getPropertyClasses(EModelElement eModelElement) {
        final ArrayList result = new ArrayList(1);
        new PropertySwitch(){

            @Override
            protected void addFeatures(EClass eClass) {
                result.add(eClass);
            }
        }.doSwitch(eModelElement);
        return result.isEmpty() ? Collections.emptyList() : Collections.singletonList((EClass)result.get(0));
    }

    @Override
    protected boolean validateAttributeDetailValueLiteral(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EAttribute attribute, String literalValue, List<Object> dataValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<String> validKeys;
        ArrayList<Object> newValues = new ArrayList<Object>(1);
        boolean result = super.validateAttributeDetailValueLiteral(eAnnotation, eModelElement, entry, attribute, literalValue, newValues, diagnostics, context);
        dataValues.addAll(newValues);
        if ((result || diagnostics != null) && (validKeys = PropertySwitch.getValidKeys(attribute, context)) != null) {
            ArrayList<Object> values = newValues;
            for (String string : values) {
                if (validKeys.contains(string) || !EcoreValidator.isWellFormedURI(string)) continue;
                result = false;
                if (diagnostics == null) break;
                diagnostics.add((Diagnostic)this.createDiagnostic(2, 0, this.getString(this.getResourceLocator(), "_UI_EcoreAnnotationUnregisteredDelegate_diagnostic", string, this.getString(this.getResourceLocator(), "_UI_EcoreAnnotationUnregisteredDelegate_" + attribute.getName() + "_substitution", new Object[0])), string));
            }
        }
        return result;
    }

    private static abstract class PropertySwitch
    extends EcoreSwitch<Void> {
        private static final String ANNOTATION_NS_URI = "http:///org/eclipse/emf/ecore/util/EcoreAnnotation";
        private static final Map<EAttribute, Set<String>> VALID_KEYS = new HashMap<EAttribute, Set<String>>();
        private static final EClass ANNOTATION_PACKAGE_CLASS;
        private static final EClass ANNOTATION_CLASSIFIER_CLASS;
        private static final EClass ANNOTATION_OPERATION_CLASS;

        static {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ANNOTATION_NS_URI);
            if (ePackage == null) {
                ePackage = EcoreAnnotationValidator.loadEPackage(String.valueOf(EcorePlugin.INSTANCE.getBaseURL().toString()) + "model/EcoreAnnotation.ecore");
            }
            if (ePackage == null) {
                ANNOTATION_PACKAGE_CLASS = null;
                ANNOTATION_CLASSIFIER_CLASS = null;
                ANNOTATION_OPERATION_CLASS = null;
            } else {
                ANNOTATION_PACKAGE_CLASS = (EClass)ePackage.getEClassifier("Package");
                VALID_KEYS.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("settingDelegates"), EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.keySet());
                VALID_KEYS.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("validationDelegates"), EValidator.ValidationDelegate.Registry.INSTANCE.keySet());
                VALID_KEYS.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("invocationDelegates"), EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.keySet());
                VALID_KEYS.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("conversionDelegates"), EDataType.Internal.ConversionDelegate.Factory.Registry.INSTANCE.keySet());
                VALID_KEYS.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("queryDelegates"), QueryDelegate.Factory.Registry.INSTANCE.keySet());
                ANNOTATION_CLASSIFIER_CLASS = (EClass)ePackage.getEClassifier("Classifier");
                ANNOTATION_OPERATION_CLASS = (EClass)ePackage.getEClassifier("Operation");
                final EDataType javaIdentifier = (EDataType)ePackage.getEClassifier("JavaIdentifier");
                final EDataType uriDataType = (EDataType)ePackage.getEClassifier("WellFormedURI");
                EValidator.Registry.INSTANCE.put(ePackage, new EObjectValidator(){

                    @Override
                    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
                        boolean result = super.validate(eDataType, value, diagnostics, context);
                        if (result) {
                            if (eDataType == javaIdentifier) {
                                if (javaIdentifier != null && !(result = EcoreValidator.isWellFormedJavaIdentifier((String)value)) && diagnostics != null) {
                                    diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 0, "_UI_NameNotWellFormedJavaIdentifier_diagnostic", new Object[]{value}, new Object[]{value, eDataType}, context));
                                }
                            } else if (eDataType == uriDataType && value != null && !(result = EcoreValidator.isWellFormedURI((String)value)) && diagnostics != null) {
                                diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 0, "_UI_EAnnotationSourceURINotWellFormed_diagnostic", new Object[]{value}, new Object[]{value, eDataType}, context));
                            }
                        }
                        return result;
                    }
                });
            }
        }

        private PropertySwitch() {
        }

        protected abstract void addFeatures(EClass var1);

        public static Set<String> getValidKeys(EAttribute attribute, Map<Object, Object> context) {
            HashMap<EAttribute, Set<String>> validKeys;
            HashMap<EAttribute, Set<String>> hashMap = validKeys = context == null ? null : (HashMap<EAttribute, Set<String>>)context.get("VALID_DELEGATE_KEYS");
            if (validKeys == null) {
                validKeys = new HashMap<EAttribute, Set<String>>();
                validKeys.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("settingDelegates"), EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.getTargetPlatformFactories());
                validKeys.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("validationDelegates"), EValidator.ValidationDelegate.Registry.INSTANCE.getTargetPlatformFactories());
                validKeys.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("invocationDelegates"), EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.getTargetPlatformFactories());
                validKeys.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("conversionDelegates"), EDataType.Internal.ConversionDelegate.Factory.Registry.INSTANCE.getTargetPlatformFactories());
                validKeys.put((EAttribute)ANNOTATION_PACKAGE_CLASS.getEStructuralFeature("queryDelegates"), QueryDelegate.Factory.Registry.INSTANCE.getTargetPlatformFactories());
                if (context != null) {
                    context.put("VALID_DELEGATE_KEYS", validKeys);
                }
            }
            return (Set)validKeys.get(attribute);
        }

        @Override
        public Void caseEClassifier(EClassifier eClassifier) {
            if (ANNOTATION_CLASSIFIER_CLASS != null) {
                this.addFeatures(ANNOTATION_CLASSIFIER_CLASS);
            }
            return null;
        }

        @Override
        public Void caseEOperation(EOperation eOperation) {
            if (ANNOTATION_OPERATION_CLASS != null) {
                this.addFeatures(ANNOTATION_OPERATION_CLASS);
            }
            return null;
        }

        @Override
        public Void caseEPackage(EPackage object) {
            if (ANNOTATION_PACKAGE_CLASS != null) {
                this.addFeatures(ANNOTATION_PACKAGE_CLASS);
            }
            return null;
        }
    }
}

