/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.net.URL;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

class TransformerBundleExtender
implements BundleTrackerCustomizer<ServiceRegistration<URL>> {
    private static final String EQUINOX_TRANSFORMER_HEADER = "Equinox-Transformer";
    private final BundleContext bundleContext;

    public TransformerBundleExtender(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ServiceRegistration<URL> addingBundle(Bundle bundle, BundleEvent event) {
        TransformerInfo info = TransformerBundleExtender.getTransformerInfo(bundle);
        if (info != null) {
            return this.bundleContext.registerService(URL.class, (Object)info.url(), FrameworkUtil.asDictionary(Map.of("equinox.transformerType", info.type())));
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, ServiceRegistration<URL> registration) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, ServiceRegistration<URL> registration) {
        registration.unregister();
    }

    private static TransformerInfo getTransformerInfo(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String header = (String)headers.get(EQUINOX_TRANSFORMER_HEADER);
        if (header != null && !header.isBlank()) {
            String[] split = header.split(";", 2);
            if (split.length == 2) {
                URL entry = bundle.getEntry(split[1]);
                if (entry != null) {
                    return new TransformerInfo(split[0], entry);
                }
            } else {
                URL entry = bundle.getEntry(header);
                if (entry != null) {
                    return new TransformerInfo("replace", entry);
                }
            }
        }
        return null;
    }

    static void start(BundleContext bundleContext) {
        BundleTracker tracker = new BundleTracker(bundleContext, 44, (BundleTrackerCustomizer)new TransformerBundleExtender(bundleContext));
        tracker.open();
    }

    private record TransformerInfo(String type, URL url) {
    }
}

