/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.event.DefaultObserverNotifierFactory;
import org.jboss.weld.event.EventMetadataImpl;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.util.collections.Iterables;

public final class BeanDeploymentModule {
    private final String id;
    private final boolean web;
    private final ObserverNotifier notifier;
    private final Set<BeanManagerImpl> managers;

    BeanDeploymentModule(String moduleId, String contextId, boolean web, ServiceRegistry services) {
        this.id = moduleId;
        this.web = web;
        this.managers = new CopyOnWriteArraySet<BeanManagerImpl>();
        Iterable<ObserverMethod<?>> observers = Iterables.flatMap(this.managers, BeanManagerImpl::getObservers);
        TypeSafeObserverResolver resolver = new TypeSafeObserverResolver(services.get(MetaAnnotationStore.class), observers, services.get(WeldConfiguration.class));
        this.notifier = DefaultObserverNotifierFactory.INSTANCE.create(contextId, resolver, services, false);
    }

    public String getId() {
        return this.id;
    }

    public boolean isWebModule() {
        return this.web;
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        EventMetadataImpl metadata = new EventMetadataImpl(eventType, null, qualifiers);
        this.notifier.fireEvent(eventType, event, metadata, qualifiers);
    }

    void addManager(BeanManagerImpl manager) {
        if (this.managers.add(manager)) {
            this.notifier.clear();
        }
    }

    public String toString() {
        return "BeanDeploymentModule [id=" + this.id + ", web=" + this.web + ", managers=" + Iterables.transform(this.managers, BeanManagerImpl::getId) + "]";
    }
}

