/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.io.Exceptions;
import com.sun.corba.ee.impl.io.ObjectStreamField;
import com.sun.corba.ee.spi.trace.StreamFormatVersion;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

@StreamFormatVersion
public abstract class OutputStreamHook
extends ObjectOutputStream {
    private HookPutFields putFields = null;
    protected byte streamFormatVersion = 1;
    protected WriteObjectState writeObjectState = NOT_IN_WRITE_OBJECT;
    protected static final WriteObjectState NOT_IN_WRITE_OBJECT = new DefaultState();
    protected static final WriteObjectState IN_WRITE_OBJECT = new InWriteObjectState();
    protected static final WriteObjectState WROTE_DEFAULT_DATA = new WroteDefaultDataState();
    protected static final WriteObjectState WROTE_CUSTOM_DATA = new WroteCustomDataState();

    abstract void writeField(ObjectStreamField var1, Object var2) throws IOException;

    @Override
    @StreamFormatVersion
    public void defaultWriteObject() throws IOException {
        this.writeObjectState.defaultWriteObject(this);
        this.defaultWriteObjectDelegate();
    }

    public abstract void defaultWriteObjectDelegate();

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        this.putFields = new HookPutFields();
        return this.putFields;
    }

    public byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    abstract ObjectStreamField[] getFieldsNoCopy();

    @Override
    @StreamFormatVersion
    public void writeFields() throws IOException {
        this.writeObjectState.defaultWriteObject(this);
        this.putFields.write(this);
    }

    abstract OutputStream getOrbStream();

    protected abstract void beginOptionalCustomData();

    @StreamFormatVersion
    protected void setState(WriteObjectState newState) {
        this.writeObjectState = newState;
    }

    @StreamFormatVersion
    protected static class WroteCustomDataState
    extends InWriteObjectState {
        protected WroteCustomDataState() {
        }

        @Override
        @StreamFormatVersion
        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueOutputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(NOT_IN_WRITE_OBJECT);
        }

        @Override
        @StreamFormatVersion
        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
            throw Exceptions.self.defaultWriteObjectAfterCustomData();
        }

        @Override
        public void writeDataOverride(OutputStreamHook stream) throws IOException {
        }
    }

    @StreamFormatVersion
    protected static class WroteDefaultDataState
    extends InWriteObjectState {
        protected WroteDefaultDataState() {
        }

        @Override
        @StreamFormatVersion
        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                stream.getOrbStream().write_long(0);
            }
            stream.setState(NOT_IN_WRITE_OBJECT);
        }

        @Override
        @StreamFormatVersion
        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
            throw Exceptions.self.calledDefaultWriteObjectTwice();
        }

        @Override
        @StreamFormatVersion
        public void writeDataOverride(OutputStreamHook stream) throws IOException {
            stream.beginOptionalCustomData();
            stream.setState(WROTE_CUSTOM_DATA);
        }
    }

    @StreamFormatVersion
    protected static class InWriteObjectState
    extends WriteObjectState {
        protected InWriteObjectState() {
        }

        @Override
        @StreamFormatVersion
        public void enterWriteObjectOverride(OutputStreamHook stream) throws IOException {
            throw Exceptions.self.calledWriteObjectTwice();
        }

        @Override
        @StreamFormatVersion
        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
            stream.getOrbStream().write_boolean(false);
            if (stream.getStreamFormatVersion() == 2) {
                stream.getOrbStream().write_long(0);
            }
            stream.setState(NOT_IN_WRITE_OBJECT);
        }

        @Override
        @StreamFormatVersion
        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
            stream.getOrbStream().write_boolean(true);
            stream.setState(WROTE_DEFAULT_DATA);
        }

        @Override
        @StreamFormatVersion
        public void writeDataOverride(OutputStreamHook stream) throws IOException {
            stream.getOrbStream().write_boolean(false);
            stream.beginOptionalCustomData();
            stream.setState(WROTE_CUSTOM_DATA);
        }
    }

    @StreamFormatVersion
    protected static class DefaultState
    extends WriteObjectState {
        protected DefaultState() {
        }

        @Override
        @StreamFormatVersion
        public void enterWriteObjectOverride(OutputStreamHook stream) throws IOException {
            stream.setState(IN_WRITE_OBJECT);
        }
    }

    @StreamFormatVersion
    protected static class WriteObjectState {
        private final String name;

        public WriteObjectState() {
            String className = this.getClass().getName();
            int index = className.indexOf(36);
            this.name = className.substring(index + 1);
        }

        @StreamFormatVersion
        public final void enterWriteObject(OutputStreamHook stream) throws IOException {
            this.enterWriteObjectOverride(stream);
        }

        @StreamFormatVersion
        public final void exitWriteObject(OutputStreamHook stream) throws IOException {
            this.exitWriteObjectOverride(stream);
        }

        @StreamFormatVersion
        public final void defaultWriteObject(OutputStreamHook stream) throws IOException {
            this.defaultWriteObjectOverride(stream);
        }

        @StreamFormatVersion
        public final void writeData(OutputStreamHook stream) throws IOException {
            this.writeDataOverride(stream);
        }

        public void enterWriteObjectOverride(OutputStreamHook stream) throws IOException {
        }

        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
        }

        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
        }

        public void writeDataOverride(OutputStreamHook stream) throws IOException {
        }

        public String toString() {
            return this.name;
        }
    }

    private class HookPutFields
    extends ObjectOutputStream.PutField {
        private Map<String, Object> fields = new HashMap<String, Object>();

        private HookPutFields() {
        }

        @Override
        public void put(String name, boolean value) {
            this.fields.put(name, value);
        }

        @Override
        public void put(String name, char value) {
            this.fields.put(name, Character.valueOf(value));
        }

        @Override
        public void put(String name, byte value) {
            this.fields.put(name, value);
        }

        @Override
        public void put(String name, short value) {
            this.fields.put(name, value);
        }

        @Override
        public void put(String name, int value) {
            this.fields.put(name, value);
        }

        @Override
        public void put(String name, long value) {
            this.fields.put(name, value);
        }

        @Override
        public void put(String name, float value) {
            this.fields.put(name, Float.valueOf(value));
        }

        @Override
        public void put(String name, double value) {
            this.fields.put(name, value);
        }

        @Override
        public void put(String name, Object value) {
            this.fields.put(name, value);
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            OutputStreamHook hook = (OutputStreamHook)out;
            ObjectStreamField[] osfields = hook.getFieldsNoCopy();
            for (int i = 0; i < osfields.length; ++i) {
                Object value = this.fields.get(osfields[i].getName());
                hook.writeField(osfields[i], value);
            }
        }
    }
}

