include(CheckCXXCompilerFlag)
function(try_add_compile_options FLAG)
    # Remove leading - or / from the flag name.
    string(REGEX REPLACE "^[-/]" "" name ${FLAG})
    # Deletes any ':' because it's invalid variable names.
    string(REGEX REPLACE ":" "" name ${name})
    check_cxx_compiler_flag(${FLAG} ${name})
    if(${name})
        message(STATUS "Adding compiler flag: ${FLAG}.")
        add_compile_options(${FLAG})
    else()
        message(STATUS "Adding compiler flag: ${FLAG} failed.")
    endif()

    # If the optional argument passed, store the result there.
    if(ARGV1)
        set(${ARGV1} ${name} PARENT_SCOPE)
    endif()
endfunction()

option(PEDANTIC_COMPILER "Compile the project with almost all warnings turned on." OFF)

if(${PEDANTIC_COMPILER})
    if(("${CMAKE_CXX_COMPILER_ID}" MATCHES "GNU") OR ("${CMAKE_CXX_COMPILER_ID}" MATCHES "Clang"))
        message(STATUS "Enabling pedantic compiler options: yes")
        try_add_compile_options(-Wall)
        try_add_compile_options(-Wduplicate-enum)
        try_add_compile_options(-Wduplicated-cond)
        try_add_compile_options(-Wextra)
        try_add_compile_options(-Wfinal-dtor-non-final-class)
        try_add_compile_options(-Wimplicit-fallthrough)
        try_add_compile_options(-Wlogical-op)
        try_add_compile_options(-Wmissing-declarations)
        try_add_compile_options(-Wnewline-eof)
        try_add_compile_options(-Wno-unknown-attributes)
        try_add_compile_options(-Wno-unknown-pragmas)
        try_add_compile_options(-Wsign-conversion)
        try_add_compile_options(-Wsuggest-destructor-override)
        try_add_compile_options(-pedantic)
        try_add_compile_options(-Wconversion)
        try_add_compile_options(-fdiagnostics-color=always)
        try_add_compile_options(-Werror)
        try_add_compile_options(-Wextra-semi)
        try_add_compile_options(-Wpessimizing-move)
        try_add_compile_options(-Wredundant-move)
        try_add_compile_options(-Qunused-arguments)
    else()
        message(STATUS "Enabling pedantic compiler options: unsupported platform")
    endif()
else()
    message(STATUS "Enabling pedantic compiler options: no")
endif()
