% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/middleware.R
\name{httpResponse}
\alias{httpResponse}
\title{Create an HTTP response object}
\usage{
httpResponse(
  status = 200L,
  content_type = "text/html; charset=UTF-8",
  content = "",
  headers = list()
)
}
\arguments{
\item{status}{HTTP status code for the response.}

\item{content_type}{The value for the \code{Content-Type} header.}

\item{content}{The body of the response, given as a single-element character
vector (will be encoded as UTF-8) or a raw vector.}

\item{headers}{A named list of additional headers to include. Do not include
\code{Content-Length} (as it is automatically calculated) or \code{Content-Type} (the
\code{content_type} argument is used instead).}
}
\description{
Create an HTTP response object
}
\examples{
httpResponse(status = 405L,
  content_type = "text/plain",
  content = "The requested method was not allowed"
)

}
\keyword{internal}
