% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_get_cpu_affinity}
\alias{ps_get_cpu_affinity}
\alias{ps_set_cpu_affinity}
\title{Query or set CPU affinity}
\usage{
ps_get_cpu_affinity(p = ps_handle())

ps_set_cpu_affinity(p = ps_handle(), affinity)
}
\arguments{
\item{p}{Process handle.}

\item{affinity}{Integer vector of CPU numbers to restrict a process to.
CPU numbers start with zero, and they have to be smaller than the
number of (logical) CPUs, see \code{\link[=ps_cpu_count]{ps_cpu_count()}}.}
}
\value{
\code{ps_get_cpu_affinity()} returns an integer vector of CPU
numbers, starting with zero.

\code{ps_set_cpu_affinity()} returns \code{NULL}, invisibly.
}
\description{
\code{ps_get_cpu_affinity()} queries the
\href{https://www.linuxjournal.com/article/6799?page=0,0}{CPU affinity} of
a process. \code{ps_set_cpu_affinity()} sets the CPU affinity of a process.
}
\details{
CPU affinity consists in telling the OS to run a process on a limited
set of CPUs only (on Linux cmdline, the \code{taskset} command is typically
used).

These functions are only supported on Linux and Windows. They error on macOS.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check() && ! ps::ps_os_type()[["MACOS"]]) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# current
orig <- ps_get_cpu_affinity()
orig

# restrict
ps_set_cpu_affinity(affinity = 0:0)
ps_get_cpu_affinity()

# restore
ps_set_cpu_affinity(affinity = orig)
ps_get_cpu_affinity()
\dontshow{\}) # examplesIf}
}
