% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{get_logger_meta_variables}
\alias{get_logger_meta_variables}
\title{Collect useful information about the logging environment to be used in log messages}
\usage{
get_logger_meta_variables(
  log_level = NULL,
  namespace = NA_character_,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)
}
\arguments{
\item{log_level}{log level as per \code{\link[=log_levels]{log_levels()}}}

\item{namespace}{string referring to the \code{logger} environment /
config to be used to override the target of the message record to
be used instead of the default namespace, which is defined by the
R package name from which the logger was called, and falls back
to a common, global namespace.}

\item{.logcall}{the logging call being evaluated (useful in
formatters and layouts when you want to have access to the raw,
unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was
called (useful in formatters and layouts to extract the calling
function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function
where the formatter function will be evaluated and that is used
to look up the \code{namespace} as well via \code{logger:::top_env_name}}
}
\value{
list
}
\description{
Available variables to be used in the log formatter functions, eg in \code{\link[=layout_glue_generator]{layout_glue_generator()}}:
}
\details{
\itemize{
\item \code{levelr}: log level as an R object, eg \code{\link[=INFO]{INFO()}}
\item \code{level}: log level as a string, eg \code{\link[=INFO]{INFO()}}
\item \code{time}: current time as \code{POSIXct}
\item \code{node}: name by which the machine is known on the network as reported by \code{Sys.info}
\item \code{arch}: machine type, typically the CPU architecture
\item \code{os_name}: Operating System's name
\item \code{os_release}: Operating System's release
\item \code{os_version}: Operating System's version
\item \code{user}: name of the real user id as reported by \code{Sys.info}
\item \code{pid}: the process identification number of the R session
\item \code{node}: name by which the machine is known on the network as reported by \code{Sys.info}
\item \code{r_version}: R's major and minor version as a string
\item \code{ns}: namespace usually defaults to \code{global} or the name of the holding R package
of the calling the logging function
\item \code{ns_pkg_version}: the version of \code{ns} when it's a package
\item \code{ans}: same as \code{ns} if there's a defined \code{\link[=logger]{logger()}} for the namespace,
otherwise a fallback namespace (eg usually \code{global})
\item \code{topenv}: the name of the top environment from which the parent call was called
(eg R package name or \code{GlobalEnv})
\item \code{call}: parent call (if any) calling the logging function
\item \code{fn}: function's (if any) name calling the logging function
}
}
\seealso{
\code{\link[=layout_glue_generator]{layout_glue_generator()}}

Other log_layouts: 
\code{\link{layout_blank}()},
\code{\link{layout_glue}()},
\code{\link{layout_glue_colors}()},
\code{\link{layout_glue_generator}()},
\code{\link{layout_json}()},
\code{\link{layout_json_parser}()},
\code{\link{layout_logging}()},
\code{\link{layout_simple}()}
}
\concept{log_layouts}
