/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.editor;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/editor/enterHandler/multilineString")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class MultiLineStringIndentTestGenerated extends AbstractMultiLineStringIndentTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInMultilineString() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/editor/enterHandler/multilineString"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("idea/testData/editor/enterHandler/multilineString/spaces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Spaces extends AbstractMultiLineStringIndentTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSpaces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/editor/enterHandler/multilineString/spaces"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dontAddMarginCharWhenMultilineWithoutMargins.kt")
        public void testDontAddMarginCharWhenMultilineWithoutMargins() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontAddMarginCharWhenMultilineWithoutMargins.kt");
        }

        @TestMetadata("dontAddMarginWhenItIsUnused.kt")
        public void testDontAddMarginWhenItIsUnused() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontAddMarginWhenItIsUnused.kt");
        }

        @TestMetadata("dontAddMarginWhenItIsUnusedWithEmptyPrevious.kt")
        public void testDontAddMarginWhenItIsUnusedWithEmptyPrevious() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontAddMarginWhenItIsUnusedWithEmptyPrevious.kt");
        }

        @TestMetadata("dontAddTrimCallWhenAlreadyMultiline.kt")
        public void testDontAddTrimCallWhenAlreadyMultiline() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontAddTrimCallWhenAlreadyMultiline.kt");
        }

        @TestMetadata("dontAddTrimCallWhenAlreadyMultilineFirstLine.kt")
        public void testDontAddTrimCallWhenAlreadyMultilineFirstLine() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontAddTrimCallWhenAlreadyMultilineFirstLine.kt");
        }

        @TestMetadata("dontInsertTrimMargin1.kt")
        public void testDontInsertTrimMargin1() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontInsertTrimMargin1.kt");
        }

        @TestMetadata("dontInsertTrimMargin2.kt")
        public void testDontInsertTrimMargin2() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontInsertTrimMargin2.kt");
        }

        @TestMetadata("dontInsertTrimMargin3.kt")
        public void testDontInsertTrimMargin3() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontInsertTrimMargin3.kt");
        }

        @TestMetadata("dontInsertTrimMargin4.kt")
        public void testDontInsertTrimMargin4() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/dontInsertTrimMargin4.kt");
        }

        @TestMetadata("enterAfterOpenningBrace.kt")
        public void testEnterAfterOpenningBrace() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterAfterOpenningBrace.kt");
        }

        @TestMetadata("enterBeforeLongEntryOneLine.kt")
        public void testEnterBeforeLongEntryOneLine() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterBeforeLongEntryOneLine.kt");
        }

        @TestMetadata("enterBeforeMarginChar.kt")
        public void testEnterBeforeMarginChar() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterBeforeMarginChar.kt");
        }

        @TestMetadata("enterBeforeShortEntryOneLine.kt")
        public void testEnterBeforeShortEntryOneLine() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterBeforeShortEntryOneLine.kt");
        }

        @TestMetadata("enterInInfixMargin.kt")
        public void testEnterInInfixMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInInfixMargin.kt");
        }

        @TestMetadata("enterInInjectedFragment.kt")
        public void testEnterInInjectedFragment() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInInjectedFragment.kt");
        }

        @TestMetadata("enterInLineWithMarginOnNotMargedLine.kt")
        public void testEnterInLineWithMarginOnNotMargedLine() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInLineWithMarginOnNotMargedLine.kt");
        }

        @TestMetadata("enterInMethodCallMargin.kt")
        public void testEnterInMethodCallMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInMethodCallMargin.kt");
        }

        @TestMetadata("enterInOneLineAfterSpaces.kt")
        public void testEnterInOneLineAfterSpaces() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInOneLineAfterSpaces.kt");
        }

        @TestMetadata("enterInTwoLinesNoMarginCall.kt")
        public void testEnterInTwoLinesNoMarginCall() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInTwoLinesNoMarginCall.kt");
        }

        @TestMetadata("enterInsideBraces.kt")
        public void testEnterInsideBraces() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInsideBraces.kt");
        }

        @TestMetadata("enterInsideBraces1.kt")
        public void testEnterInsideBraces1() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInsideBraces1.kt");
        }

        @TestMetadata("enterInsideBraces2.kt")
        public void testEnterInsideBraces2() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInsideBraces2.kt");
        }

        @TestMetadata("enterInsideTextMargin.kt")
        public void testEnterInsideTextMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterInsideTextMargin.kt");
        }

        @TestMetadata("enterMLSimpleMargin.kt")
        public void testEnterMLSimpleMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterMLSimpleMargin.kt");
        }

        @TestMetadata("enterMLStartOnSameLineMargin.kt")
        public void testEnterMLStartOnSameLineMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterMLStartOnSameLineMargin.kt");
        }

        @TestMetadata("enterOnFirstLineWithPresentTrimMargin.kt")
        public void testEnterOnFirstLineWithPresentTrimMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterOnFirstLineWithPresentTrimMargin.kt");
        }

        @TestMetadata("enterOnFirstLineWithPresentTrimMarginAndLine.kt")
        public void testEnterOnFirstLineWithPresentTrimMarginAndLine() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterOnFirstLineWithPresentTrimMarginAndLine.kt");
        }

        @TestMetadata("enterOnFirstNonEmptyLineWithPresentTrimMargin.kt")
        public void testEnterOnFirstNonEmptyLineWithPresentTrimMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterOnFirstNonEmptyLineWithPresentTrimMargin.kt");
        }

        @TestMetadata("enterOnNewLine.kt")
        public void testEnterOnNewLine() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterOnNewLine.kt");
        }

        @TestMetadata("enterSimple.kt")
        public void testEnterSimple() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterSimple.kt");
        }

        @TestMetadata("enterWithTextMargin.kt")
        public void testEnterWithTextMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterWithTextMargin.kt");
        }

        @TestMetadata("enterWithTextOnNewLineMargin.kt")
        public void testEnterWithTextOnNewLineMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/enterWithTextOnNewLineMargin.kt");
        }

        @TestMetadata("insertCustomMargin.kt")
        public void testInsertCustomMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/insertCustomMargin.kt");
        }

        @TestMetadata("insertCustomMarginInLineStart.kt")
        public void testInsertCustomMarginInLineStart() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/insertCustomMarginInLineStart.kt");
        }

        @TestMetadata("insertDefaultMargin.kt")
        public void testInsertDefaultMargin() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/insertDefaultMargin.kt");
        }

        @TestMetadata("noTrimIndentInAnnotations.kt")
        public void testNoTrimIndentInAnnotations() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/noTrimIndentInAnnotations.kt");
        }

        @TestMetadata("restoreIndentFromEmptyLine.kt")
        public void testRestoreIndentFromEmptyLine() throws Exception {
            runTest("idea/testData/editor/enterHandler/multilineString/spaces/restoreIndentFromEmptyLine.kt");
        }
    }

    @TestMetadata("idea/testData/editor/enterHandler/multilineString/withTabs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WithTabs extends AbstractMultiLineStringIndentTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWithTabs() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/editor/enterHandler/multilineString/withTabs"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Tabs2 extends AbstractMultiLineStringIndentTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTabs2() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dontInsertTrimMarginCall.kt")
            public void testDontInsertTrimMarginCall() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/dontInsertTrimMarginCall.kt");
            }

            @TestMetadata("enterInMethodCallMargin.kt")
            public void testEnterInMethodCallMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterInMethodCallMargin.kt");
            }

            @TestMetadata("enterInTwoLinesNoMarginCall.kt")
            public void testEnterInTwoLinesNoMarginCall() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterInTwoLinesNoMarginCall.kt");
            }

            @TestMetadata("enterInsideBraces.kt")
            public void testEnterInsideBraces() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterInsideBraces.kt");
            }

            @TestMetadata("enterInsideText.kt")
            public void testEnterInsideText() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterInsideText.kt");
            }

            @TestMetadata("enterMLSimpleMargin.kt")
            public void testEnterMLSimpleMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterMLSimpleMargin.kt");
            }

            @TestMetadata("enterMLStartOnSameLineMargin.kt")
            public void testEnterMLStartOnSameLineMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterMLStartOnSameLineMargin.kt");
            }

            @TestMetadata("enterOnNewLineMargin.kt")
            public void testEnterOnNewLineMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterOnNewLineMargin.kt");
            }

            @TestMetadata("enterSimpleMargin.kt")
            public void testEnterSimpleMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterSimpleMargin.kt");
            }

            @TestMetadata("enterWithTextMargin.kt")
            public void testEnterWithTextMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterWithTextMargin.kt");
            }

            @TestMetadata("enterWithTextOnNewLineMargin.kt")
            public void testEnterWithTextOnNewLineMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs2/enterWithTextOnNewLineMargin.kt");
            }
        }

        @TestMetadata("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Tabs4 extends AbstractMultiLineStringIndentTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTabs4() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dontInsertTrimMarginCall.kt")
            public void testDontInsertTrimMarginCall() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/dontInsertTrimMarginCall.kt");
            }

            @TestMetadata("enterInMethodCallMargin.kt")
            public void testEnterInMethodCallMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterInMethodCallMargin.kt");
            }

            @TestMetadata("enterInsideBraces.kt")
            public void testEnterInsideBraces() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterInsideBraces.kt");
            }

            @TestMetadata("enterInsideText.kt")
            public void testEnterInsideText() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterInsideText.kt");
            }

            @TestMetadata("enterMLSimpleMargin.kt")
            public void testEnterMLSimpleMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterMLSimpleMargin.kt");
            }

            @TestMetadata("enterMLStartOnSameLineMargin.kt")
            public void testEnterMLStartOnSameLineMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterMLStartOnSameLineMargin.kt");
            }

            @TestMetadata("enterOnNewLineMargin.kt")
            public void testEnterOnNewLineMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterOnNewLineMargin.kt");
            }

            @TestMetadata("enterSimpleMargin.kt")
            public void testEnterSimpleMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterSimpleMargin.kt");
            }

            @TestMetadata("enterWithTabsAfterMarginChar.kt")
            public void testEnterWithTabsAfterMarginChar() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterWithTabsAfterMarginChar.kt");
            }

            @TestMetadata("enterWithTextMargin.kt")
            public void testEnterWithTextMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterWithTextMargin.kt");
            }

            @TestMetadata("enterWithTextOnNewLineMargin.kt")
            public void testEnterWithTextOnNewLineMargin() throws Exception {
                runTest("idea/testData/editor/enterHandler/multilineString/withTabs/tabs4/enterWithTextOnNewLineMargin.kt");
            }
        }
    }
}
