-- Copyright 2004-2023 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

CREATE TABLE TEST(G GEOMETRY);
> ok

CREATE UNIQUE SPATIAL INDEX IDX ON TEST(G);
> exception SYNTAX_ERROR_2

CREATE HASH SPATIAL INDEX IDX ON TEST(G);
> exception SYNTAX_ERROR_2

CREATE UNIQUE HASH SPATIAL INDEX IDX ON TEST(G);
> exception SYNTAX_ERROR_2

DROP TABLE TEST;
> ok

CREATE TABLE TEST(A INT, B INT, C INT);
> ok

CREATE INDEX TEST_IDX ON TEST(C) INCLUDE(B);
> exception SYNTAX_ERROR_1

CREATE UNIQUE INDEX TEST_IDX ON TEST(C) INCLUDE(B);
> ok

DROP INDEX TEST_IDX;
> ok

CREATE UNIQUE INDEX TEST_IDX_1 ON TEST(A, B, C);
> ok

CREATE UNIQUE NULLS DISTINCT INDEX TEST_IDX_2 ON TEST(A, B, C);
> ok

CREATE UNIQUE NULLS ALL DISTINCT INDEX TEST_IDX_3 ON TEST(A, B, C);
> ok

CREATE UNIQUE NULLS NOT DISTINCT INDEX TEST_IDX_4 ON TEST(A, B, C);
> ok

CREATE UNIQUE NULLS ALL DISTINCT INDEX TEST_IDX_5 ON TEST(C);
> ok

SELECT INDEX_NAME, NULLS_DISTINCT FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = 'TEST';
> INDEX_NAME NULLS_DISTINCT
> ---------- --------------
> TEST_IDX_1 YES
> TEST_IDX_2 YES
> TEST_IDX_3 ALL
> TEST_IDX_4 NO
> TEST_IDX_5 YES
> rows: 5

INSERT INTO TEST VALUES (NULL, NULL, NULL), (1, NULL, NULL), (1, 2, NULL), (1, 2, 3);
> update count: 4

INSERT INTO TEST VALUES (NULL, NULL, NULL);
> exception DUPLICATE_KEY_1

DROP INDEX TEST_IDX_4;
> ok

INSERT INTO TEST VALUES (NULL, NULL, NULL);
> update count: 1

INSERT INTO TEST VALUES (1, NULL, NULL);
> exception DUPLICATE_KEY_1

DROP INDEX TEST_IDX_3;
> ok

INSERT INTO TEST VALUES (1, NULL, NULL);
> update count: 1

DROP TABLE TEST;
> ok
