//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedservices

import "time"

// Authorization - The Azure Active Directory principal identifier and Azure built-in role that describes the access the principal
// will receive on the delegated resource in the managed tenant.
type Authorization struct {
	// REQUIRED; The identifier of the Azure Active Directory principal.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal
	// will have on the projected scope.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`

	// The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role.
	// It is the list of role definition ids which define all the permissions that the
	// user in the authorization can assign to other principals.
	DelegatedRoleDefinitionIDs []*string `json:"delegatedRoleDefinitionIds,omitempty"`

	// The display name of the Azure Active Directory principal.
	PrincipalIDDisplayName *string `json:"principalIdDisplayName,omitempty"`
}

// EligibleApprover - Defines the Azure Active Directory principal that can approve any just-in-time access requests by the
// principal defined in the EligibleAuthorization.
type EligibleApprover struct {
	// REQUIRED; The identifier of the Azure Active Directory principal.
	PrincipalID *string `json:"principalId,omitempty"`

	// The display name of the Azure Active Directory principal.
	PrincipalIDDisplayName *string `json:"principalIdDisplayName,omitempty"`
}

// EligibleAuthorization - The Azure Active Directory principal identifier, Azure built-in role, and just-in-time access policy
// that describes the just-in-time access the principal will receive on the delegated resource in the
// managed tenant.
type EligibleAuthorization struct {
	// REQUIRED; The identifier of the Azure Active Directory principal.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal
	// will have on the projected scope.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`

	// The just-in-time access policy setting.
	JustInTimeAccessPolicy *JustInTimeAccessPolicy `json:"justInTimeAccessPolicy,omitempty"`

	// The display name of the Azure Active Directory principal.
	PrincipalIDDisplayName *string `json:"principalIdDisplayName,omitempty"`
}

// ErrorDefinition - The error response indicating why the incoming request wasn’t able to be processed
type ErrorDefinition struct {
	// REQUIRED; The error code.
	Code *string `json:"code,omitempty"`

	// REQUIRED; The error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`

	// The internal error details.
	Details []*ErrorDefinition `json:"details,omitempty"`
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// JustInTimeAccessPolicy - Just-in-time access policy setting.
type JustInTimeAccessPolicy struct {
	// REQUIRED; The multi-factor authorization provider to be used for just-in-time access requests.
	MultiFactorAuthProvider *MultiFactorAuthProvider `json:"multiFactorAuthProvider,omitempty"`

	// The list of managedByTenant approvers for the eligible authorization.
	ManagedByTenantApprovers []*EligibleApprover `json:"managedByTenantApprovers,omitempty"`

	// The maximum access duration in ISO 8601 format for just-in-time access requests.
	MaximumActivationDuration *string `json:"maximumActivationDuration,omitempty"`
}

type MarketplaceRegistrationDefinition struct {
	// The details for the Managed Services offer’s plan in Azure Marketplace.
	Plan *Plan `json:"plan,omitempty"`

	// The properties of the marketplace registration definition.
	Properties *MarketplaceRegistrationDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; The fully qualified path of the marketplace registration definition.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the marketplace registration definition.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Azure resource (Microsoft.ManagedServices/marketplaceRegistrationDefinitions).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarketplaceRegistrationDefinitionList - The list of marketplace registration definitions.
type MarketplaceRegistrationDefinitionList struct {
	// READ-ONLY; The link to the next page of marketplace registration definitions.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of marketplace registration definitions.
	Value []*MarketplaceRegistrationDefinition `json:"value,omitempty" azure:"ro"`
}

// MarketplaceRegistrationDefinitionProperties - The properties of the marketplace registration definition.
type MarketplaceRegistrationDefinitionProperties struct {
	// REQUIRED; The collection of authorization objects describing the access Azure Active Directory principals in the managedBy
	// tenant will receive on the delegated resource in the managed tenant.
	Authorizations []*Authorization `json:"authorizations,omitempty"`

	// REQUIRED; The identifier of the managedBy tenant.
	ManagedByTenantID *string `json:"managedByTenantId,omitempty"`

	// The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in
	// the managedBy tenant will receive on the delegated resource in the managed
	// tenant.
	EligibleAuthorizations []*EligibleAuthorization `json:"eligibleAuthorizations,omitempty"`

	// The marketplace offer display name.
	OfferDisplayName *string `json:"offerDisplayName,omitempty"`

	// The marketplace plan display name.
	PlanDisplayName *string `json:"planDisplayName,omitempty"`

	// The marketplace publisher display name.
	PublisherDisplayName *string `json:"publisherDisplayName,omitempty"`
}

// MarketplaceRegistrationDefinitionsClientGetOptions contains the optional parameters for the MarketplaceRegistrationDefinitionsClient.Get
// method.
type MarketplaceRegistrationDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MarketplaceRegistrationDefinitionsClientListOptions contains the optional parameters for the MarketplaceRegistrationDefinitionsClient.List
// method.
type MarketplaceRegistrationDefinitionsClientListOptions struct {
	// The filter query parameter to filter managed services resources by.
	Filter *string
}

// MarketplaceRegistrationDefinitionsWithoutScopeClientGetOptions contains the optional parameters for the MarketplaceRegistrationDefinitionsWithoutScopeClient.Get
// method.
type MarketplaceRegistrationDefinitionsWithoutScopeClientGetOptions struct {
	// placeholder for future optional parameters
}

// MarketplaceRegistrationDefinitionsWithoutScopeClientListOptions contains the optional parameters for the MarketplaceRegistrationDefinitionsWithoutScopeClient.List
// method.
type MarketplaceRegistrationDefinitionsWithoutScopeClientListOptions struct {
	// The filter query parameter to filter managed services resources by.
	Filter *string
}

// Operation - The object that describes a single Microsoft.ManagedServices operation.
type Operation struct {
	// READ-ONLY; The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The operation name with the format: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The operation type.
	Operation *string `json:"operation,omitempty"`

	// The service provider.
	Provider *string `json:"provider,omitempty"`

	// The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationList - The list of the operations.
type OperationList struct {
	// READ-ONLY; The list of Microsoft.ManagedServices operations.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsWithScopeClientListOptions contains the optional parameters for the OperationsWithScopeClient.List method.
type OperationsWithScopeClientListOptions struct {
	// placeholder for future optional parameters
}

// Plan - The details for the Managed Services offer’s plan in Azure Marketplace.
type Plan struct {
	// REQUIRED; Azure Marketplace plan name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Azure Marketplace product code.
	Product *string `json:"product,omitempty"`

	// REQUIRED; Azure Marketplace publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// REQUIRED; Azure Marketplace plan's version.
	Version *string `json:"version,omitempty"`
}

// RegistrationAssignment - The registration assignment.
type RegistrationAssignment struct {
	// The properties of a registration assignment.
	Properties *RegistrationAssignmentProperties `json:"properties,omitempty"`

	// READ-ONLY; The fully qualified path of the registration assignment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the registration assignment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The metadata for the registration assignment resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Azure resource (Microsoft.ManagedServices/registrationAssignments).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegistrationAssignmentList - The list of registration assignments.
type RegistrationAssignmentList struct {
	// READ-ONLY; The link to the next page of registration assignments.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of registration assignments.
	Value []*RegistrationAssignment `json:"value,omitempty" azure:"ro"`
}

// RegistrationAssignmentProperties - The properties of the registration assignment.
type RegistrationAssignmentProperties struct {
	// REQUIRED; The fully qualified path of the registration definition.
	RegistrationDefinitionID *string `json:"registrationDefinitionId,omitempty"`

	// READ-ONLY; The current provisioning state of the registration assignment.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The registration definition associated with the registration assignment.
	RegistrationDefinition *RegistrationAssignmentPropertiesRegistrationDefinition `json:"registrationDefinition,omitempty" azure:"ro"`
}

// RegistrationAssignmentPropertiesRegistrationDefinition - The registration definition associated with the registration assignment.
type RegistrationAssignmentPropertiesRegistrationDefinition struct {
	// The details for the Managed Services offer’s plan in Azure Marketplace.
	Plan *Plan `json:"plan,omitempty"`

	// The properties of the registration definition associated with the registration assignment.
	Properties *RegistrationAssignmentPropertiesRegistrationDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; The fully qualified path of the registration definition.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the registration definition.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The metadata for the registration definition resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Azure resource (Microsoft.ManagedServices/registrationDefinitions).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegistrationAssignmentPropertiesRegistrationDefinitionProperties - The properties of the registration definition associated
// with the registration assignment.
type RegistrationAssignmentPropertiesRegistrationDefinitionProperties struct {
	// The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant
	// will receive on the delegated resource in the managed tenant.
	Authorizations []*Authorization `json:"authorizations,omitempty"`

	// The description of the registration definition.
	Description *string `json:"description,omitempty"`

	// The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in
	// the managedBy tenant will receive on the delegated resource in the managed
	// tenant.
	EligibleAuthorizations []*EligibleAuthorization `json:"eligibleAuthorizations,omitempty"`

	// The identifier of the managedBy tenant.
	ManagedByTenantID *string `json:"managedByTenantId,omitempty"`

	// The name of the managedBy tenant.
	ManagedByTenantName *string `json:"managedByTenantName,omitempty"`

	// The identifier of the managed tenant.
	ManageeTenantID *string `json:"manageeTenantId,omitempty"`

	// The name of the managed tenant.
	ManageeTenantName *string `json:"manageeTenantName,omitempty"`

	// The current provisioning state of the registration definition.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// The name of the registration definition.
	RegistrationDefinitionName *string `json:"registrationDefinitionName,omitempty"`
}

// RegistrationAssignmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the RegistrationAssignmentsClient.BeginCreateOrUpdate
// method.
type RegistrationAssignmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistrationAssignmentsClientBeginDeleteOptions contains the optional parameters for the RegistrationAssignmentsClient.BeginDelete
// method.
type RegistrationAssignmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistrationAssignmentsClientGetOptions contains the optional parameters for the RegistrationAssignmentsClient.Get method.
type RegistrationAssignmentsClientGetOptions struct {
	// The flag indicating whether to return the registration definition details along with the registration assignment details.
	ExpandRegistrationDefinition *bool
}

// RegistrationAssignmentsClientListOptions contains the optional parameters for the RegistrationAssignmentsClient.List method.
type RegistrationAssignmentsClientListOptions struct {
	// The flag indicating whether to return the registration definition details along with the registration assignment details.
	ExpandRegistrationDefinition *bool
	// The filter query parameter to filter managed services resources by.
	Filter *string
}

// RegistrationDefinition - The registration definition.
type RegistrationDefinition struct {
	// The details for the Managed Services offer’s plan in Azure Marketplace.
	Plan *Plan `json:"plan,omitempty"`

	// The properties of a registration definition.
	Properties *RegistrationDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; The fully qualified path of the registration definition.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the registration definition.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The metadata for the registration assignment resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Azure resource (Microsoft.ManagedServices/registrationDefinitions).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegistrationDefinitionList - The list of registration definitions.
type RegistrationDefinitionList struct {
	// READ-ONLY; The link to the next page of registration definitions.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of registration definitions.
	Value []*RegistrationDefinition `json:"value,omitempty" azure:"ro"`
}

// RegistrationDefinitionProperties - The properties of a registration definition.
type RegistrationDefinitionProperties struct {
	// REQUIRED; The collection of authorization objects describing the access Azure Active Directory principals in the managedBy
	// tenant will receive on the delegated resource in the managed tenant.
	Authorizations []*Authorization `json:"authorizations,omitempty"`

	// REQUIRED; The identifier of the managedBy tenant.
	ManagedByTenantID *string `json:"managedByTenantId,omitempty"`

	// The description of the registration definition.
	Description *string `json:"description,omitempty"`

	// The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in
	// the managedBy tenant will receive on the delegated resource in the managed
	// tenant.
	EligibleAuthorizations []*EligibleAuthorization `json:"eligibleAuthorizations,omitempty"`

	// The name of the registration definition.
	RegistrationDefinitionName *string `json:"registrationDefinitionName,omitempty"`

	// READ-ONLY; The name of the managedBy tenant.
	ManagedByTenantName *string `json:"managedByTenantName,omitempty" azure:"ro"`

	// READ-ONLY; The identifier of the managed tenant.
	ManageeTenantID *string `json:"manageeTenantId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed tenant.
	ManageeTenantName *string `json:"manageeTenantName,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the registration definition.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RegistrationDefinitionsClientBeginCreateOrUpdateOptions contains the optional parameters for the RegistrationDefinitionsClient.BeginCreateOrUpdate
// method.
type RegistrationDefinitionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistrationDefinitionsClientDeleteOptions contains the optional parameters for the RegistrationDefinitionsClient.Delete
// method.
type RegistrationDefinitionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RegistrationDefinitionsClientGetOptions contains the optional parameters for the RegistrationDefinitionsClient.Get method.
type RegistrationDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegistrationDefinitionsClientListOptions contains the optional parameters for the RegistrationDefinitionsClient.List method.
type RegistrationDefinitionsClientListOptions struct {
	// The filter query parameter to filter managed services resources by.
	Filter *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
