/* BirthDay - warning of birthdays pending */
/* stripped down version of DOS original to allow porting of datafiles */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

/* 16-bit int */
#define INT int
/* um ... padding of some sort? Replaces sizeof(eventdat) */
#define SZOFEVT 35

struct date {INT da_year; char da_day; char da_mon;};

typedef struct { char name[30]; struct date date; unsigned warn : 1;
   unsigned type : 2; unsigned aniv : 1; } eventdat;

struct date curdat;
FILE *file;

void recin(int recno, eventdat *event);
void listevent(eventdat event);
int lastrec(void);

main(int argc, char *argv[])
{
   eventdat event;
   int i,lr;
   char *fname = "/dos/utils/birthday.dat";
   
   if (argc>1) fname=argv[1];

   if ((file = fopen(fname, "r+b")) == NULL) {
      printf("Cannot open file.\n");
      exit(1);
   }

   lr = lastrec();
   
   for(i=0; i < lr; i++) {
      recin(i, &event);
      listevent(event);
   }

   fclose(file);

   return 0;
}

void recin(int recno, eventdat *event)
{
   int cnt;
   char *p;

   p = (char *) event;
   fseek(file, recno * SZOFEVT + sizeof(INT), SEEK_SET);
   for (cnt = 0; cnt < SZOFEVT; cnt++)
      *(p + cnt) = (char) fgetc(file);
}

void listevent(eventdat event)
{
   if (event.date.da_year != -1)
      printf("%s=%d/%d/%d\n", event.name, event.date.da_day, event.date.da_mon,
         event.date.da_year);
   else
      printf("%s=%d/%d\n", event.name, event.date.da_day, event.date.da_mon);
}

int lastrec()
{
   INT lr;
   int i;

   fseek(file, 0, SEEK_SET);
   for (i=0; i < sizeof(INT); i++) ((char *) &lr)[i] = fgetc(file);
   if (lr < 0)
      lr = 0;
   return(lr);
}
