# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network nic create",
)
class Create(AAZCommand):
    """Create a network interface.

    :example: Create a network interface for a specified subnet on a specified virtual network.
        az network nic create -g MyResourceGroup --vnet-name MyVnet --subnet MySubnet -n MyNic

    :example: Create a network interface for a specified subnet on a virtual network which allows IP forwarding subject to a network security group.
        az network nic create -g MyResourceGroup --vnet-name MyVnet --subnet MySubnet -n MyNic --ip-forwarding --network-security-group MyNsg

    :example: Create a network interface for a specified subnet on a virtual network with network security group and application security groups.
        az network nic create -g MyResourceGroup --vnet-name MyVnet --subnet MySubnet -n MyNic --network-security-group MyNsg --application-security-groups Web App
    """

    _aaz_info = {
        "version": "2018-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkinterfaces/{}", "2018-11-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the network interface (NIC).",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location. Values from: `az account list-locations`. You can configure the default location using `az configure --defaults location=<location>`.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.accelerated_networking = AAZBoolArg(
            options=["--accelerated-networking"],
            help="Whether to enable accelerated networking.",
        )
        _args_schema.ip_forwarding = AAZBoolArg(
            options=["--ip-forwarding"],
            help="Whether to enable IP forwarding.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...].",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "DNS"

        _args_schema = cls._args_schema
        _args_schema.dns_servers = AAZListArg(
            options=["--dns-servers"],
            arg_group="DNS",
            help="Space-separated list of DNS server IP addresses.",
        )
        _args_schema.internal_dns_name = AAZStrArg(
            options=["--internal-dns-name"],
            arg_group="DNS",
            help="Name of internal DNS label.",
        )

        dns_servers = cls._args_schema.dns_servers
        dns_servers.Element = AAZStrArg()

        # define Arg Group "DnsSettings"

        # define Arg Group "Parameters"

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.ip_configurations = AAZListArg(
            options=["--ip-configurations"],
            arg_group="Properties",
            help="A list of IPConfigurations of the network interface.",
        )
        _args_schema.nsg = AAZObjectArg(
            options=["--nsg"],
            arg_group="Properties",
            help="The reference to the NetworkSecurityGroup resource.",
        )

        ip_configurations = cls._args_schema.ip_configurations
        ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.ip_configurations.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkInterfaces/{}/ipConfigurations/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.application_gateway_backend_address_pools = AAZListArg(
            options=["application-gateway-backend-address-pools"],
            help="The reference to ApplicationGatewayBackendAddressPool resource.",
        )
        _element.application_security_groups = AAZListArg(
            options=["application-security-groups"],
            help="Application security groups in which the IP configuration is included.",
        )
        _element.load_balancer_backend_address_pools = AAZListArg(
            options=["load-balancer-backend-address-pools"],
            help="The reference to LoadBalancerBackendAddressPool resource.",
        )
        _element.load_balancer_inbound_nat_rules = AAZListArg(
            options=["load-balancer-inbound-nat-rules"],
            help="A list of references of LoadBalancerInboundNatRules.",
        )
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Whether this is a primary customer address on the network interface.",
        )
        _element.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="Private IP address of the IP configuration.",
        )
        _element.private_ip_address_version = AAZStrArg(
            options=["private-ip-address-version"],
            help="Version of private IP address to use.",
            default="IPv4",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        _element.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="Allocation method of private IP address.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        _element.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="Public IP address bound to the IP configuration.",
        )
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Subnet bound to the IP configuration.",
        )
        cls._build_args_subnet_create(_element.subnet)

        application_gateway_backend_address_pools = cls._args_schema.ip_configurations.Element.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_schema.ip_configurations.Element.application_gateway_backend_address_pools.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the backend address pool that is unique within an Application Gateway.",
        )
        _element.backend_addresses = AAZListArg(
            options=["backend-addresses"],
            help="Backend addresses.",
        )

        backend_addresses = cls._args_schema.ip_configurations.Element.application_gateway_backend_address_pools.Element.backend_addresses
        backend_addresses.Element = AAZObjectArg()

        _element = cls._args_schema.ip_configurations.Element.application_gateway_backend_address_pools.Element.backend_addresses.Element
        _element.fqdn = AAZStrArg(
            options=["fqdn"],
            help="Fully qualified domain name (FQDN).",
        )
        _element.ip_address = AAZStrArg(
            options=["ip-address"],
            help="IP address.",
        )

        application_security_groups = cls._args_schema.ip_configurations.Element.application_security_groups
        application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(application_security_groups.Element)

        load_balancer_backend_address_pools = cls._args_schema.ip_configurations.Element.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_schema.ip_configurations.Element.load_balancer_backend_address_pools.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/backendAddressPools/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.",
        )

        load_balancer_inbound_nat_rules = cls._args_schema.ip_configurations.Element.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectArg()

        _element = cls._args_schema.ip_configurations.Element.load_balancer_inbound_nat_rules.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/inboundNatRules/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.",
        )
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for the internal endpoint. Acceptable values range from 1 to 65535.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZIntArg(
            options=["frontend-port"],
            help="The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The reference to the transport protocol used by the load balancing rule.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        public_ip_address = cls._args_schema.ip_configurations.Element.public_ip_address
        public_ip_address.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/publicIPAddresses/{}",
            ),
        )
        public_ip_address.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        public_ip_address.ddos_settings = AAZObjectArg(
            options=["ddos-settings"],
            help="The DDoS protection custom policy associated with the public IP address.",
        )
        public_ip_address.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The FQDN of the DNS record associated with the public IP address.",
        )
        public_ip_address.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address.ip_address = AAZStrArg(
            options=["ip-address"],
            help="The IP address associated with the public IP address resource.",
        )
        public_ip_address.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of tags associated with the public IP address.",
        )
        public_ip_address.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="Version of public IP address.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address.public_ip_allocation_method = AAZStrArg(
            options=["public-ip-allocation-method"],
            help="The public IP address allocation method.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        public_ip_address.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The Public IP Prefix this Public IP Address should be allocated from.",
        )
        cls._build_args_sub_resource_create(public_ip_address.public_ip_prefix)
        public_ip_address.sku = AAZObjectArg(
            options=["sku"],
            help="The public IP address SKU.",
        )
        public_ip_address.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )
        public_ip_address.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
        )

        ddos_settings = cls._args_schema.ip_configurations.Element.public_ip_address.ddos_settings
        ddos_settings.ddos_custom_policy = AAZObjectArg(
            options=["ddos-custom-policy"],
            help="The DDoS custom policy associated with the public IP.",
        )
        cls._build_args_sub_resource_create(ddos_settings.ddos_custom_policy)
        ddos_settings.protection_coverage = AAZStrArg(
            options=["protection-coverage"],
            help="The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )

        dns_settings = cls._args_schema.ip_configurations.Element.public_ip_address.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.",
        )
        dns_settings.fqdn = AAZStrArg(
            options=["fqdn"],
            help="The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.",
        )
        dns_settings.reverse_fqdn = AAZStrArg(
            options=["reverse-fqdn"],
            help="The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.",
        )

        ip_tags = cls._args_schema.ip_configurations.Element.public_ip_address.ip_tags
        ip_tags.Element = AAZObjectArg()

        _element = cls._args_schema.ip_configurations.Element.public_ip_address.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="The IP tag type. Example: FirstPartyUsage.",
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="The value of the IP tag associated with the public IP. Example: SQL.",
        )

        sku = cls._args_schema.ip_configurations.Element.public_ip_address.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of a public IP address SKU.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )

        tags = cls._args_schema.ip_configurations.Element.public_ip_address.tags
        tags.Element = AAZStrArg()

        zones = cls._args_schema.ip_configurations.Element.public_ip_address.zones
        zones.Element = AAZStrArg()

        nsg = cls._args_schema.nsg
        nsg.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkSecurityGroups/{}",
            ),
        )
        nsg.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        nsg.security_rules = AAZListArg(
            options=["security-rules"],
            help="A collection of security rules of the network security group.",
        )
        nsg.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        security_rules = cls._args_schema.nsg.security_rules
        security_rules.Element = AAZObjectArg()

        _element = cls._args_schema.nsg.security_rules.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        _element.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        _element.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        _element.destination_address_prefixes = AAZListArg(
            options=["destination-address-prefixes"],
            help="The destination address prefixes. CIDR or destination IP ranges.",
        )
        _element.destination_application_security_groups = AAZListArg(
            options=["destination-application-security-groups"],
            help="The application security group specified as destination.",
        )
        _element.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        _element.destination_port_ranges = AAZListArg(
            options=["destination-port-ranges"],
            help="The destination port ranges.",
        )
        _element.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        _element.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        _element.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.",
        )
        _element.source_address_prefixes = AAZListArg(
            options=["source-address-prefixes"],
            help="The CIDR or source IP ranges.",
        )
        _element.source_application_security_groups = AAZListArg(
            options=["source-application-security-groups"],
            help="The application security group specified as source.",
        )
        _element.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        _element.source_port_ranges = AAZListArg(
            options=["source-port-ranges"],
            help="The source port ranges.",
        )

        destination_address_prefixes = cls._args_schema.nsg.security_rules.Element.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrArg()

        destination_application_security_groups = cls._args_schema.nsg.security_rules.Element.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(destination_application_security_groups.Element)

        destination_port_ranges = cls._args_schema.nsg.security_rules.Element.destination_port_ranges
        destination_port_ranges.Element = AAZStrArg()

        source_address_prefixes = cls._args_schema.nsg.security_rules.Element.source_address_prefixes
        source_address_prefixes.Element = AAZStrArg()

        source_application_security_groups = cls._args_schema.nsg.security_rules.Element.source_application_security_groups
        source_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(source_application_security_groups.Element)

        source_port_ranges = cls._args_schema.nsg.security_rules.Element.source_port_ranges
        source_port_ranges.Element = AAZStrArg()

        tags = cls._args_schema.nsg.tags
        tags.Element = AAZStrArg()
        return cls._args_schema

    _args_application_security_group_create = None

    @classmethod
    def _build_args_application_security_group_create(cls, _schema):
        if cls._args_application_security_group_create is not None:
            _schema.id = cls._args_application_security_group_create.id
            _schema.location = cls._args_application_security_group_create.location
            _schema.tags = cls._args_application_security_group_create.tags
            return

        cls._args_application_security_group_create = AAZObjectArg()

        application_security_group_create = cls._args_application_security_group_create
        application_security_group_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/applicationSecurityGroups/{}",
            ),
        )
        application_security_group_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        application_security_group_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        tags = cls._args_application_security_group_create.tags
        tags.Element = AAZStrArg()

        _schema.id = cls._args_application_security_group_create.id
        _schema.location = cls._args_application_security_group_create.location
        _schema.tags = cls._args_application_security_group_create.tags

    _args_network_interface_ip_configuration_create = None

    @classmethod
    def _build_args_network_interface_ip_configuration_create(cls, _schema):
        if cls._args_network_interface_ip_configuration_create is not None:
            _schema.application_gateway_backend_address_pools = cls._args_network_interface_ip_configuration_create.application_gateway_backend_address_pools
            _schema.application_security_groups = cls._args_network_interface_ip_configuration_create.application_security_groups
            _schema.load_balancer_backend_address_pools = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools
            _schema.load_balancer_inbound_nat_rules = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules
            _schema.name = cls._args_network_interface_ip_configuration_create.name
            _schema.primary = cls._args_network_interface_ip_configuration_create.primary
            _schema.private_ip_address = cls._args_network_interface_ip_configuration_create.private_ip_address
            _schema.private_ip_address_version = cls._args_network_interface_ip_configuration_create.private_ip_address_version
            _schema.private_ip_allocation_method = cls._args_network_interface_ip_configuration_create.private_ip_allocation_method
            _schema.public_ip_address = cls._args_network_interface_ip_configuration_create.public_ip_address
            _schema.subnet = cls._args_network_interface_ip_configuration_create.subnet
            _schema.virtual_network_taps = cls._args_network_interface_ip_configuration_create.virtual_network_taps
            return

        cls._args_network_interface_ip_configuration_create = AAZObjectArg()

        network_interface_ip_configuration_create = cls._args_network_interface_ip_configuration_create
        network_interface_ip_configuration_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        network_interface_ip_configuration_create.application_gateway_backend_address_pools = AAZListArg(
            options=["application-gateway-backend-address-pools"],
            help="The reference of ApplicationGatewayBackendAddressPool resource.",
        )
        network_interface_ip_configuration_create.application_security_groups = AAZListArg(
            options=["application-security-groups"],
            help="Application security groups in which the IP configuration is included.",
        )
        network_interface_ip_configuration_create.load_balancer_backend_address_pools = AAZListArg(
            options=["load-balancer-backend-address-pools"],
            help="The reference of LoadBalancerBackendAddressPool resource.",
        )
        network_interface_ip_configuration_create.load_balancer_inbound_nat_rules = AAZListArg(
            options=["load-balancer-inbound-nat-rules"],
            help="A list of references of LoadBalancerInboundNatRules.",
        )
        network_interface_ip_configuration_create.primary = AAZBoolArg(
            options=["primary"],
            help="Gets whether this is a primary customer address on the network interface.",
        )
        network_interface_ip_configuration_create.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="Private IP address of the IP configuration.",
        )
        network_interface_ip_configuration_create.private_ip_address_version = AAZStrArg(
            options=["private-ip-address-version"],
            help="Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        network_interface_ip_configuration_create.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        network_interface_ip_configuration_create.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="Public IP address bound to the IP configuration.",
        )
        network_interface_ip_configuration_create.subnet = AAZObjectArg(
            options=["subnet"],
            help="Subnet bound to the IP configuration.",
        )
        cls._build_args_subnet_create(network_interface_ip_configuration_create.subnet)
        network_interface_ip_configuration_create.virtual_network_taps = AAZListArg(
            options=["virtual-network-taps"],
            help="The reference to Virtual Network Taps.",
        )

        application_gateway_backend_address_pools = cls._args_network_interface_ip_configuration_create.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.application_gateway_backend_address_pools.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the backend address pool that is unique within an Application Gateway.",
        )
        _element.backend_addresses = AAZListArg(
            options=["backend-addresses"],
            help="Backend addresses",
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="Type of the resource.",
        )

        backend_addresses = cls._args_network_interface_ip_configuration_create.application_gateway_backend_address_pools.Element.backend_addresses
        backend_addresses.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.application_gateway_backend_address_pools.Element.backend_addresses.Element
        _element.fqdn = AAZStrArg(
            options=["fqdn"],
            help="Fully qualified domain name (FQDN).",
        )
        _element.ip_address = AAZStrArg(
            options=["ip-address"],
            help="IP address",
        )

        application_security_groups = cls._args_network_interface_ip_configuration_create.application_security_groups
        application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(application_security_groups.Element)

        load_balancer_backend_address_pools = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/backendAddressPools/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Gets name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )

        load_balancer_inbound_nat_rules = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/inboundNatRules/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Gets name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for the internal endpoint. Acceptable values range from 1 to 65535.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZIntArg(
            options=["frontend-port"],
            help="The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )

        public_ip_address = cls._args_network_interface_ip_configuration_create.public_ip_address
        public_ip_address.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        public_ip_address.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/publicIPAddresses/{}",
            ),
        )
        public_ip_address.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        public_ip_address.ddos_settings = AAZObjectArg(
            options=["ddos-settings"],
            help="The DDoS protection custom policy associated with the public IP address.",
        )
        public_ip_address.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The FQDN of the DNS record associated with the public IP address.",
        )
        public_ip_address.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address.ip_address = AAZStrArg(
            options=["ip-address"],
            help="The IP address associated with the public IP address resource.",
        )
        public_ip_address.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of tags associated with the public IP address.",
        )
        public_ip_address.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        public_ip_address.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="The public IP address version. Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address.public_ip_allocation_method = AAZStrArg(
            options=["public-ip-allocation-method"],
            help="The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        public_ip_address.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The Public IP Prefix this Public IP Address should be allocated from.",
        )
        cls._build_args_sub_resource_create(public_ip_address.public_ip_prefix)
        public_ip_address.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the public IP resource.",
        )
        public_ip_address.sku = AAZObjectArg(
            options=["sku"],
            help="The public IP address SKU.",
        )
        public_ip_address.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )
        public_ip_address.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
        )

        ddos_settings = cls._args_network_interface_ip_configuration_create.public_ip_address.ddos_settings
        ddos_settings.ddos_custom_policy = AAZObjectArg(
            options=["ddos-custom-policy"],
            help="The DDoS custom policy associated with the public IP.",
        )
        cls._build_args_sub_resource_create(ddos_settings.ddos_custom_policy)
        ddos_settings.protection_coverage = AAZStrArg(
            options=["protection-coverage"],
            help="The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )

        dns_settings = cls._args_network_interface_ip_configuration_create.public_ip_address.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.",
        )
        dns_settings.fqdn = AAZStrArg(
            options=["fqdn"],
            help="Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.",
        )
        dns_settings.reverse_fqdn = AAZStrArg(
            options=["reverse-fqdn"],
            help="Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. ",
        )

        ip_tags = cls._args_network_interface_ip_configuration_create.public_ip_address.ip_tags
        ip_tags.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.public_ip_address.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="Gets or sets the ipTag type: Example FirstPartyUsage.",
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="Gets or sets value of the IpTag associated with the public IP. Example SQL, Storage etc",
        )

        sku = cls._args_network_interface_ip_configuration_create.public_ip_address.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of a public IP address SKU.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )

        tags = cls._args_network_interface_ip_configuration_create.public_ip_address.tags
        tags.Element = AAZStrArg()

        zones = cls._args_network_interface_ip_configuration_create.public_ip_address.zones
        zones.Element = AAZStrArg()

        virtual_network_taps = cls._args_network_interface_ip_configuration_create.virtual_network_taps
        virtual_network_taps.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.virtual_network_taps.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="Gets a unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/virtualNetworkTaps/{}",
            ),
        )
        _element.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _element.destination_load_balancer_front_end_ip_configuration = AAZObjectArg(
            options=["destination-load-balancer-front-end-ip-configuration"],
            help="The reference to the private IP address on the internal Load Balancer that will receive the tap",
        )
        _element.destination_network_interface_ip_configuration = AAZObjectArg(
            options=["destination-network-interface-ip-configuration"],
            help="The reference to the private IP Address of the collector nic that will receive the tap",
        )
        cls._build_args_network_interface_ip_configuration_create(_element.destination_network_interface_ip_configuration)
        _element.destination_port = AAZIntArg(
            options=["destination-port"],
            help="The VXLAN destination port that will receive the tapped traffic.",
        )
        _element.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        destination_load_balancer_front_end_ip_configuration = cls._args_network_interface_ip_configuration_create.virtual_network_taps.Element.destination_load_balancer_front_end_ip_configuration
        destination_load_balancer_front_end_ip_configuration.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        destination_load_balancer_front_end_ip_configuration.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/frontendIPConfigurations/{}",
            ),
        )
        destination_load_balancer_front_end_ip_configuration.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        destination_load_balancer_front_end_ip_configuration.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="The private IP address of the IP configuration.",
        )
        destination_load_balancer_front_end_ip_configuration.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        destination_load_balancer_front_end_ip_configuration.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        destination_load_balancer_front_end_ip_configuration.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="The reference of the Public IP resource.",
        )
        cls._build_args_public_ip_address_create(destination_load_balancer_front_end_ip_configuration.public_ip_address)
        destination_load_balancer_front_end_ip_configuration.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The reference of the Public IP Prefix resource.",
        )
        cls._build_args_sub_resource_create(destination_load_balancer_front_end_ip_configuration.public_ip_prefix)
        destination_load_balancer_front_end_ip_configuration.subnet = AAZObjectArg(
            options=["subnet"],
            help="The reference of the subnet resource.",
        )
        cls._build_args_subnet_create(destination_load_balancer_front_end_ip_configuration.subnet)
        destination_load_balancer_front_end_ip_configuration.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
        )

        zones = cls._args_network_interface_ip_configuration_create.virtual_network_taps.Element.destination_load_balancer_front_end_ip_configuration.zones
        zones.Element = AAZStrArg()

        tags = cls._args_network_interface_ip_configuration_create.virtual_network_taps.Element.tags
        tags.Element = AAZStrArg()

        _schema.application_gateway_backend_address_pools = cls._args_network_interface_ip_configuration_create.application_gateway_backend_address_pools
        _schema.application_security_groups = cls._args_network_interface_ip_configuration_create.application_security_groups
        _schema.load_balancer_backend_address_pools = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools
        _schema.load_balancer_inbound_nat_rules = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules
        _schema.name = cls._args_network_interface_ip_configuration_create.name
        _schema.primary = cls._args_network_interface_ip_configuration_create.primary
        _schema.private_ip_address = cls._args_network_interface_ip_configuration_create.private_ip_address
        _schema.private_ip_address_version = cls._args_network_interface_ip_configuration_create.private_ip_address_version
        _schema.private_ip_allocation_method = cls._args_network_interface_ip_configuration_create.private_ip_allocation_method
        _schema.public_ip_address = cls._args_network_interface_ip_configuration_create.public_ip_address
        _schema.subnet = cls._args_network_interface_ip_configuration_create.subnet
        _schema.virtual_network_taps = cls._args_network_interface_ip_configuration_create.virtual_network_taps

    _args_network_security_group_create = None

    @classmethod
    def _build_args_network_security_group_create(cls, _schema):
        if cls._args_network_security_group_create is not None:
            _schema.default_security_rules = cls._args_network_security_group_create.default_security_rules
            _schema.etag = cls._args_network_security_group_create.etag
            _schema.id = cls._args_network_security_group_create.id
            _schema.location = cls._args_network_security_group_create.location
            _schema.provisioning_state = cls._args_network_security_group_create.provisioning_state
            _schema.resource_guid = cls._args_network_security_group_create.resource_guid
            _schema.security_rules = cls._args_network_security_group_create.security_rules
            _schema.tags = cls._args_network_security_group_create.tags
            return

        cls._args_network_security_group_create = AAZObjectArg()

        network_security_group_create = cls._args_network_security_group_create
        network_security_group_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        network_security_group_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkSecurityGroups/{}",
            ),
        )
        network_security_group_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        network_security_group_create.default_security_rules = AAZListArg(
            options=["default-security-rules"],
            help="The default security rules of network security group.",
        )
        network_security_group_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        network_security_group_create.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the network security group resource.",
        )
        network_security_group_create.security_rules = AAZListArg(
            options=["security-rules"],
            help="A collection of security rules of the network security group.",
        )
        network_security_group_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        default_security_rules = cls._args_network_security_group_create.default_security_rules
        default_security_rules.Element = AAZObjectArg()
        cls._build_args_security_rule_create(default_security_rules.Element)

        security_rules = cls._args_network_security_group_create.security_rules
        security_rules.Element = AAZObjectArg()

        _element = cls._args_network_security_group_create.security_rules.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        _element.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        _element.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        _element.destination_address_prefixes = AAZListArg(
            options=["destination-address-prefixes"],
            help="The destination address prefixes. CIDR or destination IP ranges.",
        )
        _element.destination_application_security_groups = AAZListArg(
            options=["destination-application-security-groups"],
            help="The application security group specified as destination.",
        )
        _element.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        _element.destination_port_ranges = AAZListArg(
            options=["destination-port-ranges"],
            help="The destination port ranges.",
        )
        _element.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        _element.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        _element.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. ",
        )
        _element.source_address_prefixes = AAZListArg(
            options=["source-address-prefixes"],
            help="The CIDR or source IP ranges.",
        )
        _element.source_application_security_groups = AAZListArg(
            options=["source-application-security-groups"],
            help="The application security group specified as source.",
        )
        _element.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        _element.source_port_ranges = AAZListArg(
            options=["source-port-ranges"],
            help="The source port ranges.",
        )

        destination_address_prefixes = cls._args_network_security_group_create.security_rules.Element.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrArg()

        destination_application_security_groups = cls._args_network_security_group_create.security_rules.Element.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(destination_application_security_groups.Element)

        destination_port_ranges = cls._args_network_security_group_create.security_rules.Element.destination_port_ranges
        destination_port_ranges.Element = AAZStrArg()

        source_address_prefixes = cls._args_network_security_group_create.security_rules.Element.source_address_prefixes
        source_address_prefixes.Element = AAZStrArg()

        source_application_security_groups = cls._args_network_security_group_create.security_rules.Element.source_application_security_groups
        source_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(source_application_security_groups.Element)

        source_port_ranges = cls._args_network_security_group_create.security_rules.Element.source_port_ranges
        source_port_ranges.Element = AAZStrArg()

        tags = cls._args_network_security_group_create.tags
        tags.Element = AAZStrArg()

        _schema.default_security_rules = cls._args_network_security_group_create.default_security_rules
        _schema.etag = cls._args_network_security_group_create.etag
        _schema.id = cls._args_network_security_group_create.id
        _schema.location = cls._args_network_security_group_create.location
        _schema.provisioning_state = cls._args_network_security_group_create.provisioning_state
        _schema.resource_guid = cls._args_network_security_group_create.resource_guid
        _schema.security_rules = cls._args_network_security_group_create.security_rules
        _schema.tags = cls._args_network_security_group_create.tags

    _args_public_ip_address_create = None

    @classmethod
    def _build_args_public_ip_address_create(cls, _schema):
        if cls._args_public_ip_address_create is not None:
            _schema.ddos_settings = cls._args_public_ip_address_create.ddos_settings
            _schema.dns_settings = cls._args_public_ip_address_create.dns_settings
            _schema.etag = cls._args_public_ip_address_create.etag
            _schema.id = cls._args_public_ip_address_create.id
            _schema.idle_timeout_in_minutes = cls._args_public_ip_address_create.idle_timeout_in_minutes
            _schema.ip_address = cls._args_public_ip_address_create.ip_address
            _schema.ip_tags = cls._args_public_ip_address_create.ip_tags
            _schema.location = cls._args_public_ip_address_create.location
            _schema.provisioning_state = cls._args_public_ip_address_create.provisioning_state
            _schema.public_ip_address_version = cls._args_public_ip_address_create.public_ip_address_version
            _schema.public_ip_allocation_method = cls._args_public_ip_address_create.public_ip_allocation_method
            _schema.public_ip_prefix = cls._args_public_ip_address_create.public_ip_prefix
            _schema.resource_guid = cls._args_public_ip_address_create.resource_guid
            _schema.sku = cls._args_public_ip_address_create.sku
            _schema.tags = cls._args_public_ip_address_create.tags
            _schema.zones = cls._args_public_ip_address_create.zones
            return

        cls._args_public_ip_address_create = AAZObjectArg()

        public_ip_address_create = cls._args_public_ip_address_create
        public_ip_address_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        public_ip_address_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/publicIPAddresses/{}",
            ),
        )
        public_ip_address_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        public_ip_address_create.ddos_settings = AAZObjectArg(
            options=["ddos-settings"],
            help="The DDoS protection custom policy associated with the public IP address.",
        )
        public_ip_address_create.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The FQDN of the DNS record associated with the public IP address.",
        )
        public_ip_address_create.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address_create.ip_address = AAZStrArg(
            options=["ip-address"],
            help="The IP address associated with the public IP address resource.",
        )
        public_ip_address_create.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of tags associated with the public IP address.",
        )
        public_ip_address_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        public_ip_address_create.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="The public IP address version. Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address_create.public_ip_allocation_method = AAZStrArg(
            options=["public-ip-allocation-method"],
            help="The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        public_ip_address_create.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The Public IP Prefix this Public IP Address should be allocated from.",
        )
        cls._build_args_sub_resource_create(public_ip_address_create.public_ip_prefix)
        public_ip_address_create.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the public IP resource.",
        )
        public_ip_address_create.sku = AAZObjectArg(
            options=["sku"],
            help="The public IP address SKU.",
        )
        public_ip_address_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )
        public_ip_address_create.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
        )

        ddos_settings = cls._args_public_ip_address_create.ddos_settings
        ddos_settings.ddos_custom_policy = AAZObjectArg(
            options=["ddos-custom-policy"],
            help="The DDoS custom policy associated with the public IP.",
        )
        cls._build_args_sub_resource_create(ddos_settings.ddos_custom_policy)
        ddos_settings.protection_coverage = AAZStrArg(
            options=["protection-coverage"],
            help="The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )

        dns_settings = cls._args_public_ip_address_create.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.",
        )
        dns_settings.fqdn = AAZStrArg(
            options=["fqdn"],
            help="Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.",
        )
        dns_settings.reverse_fqdn = AAZStrArg(
            options=["reverse-fqdn"],
            help="Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. ",
        )

        ip_tags = cls._args_public_ip_address_create.ip_tags
        ip_tags.Element = AAZObjectArg()

        _element = cls._args_public_ip_address_create.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="Gets or sets the ipTag type: Example FirstPartyUsage.",
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="Gets or sets value of the IpTag associated with the public IP. Example SQL, Storage etc",
        )

        sku = cls._args_public_ip_address_create.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of a public IP address SKU.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )

        tags = cls._args_public_ip_address_create.tags
        tags.Element = AAZStrArg()

        zones = cls._args_public_ip_address_create.zones
        zones.Element = AAZStrArg()

        _schema.ddos_settings = cls._args_public_ip_address_create.ddos_settings
        _schema.dns_settings = cls._args_public_ip_address_create.dns_settings
        _schema.etag = cls._args_public_ip_address_create.etag
        _schema.id = cls._args_public_ip_address_create.id
        _schema.idle_timeout_in_minutes = cls._args_public_ip_address_create.idle_timeout_in_minutes
        _schema.ip_address = cls._args_public_ip_address_create.ip_address
        _schema.ip_tags = cls._args_public_ip_address_create.ip_tags
        _schema.location = cls._args_public_ip_address_create.location
        _schema.provisioning_state = cls._args_public_ip_address_create.provisioning_state
        _schema.public_ip_address_version = cls._args_public_ip_address_create.public_ip_address_version
        _schema.public_ip_allocation_method = cls._args_public_ip_address_create.public_ip_allocation_method
        _schema.public_ip_prefix = cls._args_public_ip_address_create.public_ip_prefix
        _schema.resource_guid = cls._args_public_ip_address_create.resource_guid
        _schema.sku = cls._args_public_ip_address_create.sku
        _schema.tags = cls._args_public_ip_address_create.tags
        _schema.zones = cls._args_public_ip_address_create.zones

    _args_security_rule_create = None

    @classmethod
    def _build_args_security_rule_create(cls, _schema):
        if cls._args_security_rule_create is not None:
            _schema.access = cls._args_security_rule_create.access
            _schema.description = cls._args_security_rule_create.description
            _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
            _schema.destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
            _schema.destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
            _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
            _schema.destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
            _schema.direction = cls._args_security_rule_create.direction
            _schema.etag = cls._args_security_rule_create.etag
            _schema.name = cls._args_security_rule_create.name
            _schema.priority = cls._args_security_rule_create.priority
            _schema.protocol = cls._args_security_rule_create.protocol
            _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
            _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
            _schema.source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
            _schema.source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
            _schema.source_port_range = cls._args_security_rule_create.source_port_range
            _schema.source_port_ranges = cls._args_security_rule_create.source_port_ranges
            return

        cls._args_security_rule_create = AAZObjectArg()

        security_rule_create = cls._args_security_rule_create
        security_rule_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        security_rule_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        security_rule_create.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        security_rule_create.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        security_rule_create.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        security_rule_create.destination_address_prefixes = AAZListArg(
            options=["destination-address-prefixes"],
            help="The destination address prefixes. CIDR or destination IP ranges.",
        )
        security_rule_create.destination_application_security_groups = AAZListArg(
            options=["destination-application-security-groups"],
            help="The application security group specified as destination.",
        )
        security_rule_create.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        security_rule_create.destination_port_ranges = AAZListArg(
            options=["destination-port-ranges"],
            help="The destination port ranges.",
        )
        security_rule_create.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        security_rule_create.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        security_rule_create.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        security_rule_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        security_rule_create.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. ",
        )
        security_rule_create.source_address_prefixes = AAZListArg(
            options=["source-address-prefixes"],
            help="The CIDR or source IP ranges.",
        )
        security_rule_create.source_application_security_groups = AAZListArg(
            options=["source-application-security-groups"],
            help="The application security group specified as source.",
        )
        security_rule_create.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        security_rule_create.source_port_ranges = AAZListArg(
            options=["source-port-ranges"],
            help="The source port ranges.",
        )

        destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrArg()

        destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(destination_application_security_groups.Element)

        destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
        destination_port_ranges.Element = AAZStrArg()

        source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
        source_address_prefixes.Element = AAZStrArg()

        source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
        source_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(source_application_security_groups.Element)

        source_port_ranges = cls._args_security_rule_create.source_port_ranges
        source_port_ranges.Element = AAZStrArg()

        _schema.access = cls._args_security_rule_create.access
        _schema.description = cls._args_security_rule_create.description
        _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
        _schema.destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
        _schema.destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
        _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
        _schema.destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
        _schema.direction = cls._args_security_rule_create.direction
        _schema.etag = cls._args_security_rule_create.etag
        _schema.name = cls._args_security_rule_create.name
        _schema.priority = cls._args_security_rule_create.priority
        _schema.protocol = cls._args_security_rule_create.protocol
        _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
        _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
        _schema.source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
        _schema.source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
        _schema.source_port_range = cls._args_security_rule_create.source_port_range
        _schema.source_port_ranges = cls._args_security_rule_create.source_port_ranges

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )

        _schema.id = cls._args_sub_resource_create.id

    _args_subnet_create = None

    @classmethod
    def _build_args_subnet_create(cls, _schema):
        if cls._args_subnet_create is not None:
            _schema.address_prefix = cls._args_subnet_create.address_prefix
            _schema.address_prefixes = cls._args_subnet_create.address_prefixes
            _schema.delegations = cls._args_subnet_create.delegations
            _schema.id = cls._args_subnet_create.id
            _schema.name = cls._args_subnet_create.name
            _schema.network_security_group = cls._args_subnet_create.network_security_group
            _schema.resource_navigation_links = cls._args_subnet_create.resource_navigation_links
            _schema.route_table = cls._args_subnet_create.route_table
            _schema.service_association_links = cls._args_subnet_create.service_association_links
            _schema.service_endpoint_policies = cls._args_subnet_create.service_endpoint_policies
            _schema.service_endpoints = cls._args_subnet_create.service_endpoints
            return

        cls._args_subnet_create = AAZObjectArg()

        subnet_create = cls._args_subnet_create
        subnet_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/virtualNetworks/{}/subnets/{}",
            ),
        )
        subnet_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        subnet_create.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The address prefix for the subnet.",
        )
        subnet_create.address_prefixes = AAZListArg(
            options=["address-prefixes"],
            help="List of  address prefixes for the subnet.",
        )
        subnet_create.delegations = AAZListArg(
            options=["delegations"],
            help="Gets an array of references to the delegations on the subnet.",
        )
        subnet_create.network_security_group = AAZObjectArg(
            options=["network-security-group"],
            help="The reference of the NetworkSecurityGroup resource.",
        )
        cls._build_args_network_security_group_create(subnet_create.network_security_group)
        subnet_create.resource_navigation_links = AAZListArg(
            options=["resource-navigation-links"],
            help="Gets an array of references to the external resources using subnet.",
        )
        subnet_create.route_table = AAZObjectArg(
            options=["route-table"],
            help="The reference of the RouteTable resource.",
        )
        subnet_create.service_association_links = AAZListArg(
            options=["service-association-links"],
            help="Gets an array of references to services injecting into this subnet.",
        )
        subnet_create.service_endpoint_policies = AAZListArg(
            options=["service-endpoint-policies"],
            help="An array of service endpoint policies.",
        )
        subnet_create.service_endpoints = AAZListArg(
            options=["service-endpoints"],
            help="An array of service endpoints.",
        )

        address_prefixes = cls._args_subnet_create.address_prefixes
        address_prefixes.Element = AAZStrArg()

        delegations = cls._args_subnet_create.delegations
        delegations.Element = AAZObjectArg()

        _element = cls._args_subnet_create.delegations.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a subnet. This name can be used to access the resource.",
        )
        _element.actions = AAZListArg(
            options=["actions"],
            help="Describes the actions permitted to the service upon delegation",
        )
        _element.service_name = AAZStrArg(
            options=["service-name"],
            help="The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers)",
        )

        actions = cls._args_subnet_create.delegations.Element.actions
        actions.Element = AAZStrArg()

        resource_navigation_links = cls._args_subnet_create.resource_navigation_links
        resource_navigation_links.Element = AAZObjectArg()

        _element = cls._args_subnet_create.resource_navigation_links.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.link = AAZStrArg(
            options=["link"],
            help="Link to the external resource",
        )
        _element.linked_resource_type = AAZStrArg(
            options=["linked-resource-type"],
            help="Resource type of the linked resource.",
        )

        route_table = cls._args_subnet_create.route_table
        route_table.etag = AAZStrArg(
            options=["etag"],
            help="Gets a unique read-only string that changes whenever the resource is updated.",
        )
        route_table.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}",
            ),
        )
        route_table.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        route_table.disable_bgp_route_propagation = AAZBoolArg(
            options=["disable-bgp-route-propagation"],
            help="Gets or sets whether to disable the routes learned by BGP on that route table. True means disable.",
        )
        route_table.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        route_table.routes = AAZListArg(
            options=["routes"],
            help="Collection of routes contained within a route table.",
        )
        route_table.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        routes = cls._args_subnet_create.route_table.routes
        routes.Element = AAZObjectArg()

        _element = cls._args_subnet_create.route_table.routes.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}/routes/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The destination CIDR to which the route applies.",
        )
        _element.next_hop_ip_address = AAZStrArg(
            options=["next-hop-ip-address"],
            help="The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.",
        )
        _element.next_hop_type = AAZStrArg(
            options=["next-hop-type"],
            help="The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'",
            enum={"Internet": "Internet", "None": "None", "VirtualAppliance": "VirtualAppliance", "VirtualNetworkGateway": "VirtualNetworkGateway", "VnetLocal": "VnetLocal"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )

        tags = cls._args_subnet_create.route_table.tags
        tags.Element = AAZStrArg()

        service_association_links = cls._args_subnet_create.service_association_links
        service_association_links.Element = AAZObjectArg()

        _element = cls._args_subnet_create.service_association_links.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.link = AAZStrArg(
            options=["link"],
            help="Link to the external resource.",
        )
        _element.linked_resource_type = AAZStrArg(
            options=["linked-resource-type"],
            help="Resource type of the linked resource.",
        )

        service_endpoint_policies = cls._args_subnet_create.service_endpoint_policies
        service_endpoint_policies.Element = AAZObjectArg()

        _element = cls._args_subnet_create.service_endpoint_policies.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/serviceEndpointPolicies/{}",
            ),
        )
        _element.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _element.service_endpoint_policy_definitions = AAZListArg(
            options=["service-endpoint-policy-definitions"],
            help="A collection of service endpoint policy definitions of the service endpoint policy.",
        )
        _element.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        service_endpoint_policy_definitions = cls._args_subnet_create.service_endpoint_policies.Element.service_endpoint_policy_definitions
        service_endpoint_policy_definitions.Element = AAZObjectArg()

        _element = cls._args_subnet_create.service_endpoint_policies.Element.service_endpoint_policy_definitions.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/serviceEndpointPolicies/{}/serviceEndpointPolicyDefinitions/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        _element.service = AAZStrArg(
            options=["service"],
            help="service endpoint name.",
        )
        _element.service_resources = AAZListArg(
            options=["service-resources"],
            help="A list of service resources.",
        )

        service_resources = cls._args_subnet_create.service_endpoint_policies.Element.service_endpoint_policy_definitions.Element.service_resources
        service_resources.Element = AAZStrArg()

        tags = cls._args_subnet_create.service_endpoint_policies.Element.tags
        tags.Element = AAZStrArg()

        service_endpoints = cls._args_subnet_create.service_endpoints
        service_endpoints.Element = AAZObjectArg()

        _element = cls._args_subnet_create.service_endpoints.Element
        _element.locations = AAZListArg(
            options=["locations"],
            help="A list of locations.",
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the resource.",
        )
        _element.service = AAZStrArg(
            options=["service"],
            help="The type of the endpoint service.",
        )

        locations = cls._args_subnet_create.service_endpoints.Element.locations
        locations.Element = AAZStrArg()

        _schema.address_prefix = cls._args_subnet_create.address_prefix
        _schema.address_prefixes = cls._args_subnet_create.address_prefixes
        _schema.delegations = cls._args_subnet_create.delegations
        _schema.id = cls._args_subnet_create.id
        _schema.name = cls._args_subnet_create.name
        _schema.network_security_group = cls._args_subnet_create.network_security_group
        _schema.resource_navigation_links = cls._args_subnet_create.resource_navigation_links
        _schema.route_table = cls._args_subnet_create.route_table
        _schema.service_association_links = cls._args_subnet_create.service_association_links
        _schema.service_endpoint_policies = cls._args_subnet_create.service_endpoint_policies
        _schema.service_endpoints = cls._args_subnet_create.service_endpoints

    _args_virtual_network_tap_create = None

    @classmethod
    def _build_args_virtual_network_tap_create(cls, _schema):
        if cls._args_virtual_network_tap_create is not None:
            _schema.destination_load_balancer_front_end_ip_configuration = cls._args_virtual_network_tap_create.destination_load_balancer_front_end_ip_configuration
            _schema.destination_network_interface_ip_configuration = cls._args_virtual_network_tap_create.destination_network_interface_ip_configuration
            _schema.destination_port = cls._args_virtual_network_tap_create.destination_port
            _schema.etag = cls._args_virtual_network_tap_create.etag
            _schema.id = cls._args_virtual_network_tap_create.id
            _schema.location = cls._args_virtual_network_tap_create.location
            _schema.tags = cls._args_virtual_network_tap_create.tags
            return

        cls._args_virtual_network_tap_create = AAZObjectArg()

        virtual_network_tap_create = cls._args_virtual_network_tap_create
        virtual_network_tap_create.etag = AAZStrArg(
            options=["etag"],
            help="Gets a unique read-only string that changes whenever the resource is updated.",
        )
        virtual_network_tap_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/virtualNetworkTaps/{}",
            ),
        )
        virtual_network_tap_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        virtual_network_tap_create.destination_load_balancer_front_end_ip_configuration = AAZObjectArg(
            options=["destination-load-balancer-front-end-ip-configuration"],
            help="The reference to the private IP address on the internal Load Balancer that will receive the tap",
        )
        virtual_network_tap_create.destination_network_interface_ip_configuration = AAZObjectArg(
            options=["destination-network-interface-ip-configuration"],
            help="The reference to the private IP Address of the collector nic that will receive the tap",
        )
        cls._build_args_network_interface_ip_configuration_create(virtual_network_tap_create.destination_network_interface_ip_configuration)
        virtual_network_tap_create.destination_port = AAZIntArg(
            options=["destination-port"],
            help="The VXLAN destination port that will receive the tapped traffic.",
        )
        virtual_network_tap_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        destination_load_balancer_front_end_ip_configuration = cls._args_virtual_network_tap_create.destination_load_balancer_front_end_ip_configuration
        destination_load_balancer_front_end_ip_configuration.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        destination_load_balancer_front_end_ip_configuration.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/frontendIPConfigurations/{}",
            ),
        )
        destination_load_balancer_front_end_ip_configuration.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        destination_load_balancer_front_end_ip_configuration.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="The private IP address of the IP configuration.",
        )
        destination_load_balancer_front_end_ip_configuration.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        destination_load_balancer_front_end_ip_configuration.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        destination_load_balancer_front_end_ip_configuration.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="The reference of the Public IP resource.",
        )
        cls._build_args_public_ip_address_create(destination_load_balancer_front_end_ip_configuration.public_ip_address)
        destination_load_balancer_front_end_ip_configuration.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The reference of the Public IP Prefix resource.",
        )
        cls._build_args_sub_resource_create(destination_load_balancer_front_end_ip_configuration.public_ip_prefix)
        destination_load_balancer_front_end_ip_configuration.subnet = AAZObjectArg(
            options=["subnet"],
            help="The reference of the subnet resource.",
        )
        cls._build_args_subnet_create(destination_load_balancer_front_end_ip_configuration.subnet)
        destination_load_balancer_front_end_ip_configuration.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
        )

        zones = cls._args_virtual_network_tap_create.destination_load_balancer_front_end_ip_configuration.zones
        zones.Element = AAZStrArg()

        tags = cls._args_virtual_network_tap_create.tags
        tags.Element = AAZStrArg()

        _schema.destination_load_balancer_front_end_ip_configuration = cls._args_virtual_network_tap_create.destination_load_balancer_front_end_ip_configuration
        _schema.destination_network_interface_ip_configuration = cls._args_virtual_network_tap_create.destination_network_interface_ip_configuration
        _schema.destination_port = cls._args_virtual_network_tap_create.destination_port
        _schema.etag = cls._args_virtual_network_tap_create.etag
        _schema.id = cls._args_virtual_network_tap_create.id
        _schema.location = cls._args_virtual_network_tap_create.location
        _schema.tags = cls._args_virtual_network_tap_create.tags

    def _execute_operations(self):
        self.pre_operations()
        yield self.NetworkInterfacesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class NetworkInterfacesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "networkInterfaceName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("dnsSettings", AAZObjectType)
                properties.set_prop("enableAcceleratedNetworking", AAZBoolType, ".accelerated_networking")
                properties.set_prop("enableIPForwarding", AAZBoolType, ".ip_forwarding")
                properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations")
                properties.set_prop("networkSecurityGroup", AAZObjectType, ".nsg")

            dns_settings = _builder.get(".properties.dnsSettings")
            if dns_settings is not None:
                dns_settings.set_prop("dnsServers", AAZListType, ".dns_servers")
                dns_settings.set_prop("internalDnsNameLabel", AAZStrType, ".internal_dns_name")

            dns_servers = _builder.get(".properties.dnsSettings.dnsServers")
            if dns_servers is not None:
                dns_servers.set_elements(AAZStrType, ".")

            ip_configurations = _builder.get(".properties.ipConfigurations")
            if ip_configurations is not None:
                ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ipConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.ipConfigurations[].properties")
            if properties is not None:
                properties.set_prop("applicationGatewayBackendAddressPools", AAZListType, ".application_gateway_backend_address_pools")
                properties.set_prop("applicationSecurityGroups", AAZListType, ".application_security_groups")
                properties.set_prop("loadBalancerBackendAddressPools", AAZListType, ".load_balancer_backend_address_pools")
                properties.set_prop("loadBalancerInboundNatRules", AAZListType, ".load_balancer_inbound_nat_rules")
                properties.set_prop("primary", AAZBoolType, ".primary")
                properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
                properties.set_prop("privateIPAddressVersion", AAZStrType, ".private_ip_address_version")
                properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
                properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address")
                _CreateHelper._build_schema_subnet_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

            application_gateway_backend_address_pools = _builder.get(".properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools")
            if application_gateway_backend_address_pools is not None:
                application_gateway_backend_address_pools.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools[].properties")
            if properties is not None:
                properties.set_prop("backendAddresses", AAZListType, ".backend_addresses")

            backend_addresses = _builder.get(".properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools[].properties.backendAddresses")
            if backend_addresses is not None:
                backend_addresses.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools[].properties.backendAddresses[]")
            if _elements is not None:
                _elements.set_prop("fqdn", AAZStrType, ".fqdn")
                _elements.set_prop("ipAddress", AAZStrType, ".ip_address")

            application_security_groups = _builder.get(".properties.ipConfigurations[].properties.applicationSecurityGroups")
            if application_security_groups is not None:
                _CreateHelper._build_schema_application_security_group_create(application_security_groups.set_elements(AAZObjectType, "."))

            load_balancer_backend_address_pools = _builder.get(".properties.ipConfigurations[].properties.loadBalancerBackendAddressPools")
            if load_balancer_backend_address_pools is not None:
                load_balancer_backend_address_pools.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ipConfigurations[].properties.loadBalancerBackendAddressPools[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            load_balancer_inbound_nat_rules = _builder.get(".properties.ipConfigurations[].properties.loadBalancerInboundNatRules")
            if load_balancer_inbound_nat_rules is not None:
                load_balancer_inbound_nat_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ipConfigurations[].properties.loadBalancerInboundNatRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.ipConfigurations[].properties.loadBalancerInboundNatRules[].properties")
            if properties is not None:
                properties.set_prop("backendPort", AAZIntType, ".backend_port")
                properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                properties.set_prop("frontendPort", AAZIntType, ".frontend_port")
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("protocol", AAZStrType, ".protocol")

            public_ip_address = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress")
            if public_ip_address is not None:
                public_ip_address.set_prop("id", AAZStrType, ".id")
                public_ip_address.set_prop("location", AAZStrType, ".location")
                public_ip_address.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                public_ip_address.set_prop("sku", AAZObjectType, ".sku")
                public_ip_address.set_prop("tags", AAZDictType, ".tags")
                public_ip_address.set_prop("zones", AAZListType, ".zones")

            properties = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.properties")
            if properties is not None:
                properties.set_prop("ddosSettings", AAZObjectType, ".ddos_settings")
                properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("ipAddress", AAZStrType, ".ip_address")
                properties.set_prop("ipTags", AAZListType, ".ip_tags")
                properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
                properties.set_prop("publicIPAllocationMethod", AAZStrType, ".public_ip_allocation_method")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))

            ddos_settings = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.properties.ddosSettings")
            if ddos_settings is not None:
                _CreateHelper._build_schema_sub_resource_create(ddos_settings.set_prop("ddosCustomPolicy", AAZObjectType, ".ddos_custom_policy"))
                ddos_settings.set_prop("protectionCoverage", AAZStrType, ".protection_coverage")

            dns_settings = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.properties.dnsSettings")
            if dns_settings is not None:
                dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label")
                dns_settings.set_prop("fqdn", AAZStrType, ".fqdn")
                dns_settings.set_prop("reverseFqdn", AAZStrType, ".reverse_fqdn")

            ip_tags = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.properties.ipTags")
            if ip_tags is not None:
                ip_tags.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.properties.ipTags[]")
            if _elements is not None:
                _elements.set_prop("ipTagType", AAZStrType, ".ip_tag_type")
                _elements.set_prop("tag", AAZStrType, ".tag")

            sku = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.sku")
            if sku is not None:
                sku.set_prop("name", AAZStrType, ".name")

            tags = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            zones = _builder.get(".properties.ipConfigurations[].properties.publicIPAddress.zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            network_security_group = _builder.get(".properties.networkSecurityGroup")
            if network_security_group is not None:
                network_security_group.set_prop("id", AAZStrType, ".id")
                network_security_group.set_prop("location", AAZStrType, ".location")
                network_security_group.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                network_security_group.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.networkSecurityGroup.properties")
            if properties is not None:
                properties.set_prop("securityRules", AAZListType, ".security_rules")

            security_rules = _builder.get(".properties.networkSecurityGroup.properties.securityRules")
            if security_rules is not None:
                security_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkSecurityGroup.properties.securityRules[]")
            if _elements is not None:
                _elements.set_prop("etag", AAZStrType, ".etag")
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.networkSecurityGroup.properties.securityRules[].properties")
            if properties is not None:
                properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix")
                properties.set_prop("destinationAddressPrefixes", AAZListType, ".destination_address_prefixes")
                properties.set_prop("destinationApplicationSecurityGroups", AAZListType, ".destination_application_security_groups")
                properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
                properties.set_prop("destinationPortRanges", AAZListType, ".destination_port_ranges")
                properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("priority", AAZIntType, ".priority")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
                properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix")
                properties.set_prop("sourceAddressPrefixes", AAZListType, ".source_address_prefixes")
                properties.set_prop("sourceApplicationSecurityGroups", AAZListType, ".source_application_security_groups")
                properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")
                properties.set_prop("sourcePortRanges", AAZListType, ".source_port_ranges")

            destination_address_prefixes = _builder.get(".properties.networkSecurityGroup.properties.securityRules[].properties.destinationAddressPrefixes")
            if destination_address_prefixes is not None:
                destination_address_prefixes.set_elements(AAZStrType, ".")

            destination_application_security_groups = _builder.get(".properties.networkSecurityGroup.properties.securityRules[].properties.destinationApplicationSecurityGroups")
            if destination_application_security_groups is not None:
                _CreateHelper._build_schema_application_security_group_create(destination_application_security_groups.set_elements(AAZObjectType, "."))

            destination_port_ranges = _builder.get(".properties.networkSecurityGroup.properties.securityRules[].properties.destinationPortRanges")
            if destination_port_ranges is not None:
                destination_port_ranges.set_elements(AAZStrType, ".")

            source_address_prefixes = _builder.get(".properties.networkSecurityGroup.properties.securityRules[].properties.sourceAddressPrefixes")
            if source_address_prefixes is not None:
                source_address_prefixes.set_elements(AAZStrType, ".")

            source_application_security_groups = _builder.get(".properties.networkSecurityGroup.properties.securityRules[].properties.sourceApplicationSecurityGroups")
            if source_application_security_groups is not None:
                _CreateHelper._build_schema_application_security_group_create(source_application_security_groups.set_elements(AAZObjectType, "."))

            source_port_ranges = _builder.get(".properties.networkSecurityGroup.properties.securityRules[].properties.sourcePortRanges")
            if source_port_ranges is not None:
                source_port_ranges.set_elements(AAZStrType, ".")

            tags = _builder.get(".properties.networkSecurityGroup.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _CreateHelper._build_schema_network_interface_read(cls._schema_on_200_201)

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_application_security_group_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("tags", AAZDictType, ".tags")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_network_interface_ip_configuration_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("applicationGatewayBackendAddressPools", AAZListType, ".application_gateway_backend_address_pools")
            properties.set_prop("applicationSecurityGroups", AAZListType, ".application_security_groups")
            properties.set_prop("loadBalancerBackendAddressPools", AAZListType, ".load_balancer_backend_address_pools")
            properties.set_prop("loadBalancerInboundNatRules", AAZListType, ".load_balancer_inbound_nat_rules")
            properties.set_prop("primary", AAZBoolType, ".primary")
            properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
            properties.set_prop("privateIPAddressVersion", AAZStrType, ".private_ip_address_version")
            properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
            properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address")
            cls._build_schema_subnet_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))
            properties.set_prop("virtualNetworkTaps", AAZListType, ".virtual_network_taps")

        application_gateway_backend_address_pools = _builder.get(".properties.applicationGatewayBackendAddressPools")
        if application_gateway_backend_address_pools is not None:
            application_gateway_backend_address_pools.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.applicationGatewayBackendAddressPools[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _elements.set_prop("type", AAZStrType, ".type")

        properties = _builder.get(".properties.applicationGatewayBackendAddressPools[].properties")
        if properties is not None:
            properties.set_prop("backendAddresses", AAZListType, ".backend_addresses")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

        backend_addresses = _builder.get(".properties.applicationGatewayBackendAddressPools[].properties.backendAddresses")
        if backend_addresses is not None:
            backend_addresses.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.applicationGatewayBackendAddressPools[].properties.backendAddresses[]")
        if _elements is not None:
            _elements.set_prop("fqdn", AAZStrType, ".fqdn")
            _elements.set_prop("ipAddress", AAZStrType, ".ip_address")

        application_security_groups = _builder.get(".properties.applicationSecurityGroups")
        if application_security_groups is not None:
            cls._build_schema_application_security_group_create(application_security_groups.set_elements(AAZObjectType, "."))

        load_balancer_backend_address_pools = _builder.get(".properties.loadBalancerBackendAddressPools")
        if load_balancer_backend_address_pools is not None:
            load_balancer_backend_address_pools.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.loadBalancerBackendAddressPools[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.loadBalancerBackendAddressPools[].properties")
        if properties is not None:
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

        load_balancer_inbound_nat_rules = _builder.get(".properties.loadBalancerInboundNatRules")
        if load_balancer_inbound_nat_rules is not None:
            load_balancer_inbound_nat_rules.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.loadBalancerInboundNatRules[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.loadBalancerInboundNatRules[].properties")
        if properties is not None:
            properties.set_prop("backendPort", AAZIntType, ".backend_port")
            properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
            properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
            cls._build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
            properties.set_prop("frontendPort", AAZIntType, ".frontend_port")
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("protocol", AAZStrType, ".protocol")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

        public_ip_address = _builder.get(".properties.publicIPAddress")
        if public_ip_address is not None:
            public_ip_address.set_prop("etag", AAZStrType, ".etag")
            public_ip_address.set_prop("id", AAZStrType, ".id")
            public_ip_address.set_prop("location", AAZStrType, ".location")
            public_ip_address.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            public_ip_address.set_prop("sku", AAZObjectType, ".sku")
            public_ip_address.set_prop("tags", AAZDictType, ".tags")
            public_ip_address.set_prop("zones", AAZListType, ".zones")

        properties = _builder.get(".properties.publicIPAddress.properties")
        if properties is not None:
            properties.set_prop("ddosSettings", AAZObjectType, ".ddos_settings")
            properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("ipAddress", AAZStrType, ".ip_address")
            properties.set_prop("ipTags", AAZListType, ".ip_tags")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
            properties.set_prop("publicIPAllocationMethod", AAZStrType, ".public_ip_allocation_method")
            cls._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))
            properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")

        ddos_settings = _builder.get(".properties.publicIPAddress.properties.ddosSettings")
        if ddos_settings is not None:
            cls._build_schema_sub_resource_create(ddos_settings.set_prop("ddosCustomPolicy", AAZObjectType, ".ddos_custom_policy"))
            ddos_settings.set_prop("protectionCoverage", AAZStrType, ".protection_coverage")

        dns_settings = _builder.get(".properties.publicIPAddress.properties.dnsSettings")
        if dns_settings is not None:
            dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label")
            dns_settings.set_prop("fqdn", AAZStrType, ".fqdn")
            dns_settings.set_prop("reverseFqdn", AAZStrType, ".reverse_fqdn")

        ip_tags = _builder.get(".properties.publicIPAddress.properties.ipTags")
        if ip_tags is not None:
            ip_tags.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.publicIPAddress.properties.ipTags[]")
        if _elements is not None:
            _elements.set_prop("ipTagType", AAZStrType, ".ip_tag_type")
            _elements.set_prop("tag", AAZStrType, ".tag")

        sku = _builder.get(".properties.publicIPAddress.sku")
        if sku is not None:
            sku.set_prop("name", AAZStrType, ".name")

        tags = _builder.get(".properties.publicIPAddress.tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

        zones = _builder.get(".properties.publicIPAddress.zones")
        if zones is not None:
            zones.set_elements(AAZStrType, ".")

        virtual_network_taps = _builder.get(".properties.virtualNetworkTaps")
        if virtual_network_taps is not None:
            virtual_network_taps.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.virtualNetworkTaps[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("location", AAZStrType, ".location")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _elements.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties.virtualNetworkTaps[].properties")
        if properties is not None:
            properties.set_prop("destinationLoadBalancerFrontEndIPConfiguration", AAZObjectType, ".destination_load_balancer_front_end_ip_configuration")
            cls._build_schema_network_interface_ip_configuration_create(properties.set_prop("destinationNetworkInterfaceIPConfiguration", AAZObjectType, ".destination_network_interface_ip_configuration"))
            properties.set_prop("destinationPort", AAZIntType, ".destination_port")

        destination_load_balancer_front_end_ip_configuration = _builder.get(".properties.virtualNetworkTaps[].properties.destinationLoadBalancerFrontEndIPConfiguration")
        if destination_load_balancer_front_end_ip_configuration is not None:
            destination_load_balancer_front_end_ip_configuration.set_prop("etag", AAZStrType, ".etag")
            destination_load_balancer_front_end_ip_configuration.set_prop("id", AAZStrType, ".id")
            destination_load_balancer_front_end_ip_configuration.set_prop("name", AAZStrType, ".name")
            destination_load_balancer_front_end_ip_configuration.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            destination_load_balancer_front_end_ip_configuration.set_prop("zones", AAZListType, ".zones")

        properties = _builder.get(".properties.virtualNetworkTaps[].properties.destinationLoadBalancerFrontEndIPConfiguration.properties")
        if properties is not None:
            properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
            properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            cls._build_schema_public_ip_address_create(properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address"))
            cls._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))
            cls._build_schema_subnet_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

        zones = _builder.get(".properties.virtualNetworkTaps[].properties.destinationLoadBalancerFrontEndIPConfiguration.zones")
        if zones is not None:
            zones.set_elements(AAZStrType, ".")

        tags = _builder.get(".properties.virtualNetworkTaps[].tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_network_security_group_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
        _builder.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("defaultSecurityRules", AAZListType, ".default_security_rules")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")
            properties.set_prop("securityRules", AAZListType, ".security_rules")

        default_security_rules = _builder.get(".properties.defaultSecurityRules")
        if default_security_rules is not None:
            cls._build_schema_security_rule_create(default_security_rules.set_elements(AAZObjectType, "."))

        security_rules = _builder.get(".properties.securityRules")
        if security_rules is not None:
            security_rules.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.securityRules[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.securityRules[].properties")
        if properties is not None:
            properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("description", AAZStrType, ".description")
            properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix")
            properties.set_prop("destinationAddressPrefixes", AAZListType, ".destination_address_prefixes")
            properties.set_prop("destinationApplicationSecurityGroups", AAZListType, ".destination_application_security_groups")
            properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
            properties.set_prop("destinationPortRanges", AAZListType, ".destination_port_ranges")
            properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("priority", AAZIntType, ".priority")
            properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix")
            properties.set_prop("sourceAddressPrefixes", AAZListType, ".source_address_prefixes")
            properties.set_prop("sourceApplicationSecurityGroups", AAZListType, ".source_application_security_groups")
            properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")
            properties.set_prop("sourcePortRanges", AAZListType, ".source_port_ranges")

        destination_address_prefixes = _builder.get(".properties.securityRules[].properties.destinationAddressPrefixes")
        if destination_address_prefixes is not None:
            destination_address_prefixes.set_elements(AAZStrType, ".")

        destination_application_security_groups = _builder.get(".properties.securityRules[].properties.destinationApplicationSecurityGroups")
        if destination_application_security_groups is not None:
            cls._build_schema_application_security_group_create(destination_application_security_groups.set_elements(AAZObjectType, "."))

        destination_port_ranges = _builder.get(".properties.securityRules[].properties.destinationPortRanges")
        if destination_port_ranges is not None:
            destination_port_ranges.set_elements(AAZStrType, ".")

        source_address_prefixes = _builder.get(".properties.securityRules[].properties.sourceAddressPrefixes")
        if source_address_prefixes is not None:
            source_address_prefixes.set_elements(AAZStrType, ".")

        source_application_security_groups = _builder.get(".properties.securityRules[].properties.sourceApplicationSecurityGroups")
        if source_application_security_groups is not None:
            cls._build_schema_application_security_group_create(source_application_security_groups.set_elements(AAZObjectType, "."))

        source_port_ranges = _builder.get(".properties.securityRules[].properties.sourcePortRanges")
        if source_port_ranges is not None:
            source_port_ranges.set_elements(AAZStrType, ".")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_public_ip_address_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
        _builder.set_prop("sku", AAZObjectType, ".sku")
        _builder.set_prop("tags", AAZDictType, ".tags")
        _builder.set_prop("zones", AAZListType, ".zones")

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("ddosSettings", AAZObjectType, ".ddos_settings")
            properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("ipAddress", AAZStrType, ".ip_address")
            properties.set_prop("ipTags", AAZListType, ".ip_tags")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
            properties.set_prop("publicIPAllocationMethod", AAZStrType, ".public_ip_allocation_method")
            cls._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))
            properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")

        ddos_settings = _builder.get(".properties.ddosSettings")
        if ddos_settings is not None:
            cls._build_schema_sub_resource_create(ddos_settings.set_prop("ddosCustomPolicy", AAZObjectType, ".ddos_custom_policy"))
            ddos_settings.set_prop("protectionCoverage", AAZStrType, ".protection_coverage")

        dns_settings = _builder.get(".properties.dnsSettings")
        if dns_settings is not None:
            dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label")
            dns_settings.set_prop("fqdn", AAZStrType, ".fqdn")
            dns_settings.set_prop("reverseFqdn", AAZStrType, ".reverse_fqdn")

        ip_tags = _builder.get(".properties.ipTags")
        if ip_tags is not None:
            ip_tags.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.ipTags[]")
        if _elements is not None:
            _elements.set_prop("ipTagType", AAZStrType, ".ip_tag_type")
            _elements.set_prop("tag", AAZStrType, ".tag")

        sku = _builder.get(".sku")
        if sku is not None:
            sku.set_prop("name", AAZStrType, ".name")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

        zones = _builder.get(".zones")
        if zones is not None:
            zones.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_security_rule_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("description", AAZStrType, ".description")
            properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix")
            properties.set_prop("destinationAddressPrefixes", AAZListType, ".destination_address_prefixes")
            properties.set_prop("destinationApplicationSecurityGroups", AAZListType, ".destination_application_security_groups")
            properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
            properties.set_prop("destinationPortRanges", AAZListType, ".destination_port_ranges")
            properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("priority", AAZIntType, ".priority")
            properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix")
            properties.set_prop("sourceAddressPrefixes", AAZListType, ".source_address_prefixes")
            properties.set_prop("sourceApplicationSecurityGroups", AAZListType, ".source_application_security_groups")
            properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")
            properties.set_prop("sourcePortRanges", AAZListType, ".source_port_ranges")

        destination_address_prefixes = _builder.get(".properties.destinationAddressPrefixes")
        if destination_address_prefixes is not None:
            destination_address_prefixes.set_elements(AAZStrType, ".")

        destination_application_security_groups = _builder.get(".properties.destinationApplicationSecurityGroups")
        if destination_application_security_groups is not None:
            cls._build_schema_application_security_group_create(destination_application_security_groups.set_elements(AAZObjectType, "."))

        destination_port_ranges = _builder.get(".properties.destinationPortRanges")
        if destination_port_ranges is not None:
            destination_port_ranges.set_elements(AAZStrType, ".")

        source_address_prefixes = _builder.get(".properties.sourceAddressPrefixes")
        if source_address_prefixes is not None:
            source_address_prefixes.set_elements(AAZStrType, ".")

        source_application_security_groups = _builder.get(".properties.sourceApplicationSecurityGroups")
        if source_application_security_groups is not None:
            cls._build_schema_application_security_group_create(source_application_security_groups.set_elements(AAZObjectType, "."))

        source_port_ranges = _builder.get(".properties.sourcePortRanges")
        if source_port_ranges is not None:
            source_port_ranges.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_sub_resource_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_subnet_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
            properties.set_prop("addressPrefixes", AAZListType, ".address_prefixes")
            properties.set_prop("delegations", AAZListType, ".delegations")
            cls._build_schema_network_security_group_create(properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group"))
            properties.set_prop("resourceNavigationLinks", AAZListType, ".resource_navigation_links")
            properties.set_prop("routeTable", AAZObjectType, ".route_table")
            properties.set_prop("serviceAssociationLinks", AAZListType, ".service_association_links")
            properties.set_prop("serviceEndpointPolicies", AAZListType, ".service_endpoint_policies")
            properties.set_prop("serviceEndpoints", AAZListType, ".service_endpoints")

        address_prefixes = _builder.get(".properties.addressPrefixes")
        if address_prefixes is not None:
            address_prefixes.set_elements(AAZStrType, ".")

        delegations = _builder.get(".properties.delegations")
        if delegations is not None:
            delegations.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.delegations[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.delegations[].properties")
        if properties is not None:
            properties.set_prop("actions", AAZListType, ".actions")
            properties.set_prop("serviceName", AAZStrType, ".service_name")

        actions = _builder.get(".properties.delegations[].properties.actions")
        if actions is not None:
            actions.set_elements(AAZStrType, ".")

        resource_navigation_links = _builder.get(".properties.resourceNavigationLinks")
        if resource_navigation_links is not None:
            resource_navigation_links.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.resourceNavigationLinks[]")
        if _elements is not None:
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.resourceNavigationLinks[].properties")
        if properties is not None:
            properties.set_prop("link", AAZStrType, ".link")
            properties.set_prop("linkedResourceType", AAZStrType, ".linked_resource_type")

        route_table = _builder.get(".properties.routeTable")
        if route_table is not None:
            route_table.set_prop("etag", AAZStrType, ".etag")
            route_table.set_prop("id", AAZStrType, ".id")
            route_table.set_prop("location", AAZStrType, ".location")
            route_table.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            route_table.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties.routeTable.properties")
        if properties is not None:
            properties.set_prop("disableBgpRoutePropagation", AAZBoolType, ".disable_bgp_route_propagation")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("routes", AAZListType, ".routes")

        routes = _builder.get(".properties.routeTable.properties.routes")
        if routes is not None:
            routes.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.routeTable.properties.routes[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.routeTable.properties.routes[].properties")
        if properties is not None:
            properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
            properties.set_prop("nextHopIpAddress", AAZStrType, ".next_hop_ip_address")
            properties.set_prop("nextHopType", AAZStrType, ".next_hop_type", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

        tags = _builder.get(".properties.routeTable.tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

        service_association_links = _builder.get(".properties.serviceAssociationLinks")
        if service_association_links is not None:
            service_association_links.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.serviceAssociationLinks[]")
        if _elements is not None:
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.serviceAssociationLinks[].properties")
        if properties is not None:
            properties.set_prop("link", AAZStrType, ".link")
            properties.set_prop("linkedResourceType", AAZStrType, ".linked_resource_type")

        service_endpoint_policies = _builder.get(".properties.serviceEndpointPolicies")
        if service_endpoint_policies is not None:
            service_endpoint_policies.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.serviceEndpointPolicies[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("location", AAZStrType, ".location")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _elements.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties.serviceEndpointPolicies[].properties")
        if properties is not None:
            properties.set_prop("serviceEndpointPolicyDefinitions", AAZListType, ".service_endpoint_policy_definitions")

        service_endpoint_policy_definitions = _builder.get(".properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions")
        if service_endpoint_policy_definitions is not None:
            service_endpoint_policy_definitions.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions[].properties")
        if properties is not None:
            properties.set_prop("description", AAZStrType, ".description")
            properties.set_prop("service", AAZStrType, ".service")
            properties.set_prop("serviceResources", AAZListType, ".service_resources")

        service_resources = _builder.get(".properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions[].properties.serviceResources")
        if service_resources is not None:
            service_resources.set_elements(AAZStrType, ".")

        tags = _builder.get(".properties.serviceEndpointPolicies[].tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

        service_endpoints = _builder.get(".properties.serviceEndpoints")
        if service_endpoints is not None:
            service_endpoints.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.serviceEndpoints[]")
        if _elements is not None:
            _elements.set_prop("locations", AAZListType, ".locations")
            _elements.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            _elements.set_prop("service", AAZStrType, ".service")

        locations = _builder.get(".properties.serviceEndpoints[].locations")
        if locations is not None:
            locations.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_virtual_network_tap_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
        _builder.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("destinationLoadBalancerFrontEndIPConfiguration", AAZObjectType, ".destination_load_balancer_front_end_ip_configuration")
            cls._build_schema_network_interface_ip_configuration_create(properties.set_prop("destinationNetworkInterfaceIPConfiguration", AAZObjectType, ".destination_network_interface_ip_configuration"))
            properties.set_prop("destinationPort", AAZIntType, ".destination_port")

        destination_load_balancer_front_end_ip_configuration = _builder.get(".properties.destinationLoadBalancerFrontEndIPConfiguration")
        if destination_load_balancer_front_end_ip_configuration is not None:
            destination_load_balancer_front_end_ip_configuration.set_prop("etag", AAZStrType, ".etag")
            destination_load_balancer_front_end_ip_configuration.set_prop("id", AAZStrType, ".id")
            destination_load_balancer_front_end_ip_configuration.set_prop("name", AAZStrType, ".name")
            destination_load_balancer_front_end_ip_configuration.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            destination_load_balancer_front_end_ip_configuration.set_prop("zones", AAZListType, ".zones")

        properties = _builder.get(".properties.destinationLoadBalancerFrontEndIPConfiguration.properties")
        if properties is not None:
            properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
            properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            cls._build_schema_public_ip_address_create(properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address"))
            cls._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))
            cls._build_schema_subnet_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

        zones = _builder.get(".properties.destinationLoadBalancerFrontEndIPConfiguration.zones")
        if zones is not None:
            zones.set_elements(AAZStrType, ".")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    _schema_application_security_group_read = None

    @classmethod
    def _build_schema_application_security_group_read(cls, _schema):
        if cls._schema_application_security_group_read is not None:
            _schema.etag = cls._schema_application_security_group_read.etag
            _schema.id = cls._schema_application_security_group_read.id
            _schema.location = cls._schema_application_security_group_read.location
            _schema.name = cls._schema_application_security_group_read.name
            _schema.properties = cls._schema_application_security_group_read.properties
            _schema.tags = cls._schema_application_security_group_read.tags
            _schema.type = cls._schema_application_security_group_read.type
            return

        cls._schema_application_security_group_read = _schema_application_security_group_read = AAZObjectType()

        application_security_group_read = _schema_application_security_group_read
        application_security_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.id = AAZStrType()
        application_security_group_read.location = AAZStrType()
        application_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        application_security_group_read.tags = AAZDictType()
        application_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_application_security_group_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        tags = _schema_application_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_application_security_group_read.etag
        _schema.id = cls._schema_application_security_group_read.id
        _schema.location = cls._schema_application_security_group_read.location
        _schema.name = cls._schema_application_security_group_read.name
        _schema.properties = cls._schema_application_security_group_read.properties
        _schema.tags = cls._schema_application_security_group_read.tags
        _schema.type = cls._schema_application_security_group_read.type

    _schema_ip_configuration_read = None

    @classmethod
    def _build_schema_ip_configuration_read(cls, _schema):
        if cls._schema_ip_configuration_read is not None:
            _schema.etag = cls._schema_ip_configuration_read.etag
            _schema.id = cls._schema_ip_configuration_read.id
            _schema.name = cls._schema_ip_configuration_read.name
            _schema.properties = cls._schema_ip_configuration_read.properties
            return

        cls._schema_ip_configuration_read = _schema_ip_configuration_read = AAZObjectType()

        ip_configuration_read = _schema_ip_configuration_read
        ip_configuration_read.etag = AAZStrType()
        ip_configuration_read.id = AAZStrType()
        ip_configuration_read.name = AAZStrType()
        ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_ip_configuration_read.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        _schema.etag = cls._schema_ip_configuration_read.etag
        _schema.id = cls._schema_ip_configuration_read.id
        _schema.name = cls._schema_ip_configuration_read.name
        _schema.properties = cls._schema_ip_configuration_read.properties

    _schema_interface_endpoint_read = None

    @classmethod
    def _build_schema_interface_endpoint_read(cls, _schema):
        if cls._schema_interface_endpoint_read is not None:
            _schema.etag = cls._schema_interface_endpoint_read.etag
            _schema.id = cls._schema_interface_endpoint_read.id
            _schema.location = cls._schema_interface_endpoint_read.location
            _schema.name = cls._schema_interface_endpoint_read.name
            _schema.properties = cls._schema_interface_endpoint_read.properties
            _schema.tags = cls._schema_interface_endpoint_read.tags
            _schema.type = cls._schema_interface_endpoint_read.type
            return

        cls._schema_interface_endpoint_read = _schema_interface_endpoint_read = AAZObjectType()

        interface_endpoint_read = _schema_interface_endpoint_read
        interface_endpoint_read.etag = AAZStrType()
        interface_endpoint_read.id = AAZStrType()
        interface_endpoint_read.location = AAZStrType()
        interface_endpoint_read.name = AAZStrType(
            flags={"read_only": True},
        )
        interface_endpoint_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        interface_endpoint_read.tags = AAZDictType()
        interface_endpoint_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_interface_endpoint_read.properties
        properties.endpoint_service = AAZObjectType(
            serialized_name="endpointService",
        )
        properties.fqdn = AAZStrType()
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.owner = AAZStrType(
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        endpoint_service = _schema_interface_endpoint_read.properties.endpoint_service
        endpoint_service.id = AAZStrType()

        network_interfaces = _schema_interface_endpoint_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        tags = _schema_interface_endpoint_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_interface_endpoint_read.etag
        _schema.id = cls._schema_interface_endpoint_read.id
        _schema.location = cls._schema_interface_endpoint_read.location
        _schema.name = cls._schema_interface_endpoint_read.name
        _schema.properties = cls._schema_interface_endpoint_read.properties
        _schema.tags = cls._schema_interface_endpoint_read.tags
        _schema.type = cls._schema_interface_endpoint_read.type

    _schema_network_interface_ip_configuration_read = None

    @classmethod
    def _build_schema_network_interface_ip_configuration_read(cls, _schema):
        if cls._schema_network_interface_ip_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
            _schema.id = cls._schema_network_interface_ip_configuration_read.id
            _schema.name = cls._schema_network_interface_ip_configuration_read.name
            _schema.properties = cls._schema_network_interface_ip_configuration_read.properties
            return

        cls._schema_network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read = AAZObjectType()

        network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
        network_interface_ip_configuration_read.etag = AAZStrType()
        network_interface_ip_configuration_read.id = AAZStrType()
        network_interface_ip_configuration_read.name = AAZStrType()
        network_interface_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_rules = AAZListType(
            serialized_name="loadBalancerInboundNatRules",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)
        properties.virtual_network_taps = AAZListType(
            serialized_name="virtualNetworkTaps",
        )

        application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType()

        properties = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties
        properties.backend_addresses = AAZListType(
            serialized_name="backendAddresses",
        )
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_addresses = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses
        backend_addresses.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses.Element
        _element.fqdn = AAZStrType()
        _element.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_rule = AAZObjectType(
            serialized_name="outboundRule",
        )
        cls._build_schema_sub_resource_read(properties.outbound_rule)
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        load_balancing_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element.properties
        properties.backend_ip_configuration = AAZObjectType(
            serialized_name="backendIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.enable_tcp_reset = AAZBoolType(
            serialized_name="enableTcpReset",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port = AAZIntType(
            serialized_name="frontendPort",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        virtual_network_taps = _schema_network_interface_ip_configuration_read.properties.virtual_network_taps
        virtual_network_taps.Element = AAZObjectType()
        cls._build_schema_virtual_network_tap_read(virtual_network_taps.Element)

        _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
        _schema.id = cls._schema_network_interface_ip_configuration_read.id
        _schema.name = cls._schema_network_interface_ip_configuration_read.name
        _schema.properties = cls._schema_network_interface_ip_configuration_read.properties

    _schema_network_interface_tap_configuration_read = None

    @classmethod
    def _build_schema_network_interface_tap_configuration_read(cls, _schema):
        if cls._schema_network_interface_tap_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
            _schema.id = cls._schema_network_interface_tap_configuration_read.id
            _schema.name = cls._schema_network_interface_tap_configuration_read.name
            _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
            _schema.type = cls._schema_network_interface_tap_configuration_read.type
            return

        cls._schema_network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read = AAZObjectType()

        network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read
        network_interface_tap_configuration_read.etag = AAZStrType()
        network_interface_tap_configuration_read.id = AAZStrType()
        network_interface_tap_configuration_read.name = AAZStrType()
        network_interface_tap_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_tap_configuration_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_tap_configuration_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.virtual_network_tap = AAZObjectType(
            serialized_name="virtualNetworkTap",
        )
        cls._build_schema_virtual_network_tap_read(properties.virtual_network_tap)

        _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
        _schema.id = cls._schema_network_interface_tap_configuration_read.id
        _schema.name = cls._schema_network_interface_tap_configuration_read.name
        _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
        _schema.type = cls._schema_network_interface_tap_configuration_read.type

    _schema_network_interface_read = None

    @classmethod
    def _build_schema_network_interface_read(cls, _schema):
        if cls._schema_network_interface_read is not None:
            _schema.etag = cls._schema_network_interface_read.etag
            _schema.id = cls._schema_network_interface_read.id
            _schema.location = cls._schema_network_interface_read.location
            _schema.name = cls._schema_network_interface_read.name
            _schema.properties = cls._schema_network_interface_read.properties
            _schema.tags = cls._schema_network_interface_read.tags
            _schema.type = cls._schema_network_interface_read.type
            return

        cls._schema_network_interface_read = _schema_network_interface_read = AAZObjectType()

        network_interface_read = _schema_network_interface_read
        network_interface_read.etag = AAZStrType()
        network_interface_read.id = AAZStrType()
        network_interface_read.location = AAZStrType()
        network_interface_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_read.tags = AAZDictType()
        network_interface_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_read.properties
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.hosted_workloads = AAZListType(
            serialized_name="hostedWorkloads",
            flags={"read_only": True},
        )
        properties.interface_endpoint = AAZObjectType(
            serialized_name="interfaceEndpoint",
        )
        cls._build_schema_interface_endpoint_read(properties.interface_endpoint)
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.mac_address = AAZStrType(
            serialized_name="macAddress",
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.primary = AAZBoolType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.tap_configurations = AAZListType(
            serialized_name="tapConfigurations",
        )
        properties.virtual_machine = AAZObjectType(
            serialized_name="virtualMachine",
        )
        cls._build_schema_sub_resource_read(properties.virtual_machine)

        dns_settings = _schema_network_interface_read.properties.dns_settings
        dns_settings.applied_dns_servers = AAZListType(
            serialized_name="appliedDnsServers",
        )
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )
        dns_settings.internal_dns_name_label = AAZStrType(
            serialized_name="internalDnsNameLabel",
        )
        dns_settings.internal_domain_name_suffix = AAZStrType(
            serialized_name="internalDomainNameSuffix",
        )
        dns_settings.internal_fqdn = AAZStrType(
            serialized_name="internalFqdn",
        )

        applied_dns_servers = _schema_network_interface_read.properties.dns_settings.applied_dns_servers
        applied_dns_servers.Element = AAZStrType()

        dns_servers = _schema_network_interface_read.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        hosted_workloads = _schema_network_interface_read.properties.hosted_workloads
        hosted_workloads.Element = AAZStrType()

        ip_configurations = _schema_network_interface_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

        tap_configurations = _schema_network_interface_read.properties.tap_configurations
        tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(tap_configurations.Element)

        tags = _schema_network_interface_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_interface_read.etag
        _schema.id = cls._schema_network_interface_read.id
        _schema.location = cls._schema_network_interface_read.location
        _schema.name = cls._schema_network_interface_read.name
        _schema.properties = cls._schema_network_interface_read.properties
        _schema.tags = cls._schema_network_interface_read.tags
        _schema.type = cls._schema_network_interface_read.type

    _schema_network_security_group_read = None

    @classmethod
    def _build_schema_network_security_group_read(cls, _schema):
        if cls._schema_network_security_group_read is not None:
            _schema.etag = cls._schema_network_security_group_read.etag
            _schema.id = cls._schema_network_security_group_read.id
            _schema.location = cls._schema_network_security_group_read.location
            _schema.name = cls._schema_network_security_group_read.name
            _schema.properties = cls._schema_network_security_group_read.properties
            _schema.tags = cls._schema_network_security_group_read.tags
            _schema.type = cls._schema_network_security_group_read.type
            return

        cls._schema_network_security_group_read = _schema_network_security_group_read = AAZObjectType()

        network_security_group_read = _schema_network_security_group_read
        network_security_group_read.etag = AAZStrType()
        network_security_group_read.id = AAZStrType()
        network_security_group_read.location = AAZStrType()
        network_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_security_group_read.tags = AAZDictType()
        network_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties
        properties.default_security_rules = AAZListType(
            serialized_name="defaultSecurityRules",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.security_rules = AAZListType(
            serialized_name="securityRules",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        default_security_rules = _schema_network_security_group_read.properties.default_security_rules
        default_security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(default_security_rules.Element)

        network_interfaces = _schema_network_security_group_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        security_rules = _schema_network_security_group_read.properties.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        subnets = _schema_network_security_group_read.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_network_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_security_group_read.etag
        _schema.id = cls._schema_network_security_group_read.id
        _schema.location = cls._schema_network_security_group_read.location
        _schema.name = cls._schema_network_security_group_read.name
        _schema.properties = cls._schema_network_security_group_read.properties
        _schema.tags = cls._schema_network_security_group_read.tags
        _schema.type = cls._schema_network_security_group_read.type

    _schema_public_ip_address_read = None

    @classmethod
    def _build_schema_public_ip_address_read(cls, _schema):
        if cls._schema_public_ip_address_read is not None:
            _schema.etag = cls._schema_public_ip_address_read.etag
            _schema.id = cls._schema_public_ip_address_read.id
            _schema.location = cls._schema_public_ip_address_read.location
            _schema.name = cls._schema_public_ip_address_read.name
            _schema.properties = cls._schema_public_ip_address_read.properties
            _schema.sku = cls._schema_public_ip_address_read.sku
            _schema.tags = cls._schema_public_ip_address_read.tags
            _schema.type = cls._schema_public_ip_address_read.type
            _schema.zones = cls._schema_public_ip_address_read.zones
            return

        cls._schema_public_ip_address_read = _schema_public_ip_address_read = AAZObjectType()

        public_ip_address_read = _schema_public_ip_address_read
        public_ip_address_read.etag = AAZStrType()
        public_ip_address_read.id = AAZStrType()
        public_ip_address_read.location = AAZStrType()
        public_ip_address_read.name = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_read.sku = AAZObjectType()
        public_ip_address_read.tags = AAZDictType()
        public_ip_address_read.type = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.zones = AAZListType()

        properties = _schema_public_ip_address_read.properties
        properties.ddos_settings = AAZObjectType(
            serialized_name="ddosSettings",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )
        properties.ip_configuration = AAZObjectType(
            serialized_name="ipConfiguration",
        )
        cls._build_schema_ip_configuration_read(properties.ip_configuration)
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_allocation_method = AAZStrType(
            serialized_name="publicIPAllocationMethod",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )

        ddos_settings = _schema_public_ip_address_read.properties.ddos_settings
        ddos_settings.ddos_custom_policy = AAZObjectType(
            serialized_name="ddosCustomPolicy",
        )
        cls._build_schema_sub_resource_read(ddos_settings.ddos_custom_policy)
        ddos_settings.protection_coverage = AAZStrType(
            serialized_name="protectionCoverage",
        )

        dns_settings = _schema_public_ip_address_read.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
        )
        dns_settings.fqdn = AAZStrType()
        dns_settings.reverse_fqdn = AAZStrType(
            serialized_name="reverseFqdn",
        )

        ip_tags = _schema_public_ip_address_read.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_public_ip_address_read.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        sku = _schema_public_ip_address_read.sku
        sku.name = AAZStrType()

        tags = _schema_public_ip_address_read.tags
        tags.Element = AAZStrType()

        zones = _schema_public_ip_address_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_public_ip_address_read.etag
        _schema.id = cls._schema_public_ip_address_read.id
        _schema.location = cls._schema_public_ip_address_read.location
        _schema.name = cls._schema_public_ip_address_read.name
        _schema.properties = cls._schema_public_ip_address_read.properties
        _schema.sku = cls._schema_public_ip_address_read.sku
        _schema.tags = cls._schema_public_ip_address_read.tags
        _schema.type = cls._schema_public_ip_address_read.type
        _schema.zones = cls._schema_public_ip_address_read.zones

    _schema_security_rule_read = None

    @classmethod
    def _build_schema_security_rule_read(cls, _schema):
        if cls._schema_security_rule_read is not None:
            _schema.etag = cls._schema_security_rule_read.etag
            _schema.id = cls._schema_security_rule_read.id
            _schema.name = cls._schema_security_rule_read.name
            _schema.properties = cls._schema_security_rule_read.properties
            return

        cls._schema_security_rule_read = _schema_security_rule_read = AAZObjectType()

        security_rule_read = _schema_security_rule_read
        security_rule_read.etag = AAZStrType()
        security_rule_read.id = AAZStrType()
        security_rule_read.name = AAZStrType()
        security_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_security_rule_read.properties
        properties.access = AAZStrType(
            flags={"required": True},
        )
        properties.description = AAZStrType()
        properties.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
        )
        properties.destination_address_prefixes = AAZListType(
            serialized_name="destinationAddressPrefixes",
        )
        properties.destination_application_security_groups = AAZListType(
            serialized_name="destinationApplicationSecurityGroups",
        )
        properties.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        properties.destination_port_ranges = AAZListType(
            serialized_name="destinationPortRanges",
        )
        properties.direction = AAZStrType(
            flags={"required": True},
        )
        properties.priority = AAZIntType()
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
        )
        properties.source_address_prefixes = AAZListType(
            serialized_name="sourceAddressPrefixes",
        )
        properties.source_application_security_groups = AAZListType(
            serialized_name="sourceApplicationSecurityGroups",
        )
        properties.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )
        properties.source_port_ranges = AAZListType(
            serialized_name="sourcePortRanges",
        )

        destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrType()

        destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(destination_application_security_groups.Element)

        destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
        destination_port_ranges.Element = AAZStrType()

        source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
        source_address_prefixes.Element = AAZStrType()

        source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
        source_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(source_application_security_groups.Element)

        source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
        source_port_ranges.Element = AAZStrType()

        _schema.etag = cls._schema_security_rule_read.etag
        _schema.id = cls._schema_security_rule_read.id
        _schema.name = cls._schema_security_rule_read.name
        _schema.properties = cls._schema_security_rule_read.properties

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_subnet_read = None

    @classmethod
    def _build_schema_subnet_read(cls, _schema):
        if cls._schema_subnet_read is not None:
            _schema.etag = cls._schema_subnet_read.etag
            _schema.id = cls._schema_subnet_read.id
            _schema.name = cls._schema_subnet_read.name
            _schema.properties = cls._schema_subnet_read.properties
            return

        cls._schema_subnet_read = _schema_subnet_read = AAZObjectType()

        subnet_read = _schema_subnet_read
        subnet_read.etag = AAZStrType()
        subnet_read.id = AAZStrType()
        subnet_read.name = AAZStrType()
        subnet_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )
        properties.delegations = AAZListType()
        properties.interface_endpoints = AAZListType(
            serialized_name="interfaceEndpoints",
            flags={"read_only": True},
        )
        properties.ip_configuration_profiles = AAZListType(
            serialized_name="ipConfigurationProfiles",
            flags={"read_only": True},
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"read_only": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.purpose = AAZStrType(
            flags={"read_only": True},
        )
        properties.resource_navigation_links = AAZListType(
            serialized_name="resourceNavigationLinks",
        )
        properties.route_table = AAZObjectType(
            serialized_name="routeTable",
        )
        properties.service_association_links = AAZListType(
            serialized_name="serviceAssociationLinks",
        )
        properties.service_endpoint_policies = AAZListType(
            serialized_name="serviceEndpointPolicies",
        )
        properties.service_endpoints = AAZListType(
            serialized_name="serviceEndpoints",
        )

        address_prefixes = _schema_subnet_read.properties.address_prefixes
        address_prefixes.Element = AAZStrType()

        delegations = _schema_subnet_read.properties.delegations
        delegations.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.delegations.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.delegations.Element.properties
        properties.actions = AAZListType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service_name = AAZStrType(
            serialized_name="serviceName",
        )

        actions = _schema_subnet_read.properties.delegations.Element.properties.actions
        actions.Element = AAZStrType()

        interface_endpoints = _schema_subnet_read.properties.interface_endpoints
        interface_endpoints.Element = AAZObjectType()
        cls._build_schema_interface_endpoint_read(interface_endpoints.Element)

        ip_configuration_profiles = _schema_subnet_read.properties.ip_configuration_profiles
        ip_configuration_profiles.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.ip_configuration_profiles.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.ip_configuration_profiles.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        ip_configurations = _schema_subnet_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_ip_configuration_read(ip_configurations.Element)

        resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
        resource_navigation_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.resource_navigation_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        route_table = _schema_subnet_read.properties.route_table
        route_table.etag = AAZStrType()
        route_table.id = AAZStrType()
        route_table.location = AAZStrType()
        route_table.name = AAZStrType(
            flags={"read_only": True},
        )
        route_table.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        route_table.tags = AAZDictType()
        route_table.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties
        properties.disable_bgp_route_propagation = AAZBoolType(
            serialized_name="disableBgpRoutePropagation",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.routes = AAZListType()
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        routes = _schema_subnet_read.properties.route_table.properties.routes
        routes.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.route_table.properties.routes.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.next_hop_ip_address = AAZStrType(
            serialized_name="nextHopIpAddress",
        )
        properties.next_hop_type = AAZStrType(
            serialized_name="nextHopType",
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        subnets = _schema_subnet_read.properties.route_table.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.route_table.tags
        tags.Element = AAZStrType()

        service_association_links = _schema_subnet_read.properties.service_association_links
        service_association_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_association_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.service_association_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies
        service_endpoint_policies.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.location = AAZStrType()
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.service_endpoint_policy_definitions = AAZListType(
            serialized_name="serviceEndpointPolicyDefinitions",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        service_endpoint_policy_definitions = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions
        service_endpoint_policy_definitions.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties
        properties.description = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service = AAZStrType()
        properties.service_resources = AAZListType(
            serialized_name="serviceResources",
        )

        service_resources = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties.service_resources
        service_resources.Element = AAZStrType()

        subnets = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.service_endpoint_policies.Element.tags
        tags.Element = AAZStrType()

        service_endpoints = _schema_subnet_read.properties.service_endpoints
        service_endpoints.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoints.Element
        _element.locations = AAZListType()
        _element.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        _element.service = AAZStrType()

        locations = _schema_subnet_read.properties.service_endpoints.Element.locations
        locations.Element = AAZStrType()

        _schema.etag = cls._schema_subnet_read.etag
        _schema.id = cls._schema_subnet_read.id
        _schema.name = cls._schema_subnet_read.name
        _schema.properties = cls._schema_subnet_read.properties

    _schema_virtual_network_tap_read = None

    @classmethod
    def _build_schema_virtual_network_tap_read(cls, _schema):
        if cls._schema_virtual_network_tap_read is not None:
            _schema.etag = cls._schema_virtual_network_tap_read.etag
            _schema.id = cls._schema_virtual_network_tap_read.id
            _schema.location = cls._schema_virtual_network_tap_read.location
            _schema.name = cls._schema_virtual_network_tap_read.name
            _schema.properties = cls._schema_virtual_network_tap_read.properties
            _schema.tags = cls._schema_virtual_network_tap_read.tags
            _schema.type = cls._schema_virtual_network_tap_read.type
            return

        cls._schema_virtual_network_tap_read = _schema_virtual_network_tap_read = AAZObjectType()

        virtual_network_tap_read = _schema_virtual_network_tap_read
        virtual_network_tap_read.etag = AAZStrType()
        virtual_network_tap_read.id = AAZStrType()
        virtual_network_tap_read.location = AAZStrType()
        virtual_network_tap_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_tap_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        virtual_network_tap_read.tags = AAZDictType()
        virtual_network_tap_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_tap_read.properties
        properties.destination_load_balancer_front_end_ip_configuration = AAZObjectType(
            serialized_name="destinationLoadBalancerFrontEndIPConfiguration",
        )
        properties.destination_network_interface_ip_configuration = AAZObjectType(
            serialized_name="destinationNetworkInterfaceIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.destination_network_interface_ip_configuration)
        properties.destination_port = AAZIntType(
            serialized_name="destinationPort",
        )
        properties.network_interface_tap_configurations = AAZListType(
            serialized_name="networkInterfaceTapConfigurations",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        destination_load_balancer_front_end_ip_configuration = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration
        destination_load_balancer_front_end_ip_configuration.etag = AAZStrType()
        destination_load_balancer_front_end_ip_configuration.id = AAZStrType()
        destination_load_balancer_front_end_ip_configuration.name = AAZStrType()
        destination_load_balancer_front_end_ip_configuration.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        destination_load_balancer_front_end_ip_configuration.zones = AAZListType()

        properties = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties
        properties.inbound_nat_pools = AAZListType(
            serialized_name="inboundNatPools",
            flags={"read_only": True},
        )
        properties.inbound_nat_rules = AAZListType(
            serialized_name="inboundNatRules",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        inbound_nat_pools = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.inbound_nat_pools
        inbound_nat_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_pools.Element)

        inbound_nat_rules = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_rules.Element)

        load_balancing_rules = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        zones = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.zones
        zones.Element = AAZStrType()

        network_interface_tap_configurations = _schema_virtual_network_tap_read.properties.network_interface_tap_configurations
        network_interface_tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(network_interface_tap_configurations.Element)

        tags = _schema_virtual_network_tap_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_tap_read.etag
        _schema.id = cls._schema_virtual_network_tap_read.id
        _schema.location = cls._schema_virtual_network_tap_read.location
        _schema.name = cls._schema_virtual_network_tap_read.name
        _schema.properties = cls._schema_virtual_network_tap_read.properties
        _schema.tags = cls._schema_virtual_network_tap_read.tags
        _schema.type = cls._schema_virtual_network_tap_read.type


__all__ = ["Create"]
