# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.appcontainers import ContainerAppsAPIClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-appcontainers
# USAGE
    python dapr_subscriptions_create_or_update_route_rules_and_metadata.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerAppsAPIClient(
        credential=DefaultAzureCredential(),
        subscription_id="8efdecc5-919e-44eb-b179-915dca89ebf9",
    )

    response = client.dapr_subscriptions.create_or_update(
        resource_group_name="examplerg",
        environment_name="myenvironment",
        name="mysubscription",
        dapr_subscription_envelope={
            "properties": {
                "metadata": {"foo": "bar", "hello": "world"},
                "pubsubName": "mypubsubcomponent",
                "routes": {
                    "default": "/products",
                    "rules": [
                        {"match": "event.type == 'widget'", "path": "/widgets"},
                        {"match": "event.type == 'gadget'", "path": "/gadgets"},
                    ],
                },
                "topic": "inventory",
            }
        },
    )
    print(response)


# x-ms-original-file: specification/app/resource-manager/Microsoft.App/preview/2025-02-02-preview/examples/DaprSubscriptions_CreateOrUpdate_RouteRulesAndMetadata.json
if __name__ == "__main__":
    main()
