
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file YDateCoordinateAttributes.h
    \\brief Definition of YDateCoordinate Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "YDateCoordinateAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

YDateCoordinateAttributes::YDateCoordinateAttributes():
	date_min_(ParameterManager::getString("subpage_y_date_min")),
	date_max_(ParameterManager::getString("subpage_y_date_max")),
	reverse_(ParameterManager::getBool("subpage_y_automatic_reverse"))
	,
	automatic_(MagTranslator<string, AxisAutomaticSetting>().magics("subpage_y_automatic"))
	
{
}


YDateCoordinateAttributes::~YDateCoordinateAttributes()
{

}


void YDateCoordinateAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "subpage";
	prefix[i++] = "subpage_y";
	prefix[i++] = "subpage_y_date";
	
	setAttribute(prefix, "subpage_y_date_min", date_min_, params);
	setAttribute(prefix, "subpage_y_date_max", date_max_, params);
	setAttribute(prefix, "subpage_y_automatic_reverse", reverse_, params);
	
	setAttribute(prefix, "subpage_y_automatic", automatic_, params);
	
}

void YDateCoordinateAttributes::copy(const YDateCoordinateAttributes& other)
{
	date_min_ = other.date_min_;
	date_max_ = other.date_max_;
	reverse_ = other.reverse_;
	automatic_ = other.automatic_;
	
}


bool YDateCoordinateAttributes::accept(const string& node)
{

	if ( magCompare(node, "y_date")  )
		return true;
	
	return false;
}

void YDateCoordinateAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "y_date")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void YDateCoordinateAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " date_min = " <<  date_min_;
	out << " date_max = " <<  date_max_;
	out << " reverse = " <<  reverse_;
	out << " automatic = " <<  automatic_;
	
	out << "]" << "\n";
}

void YDateCoordinateAttributes::toxml(ostream& out)  const
{
	out <<  "\"y_date\"";
	out << ", \"subpage_y_date_min\":";
	niceprint(out,date_min_);
	out << ", \"subpage_y_date_max\":";
	niceprint(out,date_max_);
	out << ", \"subpage_y_automatic_reverse\":";
	niceprint(out,reverse_);
	out << ", \"subpage_y_automatic\":";
	niceprint(out, automatic_);
	
}

static MagicsParameter<string> subpage_y_date_min("subpage_y_date_min", "");
static MagicsParameter<string> subpage_y_date_max("subpage_y_date_max", "");
static MagicsParameter<string> subpage_y_automatic_reverse("subpage_y_automatic_reverse", "off");
static MagicsParameter<string> subpage_y_automatic("subpage_y_automatic", "off");
