% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_simulation.R
\name{create_conditions}
\alias{create_conditions}
\title{Creating proper conditions vector}
\usage{
create_conditions(control_condition, data, condition_col, control_augment)
}
\arguments{
\item{control_condition}{Value of the control condition. Only necessary when \code{control_augment} is greater than 0. Internally this value
is coerced to a string, so it should be passed as a string, or a type that can easily be converted to a string.}

\item{data}{A data.frame, data.table, or tibble containing input data from the trial. This should be the results
of a traditional Randomized Controlled Trial (RCT). Any data.frames will be converted to tibbles internally.}

\item{condition_col}{Column in \code{data}; original treatment condition for each observation.}

\item{control_augment}{A numeric value ranging from 0 to 1; proportion of each wave guaranteed to receive the "Control" treatment.
Default is 0. It is not recommended to use this in conjunction with \code{random_assign_prop}.}
}
\value{
Character vector of unique treatment conditions. Throws error if an invalid specification
is used.
}
\description{
This function creates a character vector of treatment conditions
using the conditions column in the provided data, and if \code{control_augment} is greater
than 0, it also labels the control condition. Throws an error of \code{control_condition} is not
present.
}
\keyword{internal}
