% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model.R
\name{get_model}
\alias{get_model}
\title{Extract Model Formula from a loglm or glm Object}
\usage{
get_model(x, type = c("brackets", "formula"), abbrev = FALSE, ...)
}
\arguments{
\item{x}{A \code{loglm} or \code{glm} object}

\item{type}{Type of output: \code{"brackets"} for loglinear bracket notation
(e.g., \code{"[AB] [C]"}), or \code{"formula"} for R formula notation.
For \code{glm} objects, only \code{"formula"} is meaningful.}

\item{abbrev}{Logical or integer. If \code{TRUE} or a positive integer,
abbreviate factor names to that many characters (default 1 when \code{TRUE}).
Only applies to bracket notation.}

\item{\dots}{Additional arguments passed to \code{loglin2string}
such as \code{sep} and \code{collapse}.}
}
\value{
A character string with the model formula or bracket notation.
}
\description{
\code{get_model()} extracts the model formula or bracket notation from a single
\code{loglm} or \code{glm} object. This is useful for labeling
models in summaries and plots. See \code{\link{get_models}} for the
corresponding function for \code{loglmlist} and \code{glmlist} objects.
}
\details{
For \code{loglm} objects created by \code{\link{seq_loglm}}, the bracket
notation is stored in the \code{model.string} component. For other \code{loglm}
objects, it is constructed from the \code{margin} component using
\code{\link{loglin2string}}.

For \code{glm} objects, the formula is extracted using \code{formula()}.
}
\examples{
data(Titanic)
tit.joint <- seq_loglm(Titanic, type = "joint")
get_model(tit.joint[[2]])
get_model(tit.joint[[4]])
get_model(tit.joint[[4]], abbrev = TRUE)
get_model(tit.joint[[4]], type = "formula")

}
\seealso{
\code{\link{get_models}} for \code{glmlist} and \code{loglmlist} objects,
\code{\link{loglin2string}}, \code{\link{seq_mosaic}}

Other loglinear models: 
\code{\link{glmlist}()},
\code{\link{joint}()},
\code{\link{seq_loglm}()}
}
\concept{loglinear models}
