% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m13.R
\name{treestructure.test}
\alias{treestructure.test}
\title{Test treestructure hypothesis}
\usage{
treestructure.test(tre, x, y, nsim = 10000)
}
\arguments{
\item{tre}{An ape::phylo tree, must be binary and rooted}

\item{x}{A character vector of tip labels or numeric node numbers. If numeric,
can include internal node numbers.}

\item{y}{as x, but must be disjoint with x}

\item{nsim}{Number of simulations (larger = slower and more accurate)}
}
\description{
Test the hypothesis that two clades within a tree were generated by the same
coalescent process.
}
\examples{
tree <- ape::read.tree( system.file('sim.nwk', package = 'treestructure') )

# you can run the example below before running test
#struc <- trestruct( tree )

#because it can take a minute or so to run treestructure, we will load it here
struc <- readRDS( system.file('struc_plot_example.rds', package='treestructure') )

#run the test

results <- treestructure.test(tree, x = struc$clusterSets[[1]],
                              y = struc$clusterSets[[2]])

print(results)
}
