% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdt.R
\name{tdt}
\alias{tdt}
\title{Run a function on a \code{treedata.table} object}
\usage{
tdt(tdObject, ...)
}
\arguments{
\item{tdObject}{A treedata.table object}

\item{...}{A function call.}
}
\value{
Function output for a single tree (phylo) or a list of function
outputs (one per each tree in the MultiPhylo object)
}
\description{
Run a function on a \code{treedata.table} object
}
\details{
This function allows R functions that use trees and data to be run
on\code{treedata.table} objects.
}
\examples{
data(anolis)
\donttest{

# A treedata.table object with a phylo $phy
td <- as.treedata.table(anolis$phy, anolis$dat)
tdt(td, geiger::fitContinuous(phy, extractVector(td, "SVL"),
  model = "BM", ncores = 1
))


# A treedata.table object with a multiPhylo $phy
treesFM <- list(anolis$phy, anolis$phy)
class(treesFM) <- "multiPhylo"
td <- as.treedata.table(treesFM, anolis$dat)
tdt(td, geiger::fitContinuous(phy, extractVector(td, "SVL"),
  model = "BM",
  ncores = 1
))
}
}
