% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagpol.R
\name{lagpol0}
\alias{lagpol0}
\title{Create lag polynomial objects}
\usage{
lagpol0(op, type, envir = parent.frame())
}
\arguments{
\item{op}{Polynomial specification in one of these formats:
\itemize{
  \item Numeric vector \eqn{c(d, s, p)} specifying polynomial degree, 
        lag step (default 1), and exponent (default 1)
  \item Character equation (e.g., \code{"1 - 0.8B"})
  \item Seasonal period or frequency (e.g., \code{"12"} or \code{"1/12"})
  \item List combining multiple specifications
}}

\item{type}{Operator type: \code{"ar"} (autoregressive), \code{"ma"} (moving
average), or \code{"i"} (integration).}

\item{envir}{Environment for argument evaluation. Defaults to parent frame.}
}
\value{
List of \code{\link{lagpol}} objects.
}
\description{
`lagpol0` is a flexible constructor for \code{\link{lagpol}} objects.
It accepts multiple input formats: polynomial orders \eqn{(d, s, p)}, 
literal equations (e.g., \eqn{1 - 0.8B}), or seasonal specifications for 
special lag polynomials like \eqn{AR/I/MA(s-1)}.
}
\examples{
# AR(1) polynomial
lagpol0(op = 1, type = "ar")

# From literal equation
lagpol0(op = "1 - 0.8B", type = "ar")

# Multiple polynomials at once
lagpol0(op = list(1, "1 - 0.5B"), type = "ma")

# Seasonal polynomial
lagpol0(op = "12", type = "ar")

# Custom orders with seasonal component
lagpol0(op = c(2, 12, 1), type = "ar")

}
\seealso{
\code{\link{lagpol}}
}
