% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.Levenetestsms.mv.R
\name{print.Levenetestsms.mv}
\alias{print.Levenetestsms.mv}
\title{Prints multiple Levene's tests of multivariate data.}
\usage{
\method{print}{Levenetestsms.mv}(
  x,
  format = "oneway.test",
  EffectSize = TRUE,
  multivariate = FALSE,
  mv_statistic = c("Pillai", "Wilks", "Hotelling-Lawley", "Roy"),
  long = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class "Levenetestsms.mv".}

\item{format}{a character string specifying the one-way ANOVA results are
formatted, must be one of \code{"oneway.test"} (default), \code{"anova.lm"}
or \code{"both"}.}

\item{EffectSize}{a logical variable. If \code{TRUE} (default), the measures
of effect size \eqn{\eta^2}, \eqn{\omega^2}, \eqn{\epsilon^2}, and Cohen's f
are returned.}

\item{multivariate}{a logical variable. If \code{TRUE}, the multivariate
Levene's test is returned. The test statistic chosen can be set with the
optional argument \code{mv_statistic}.}

\item{mv_statistic}{a character string. The name of the test statistic to be
used in the multivariate Levene's test (any of the four tests implemented in
\code{\link[stats]{summary.manova}}). Pillai's test is the default. Partial
matching is used so the name can be abbreviated.}

\item{long}{A logical variable indicating whether a long output is desired
(\code{TRUE}) or not (\code{FALSE}, the default). The additional objects
returned are three matrices: 1) matrix of medians for the original data
classified by sample and response variable, 2) matrix of mean absolute
deviations around means, and 3) matrix of variances of absolute deviations
around means.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
{
An annotated output of \emph{m}-sample Levene's tests computed from one-way
ANOVAs applied to absolute differences around medians for \emph{p} responses,
with (optionally) corrected significance levels. The argument \code{x},
invisibly, as for all print methods, is a list of class
"\code{Levenetestsms.mv}". This \code{print} method provides a user-friendly
display of particular elements in \code{x}:
\itemize{
\item A description of the analysis.
\item The data frame analyzed
\item The labels of the group factor with \emph{m} levels (samples).
\item The univariate Levene's tests based on the results of one-way ANOVAs
for each response variable; These results consist of the \emph{F}-tests
displayed in up to two different output formats corresponding to the
formatted results produced by the conventional functions
\code{\link[stats]{oneway.test}} and \code{\link[stats]{anova.lm}}.
P-values are recomputed whenever \code{P.adjust} method is different
from \code{"none"}.
}
In addition to the above information, the \code{long = TRUE} output lists:
\itemize{
\item Sample medians classified by group levels and variables.
\item Means and variances of sample absolute deviations from the median
classified by group levels and variables.
}
If \code{multivariate = TRUE}, the multivariate Levene's test is appended,
based on the test statistic specified in \code{mv_statistic}. If
\code{multivariate = TRUE} and \code{mv_statistic} is omitted, Pillai's
statistic is chosen by default.
}
}
\description{
Prints the results produced by \code{\link[smsets]{Levenetestsms.mv}},
consisting of \emph{m}-sample Levene's tests computed from one-way ANOVAs
applied to absolute differences around medians for \emph{p} responses. It
optionally produces a single multivariate Levene's test which is basically a
one-way MANOVA of absolute differences around medians.
}
\examples{
data(skulls)
res.Levenems.mv <- Levenetestsms.mv(skulls, Period, var.equal = TRUE,
                                    P.adjust = "bonferroni")
print(res.Levenems.mv, format = "both", multivariate = TRUE, long = TRUE)

}
