% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{SIN}
\alias{SIN}
\title{Definition of a Sinusoidal (SIN) Process}
\usage{
SIN(alpha2 = 9e-04, beta = 0.06, U = NULL)
}
\arguments{
\item{alpha2}{A \code{double} value for the squared amplitude parameter \eqn{\alpha^2}{alpha} (see Note for details).}

\item{beta}{A \code{double} value for the angular frequency parameter \eqn{\beta}{beta} (see Note for details).}

\item{U}{A \code{double} value for the phase parameter \eqn{U}{U} (see Note for details).}
}
\value{
An S3 object containing the specified ts.model with the following structure:
\describe{
 \item{process.desc}{Used in summary: "ALPHA2","BETA"}
 \item{theta}{Parameter vector including \eqn{\alpha^2}{alpha2}, \eqn{\beta}{beta}}
 \item{plength}{Number of parameters}
 \item{print}{String containing simplified model}
 \item{desc}{"SIN"}
 \item{obj.desc}{Depth of Parameters e.g. list(1,1)}
 \item{starting}{Find starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Definition of a Sinusoidal (SIN) Process
}
\note{
We consider the following sinusoidal process : \deqn{X_t = \alpha \sin(\beta t + U)}, where \eqn{U \sim \mathcal{U}(0, 2\pi)}
and \eqn{\beta \in (0, \frac{\pi}{2})}
}
\examples{
SIN()
SIN(alpha2 = .5, beta = .05)
}
\author{
Lionel Voirol
}
