% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metareactive.R
\name{metaExpr}
\alias{metaExpr}
\title{Mark an expression as a meta-expression}
\usage{
metaExpr(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  localize = "auto",
  bindToReturn = FALSE
)
}
\arguments{
\item{expr}{An expression (quoted or unquoted).}

\item{env}{An environment.}

\item{quoted}{Is the expression quoted? This is useful when you want to use an expression
that is stored in a variable; to do so, it must be quoted with \code{\link[=quote]{quote()}}.}

\item{localize}{Whether or not to wrap the returned expression in \code{\link[=local]{local()}}.
The default, \code{"auto"}, only wraps expressions with a top-level \code{\link[=return]{return()}}
statement (i.e., return statements in anonymized functions are ignored).}

\item{bindToReturn}{For non-\code{localize}d expressions, should an assignment
of a meta expression be applied to the \emph{last child} of the top-level \verb{\\\{} call?}
}
\value{
If inside meta mode, a quoted form of \code{expr} for use inside of
\code{\link[=metaReactive2]{metaReactive2()}}, \code{\link[=metaObserve2]{metaObserve2()}}, or \code{\link[=metaRender2]{metaRender2()}}. Otherwise, in
normal execution, the result of evaluating \code{expr}.
}
\description{
Mark an expression as a meta-expression
}
\seealso{
\code{\link[=metaReactive2]{metaReactive2()}}, \code{\link[=metaObserve2]{metaObserve2()}}, \code{\link[=metaRender2]{metaRender2()}}, \code{\link[=dotdot]{..}}
}
