% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_energy.R
\name{calculate_energy}
\alias{calculate_energy}
\title{calculate_energy}
\usage{
calculate_energy(
  pattern,
  weights = c(1, 1),
  return_mean = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{pattern}{List with reconstructed patterns.}

\item{weights}{Vector with weights used to calculate energy.
The first number refers to Gest(r), the second number to pcf(r).}

\item{return_mean}{Logical if the mean energy is returned.}

\item{verbose}{Logical if progress report is printed.}
}
\value{
vector
}
\description{
Calculate mean energy
}
\details{
The function calculates the mean energy (or deviation) between the observed
pattern and all reconstructed patterns (for more information see Tscheschel &
Stoyan (2006) or Wiegand & Moloney (2014)). The pair correlation function and the
nearest neighbour distance function are used to describe the patterns.
}
\examples{
pattern_random <- fit_point_process(species_a, n_random = 19)
calculate_energy(pattern_random)
calculate_energy(pattern_random, return_mean = TRUE)

\dontrun{
marks_sub <- spatstat.geom::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_pattern_marks(pattern_random$randomized[[1]], marks_sub,
n_random = 19, max_runs = 1000)
calculate_energy(marks_recon, return_mean = FALSE)
}

}
\references{
Kirkpatrick, S., Gelatt, C.D.Jr., Vecchi, M.P., 1983. Optimization by simulated
annealing. Science 220, 671–680. <https://doi.org/10.1126/science.220.4598.671>

Tscheschel, A., Stoyan, D., 2006. Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis 51, 859–871.
<https://doi.org/10.1016/j.csda.2005.09.007>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton. ISBN 978-1-4200-8254-8
}
\seealso{
\code{\link{plot_energy}},
\code{\link{reconstruct_pattern}},
\code{\link{fit_point_process}}
}
