serpstatr
=========

The aim of serpstatr is to provide a wrapper for the latest version of
[Serpstat API](https://api-docs.serpstat.com/docs/serpstat-public-api/jenasqbwtxdlr-introduction-to-serpstat-api). The main purpose of this API
is automation of common SEO and PPC tasks like keywords research and
competitors analysis in Google.

All package functions names have the same structure:

-   sst\_ prefix to distinguish from other packages
-   Serpstat modules prefix (for example, sa\_ for search analytics)
-   API function name

How to use
----------

1. Get your [API key](https://serpstat.com/users/profile/). It is required
in all package functions. Set it as a SERPSTAT_API_TOKEN system variable.
All functions are using it by default.

2. Search analytics

Check if you have enough limits to make API calls

    sst_sa_stats()$summary_info$left_lines

Get database ID to make requests:

    sst_sa_database_info()$data

Call functions to get keywords data:

-   sst\_sa\_domains\_info() - domain summary stats
-   sst\_sa\_domain\_keywords() - domain keywords with stats
-   sst\_sa\_domain\_history() - domain historical metrics
-   sst\_sa\_domain\_top\_pages() - domain top pages
-   sst\_sa\_domain\_organic\_competitors() - domain organic competitors
-   sst\_sa\_domain\_regions\_count() - number of keywords per region for a domain
-   sst\_sa\_keywords\_info() - keywords summary stats
-   sst\_sa\_keywords() - search Serpstat database for keywords with
    stats
-   sst\_sa\_related\_keywords() - semantically related keywords for a given keyword
-   sst\_sa\_keyword\_top() - get list of URLs from SERP for a keyword

<!-- -->

    sst_sa_keywords_info(
      keywords      = c('seo', 'ppc', 'serpstat'),
      se            = 'g_us',
      sort          = list(cost = 'asc'),
      return_method = 'df'
    )$data
    
3. Backlinks

Call functions to get the data on the backlinks:

-   sst_bl_domain_summary() - backlinks summary stats for the domain
-   sst_bl_referring_domains() - referring domains stats for the domain

<!-- -->

    sst_bl_domain_summary(
      domain        = 'serpstat.com',
      search_type   = 'domain',
      return_method = 'list'
      )$data
      
4. Rank tracker

Call functions to get the data on your rankings:

-   sst_rt_project_regions() - all regions for a project
-   sst_rt_serp_history() - search results history in search region by keyword
-   sst_rt_positions_history() - ranking history for the domain or URL in 
    selected search region
-   sst_rt_competitors() - data on competitors in search results

<!-- -->

    sst_rt_positions_history(
      project_id    = project_id,
      region_id     = region_id,
      date_from     = '2020-12-01',
      date_to       = '2020-12-30',
      keywords      = c('seo', 'ppc', 'serpstat'),
      url           = 'serpstat.com',
      sort          = 'keyword',
      order         = 'desc',
      page          = 1,
      size          = 100,
      return_method = 'list'
      )$data$keywords

4. Audit

Call functions to audit your website for technical issues:

-   sst_au_start() - start website audit
-   sst_au_get_summary() - get website audit summary

<!-- -->

    sst_au_start(
      project_id    = project_id
      )$data$reportId
      
5. Project management

Call functions to manage your projects:

-   sst_pm_create_project() - create a new project
-   sst_pm_delete_project() - delete an existing project
-   sst_pm_list_projects() - list all projects available for the user

<!-- -->

    sst_pm_create_project(
      domain    = 'serpstat.com',
      name      = 'Serpstat'
      )$data$project_id

Installation
------------

To get the current development version from GitLab:

    devtools::install_gitlab('alexdanilin/serpstatr')

Issues
------

Send all issues on [GitLab
page](https://gitlab.com/alexdanilin/serpstatr/-/issues).
