% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{schwab_auth1_loginURL}
\alias{schwab_auth1_loginURL}
\title{Auth Step 1: Generate LogIn URL}
\usage{
schwab_auth1_loginURL(appKey, callbackURL)
}
\arguments{
\item{appKey}{'Schwab API' generated App Key for the registered app.}

\item{callbackURL}{Users Callback URL for the registered app}
}
\value{
login url to grant app permission to Schwab accounts
}
\description{
Create URL to grant App access to Charles Schwab accounts
}
\details{
To use the 'Schwab API', both an account and a registered
developer app are required. The developer app functions as a middle layer
between the brokerage account and the API. A developer app should be
registered on the \href{https://developer.schwab.com}{Schwab
Developer} site. Once logged in to the developer site, use My Apps to
register an application. An App will have a key and secret provided.
The Key/Secret is auto generated and can be found under
Dashboard > View Details at the bottom. The user must also create a Callback URL.
The Callback URL must be a valid URL. The example below assumes the Callback
URL is https://127.0.0.1. The Application should be in a "Ready to Use"
state before attempting to login.


This function will use these inputs to generate a URL where the user can
log in to their standard Charles Schwab Access Page and grant the
application access to the specific accounts, enabling the API. The URL
Authorization Code generated at the end of the log in process will feed into
\code{\link{schwab_auth2_refreshToken}}. For questions, please reference the
\href{https://developer.schwab.com/products/trader-api--individual/details/documentation/}{Schwab
Docs} or see the examples in the 'schwabr' readme.
}
\examples{

# Visit the URL generated from the function below to log in accept terms and
# select the accounts you want to have API permissions.

# This assumes you set the callback to 'https://127.0.0.1'
appKey = 'ALPHANUM1234KEY'
loginURL = schwab_auth1_loginURL(appKey, 'https://127.0.0.1')

}
