% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_theme.R
\name{scf_theme}
\alias{scf_theme}
\title{Default Plot Theme for SCF Visualizations}
\usage{
scf_theme(base_size = 13, base_family = "sans", grid = TRUE, axis = TRUE, ...)
}
\arguments{
\item{base_size}{Base font size. Defaults to 13.}

\item{base_family}{Font family. Defaults to "sans".}

\item{grid}{Logical. Show gridlines? Defaults to TRUE.}

\item{axis}{Logical. Include axis ticks and lines? Defaults to TRUE.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}}.}
}
\value{
A \code{ggplot2} theme object applied by all \verb{scf_plot_*()} functions.
}
\description{
The theme is designed to:
\itemize{
\item Render cleanly in \strong{print} (single-column or wrapped layout)
\item Scale well on \strong{HD desktop} monitors without visual clutter
\item Remain \strong{legible on mobile} with clear fonts and sufficient contrast
}

The default figure dimensions assumed for export are \strong{5.5 inches by 5.5 inches}
at \strong{300 dpi}, which balances compactness with accessibility across media.

All theme settings are exposed via comments to enable easy brand customization.
}
\details{
Defines the SCF package's default \code{ggplot2} theme, optimized for legibility,
clarity, and aesthetic coherence across print, desktop, and mobile platforms.
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(factor(cyl))) +
  geom_bar(fill = "#0072B2") +
  scf_theme()

}
\seealso{
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[=scf_plot_dist]{scf_plot_dist()}}
}
