% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_corr.R
\name{scf_corr}
\alias{scf_corr}
\title{Estimate Correlation Between Two Continuous Variables in SCF Microdata}
\usage{
scf_corr(scf, var1, var2)
}
\arguments{
\item{scf}{An \code{scf_mi_survey} object, created by \code{\link[=scf_load]{scf_load()}}}

\item{var1}{One-sided formula specifying the first variable}

\item{var2}{One-sided formula specifying the second variable}
}
\value{
An object of class \code{scf_corr}, containing:
\describe{
\item{results}{Data frame with pooled correlation estimate, standard error,
t-statistic, degrees of freedom, p-value, and minimum/maximum values across implicates.}
\item{imps}{Named vector of implicate-level correlations.}
\item{aux}{Variable names used in the estimation.}
}
}
\description{
This function estimates the linear association between two continuous variables
using Pearson's correlation. Estimates are computed within each implicate and then
pooled across implicates to account for imputation uncertainty.
}
\details{
Computes the Pearson correlation coefficient between two continuous variables using
multiply-imputed, replicate-weighted SCF data. Returns pooled estimates and standard errors
using Rubin’s Rules.
}
\note{
Degrees of freedom are approximated using a simplified Barnard–Rubin
adjustment, since correlation is a scalar quantity. Interpret cautiously with
few implicates.
}
\section{Implementation}{

\itemize{
\item Inputs: an \code{scf_mi_survey} object and two one-sided formulas (e.g., \code{~income})
\item Correlation computed using \code{cor(..., use = "complete.obs")} within each implicate
\item Rubin’s Rules applied to pool results across implicates
}
}

\section{Interpretation}{

Pearson’s \verb{$r$} ranges from -1 to +1 and reflects the strength and
direction of a linear bivariate association between two continuous variables.
Values near 0 indicate weak linear association. Note that the operation is
sensitive to outliers and does not capture nonlinear relationships nor adjust
for covariates.
}

\section{Statistical Notes}{

Correlation is computed within each implicate using complete cases. Rubin’s
Rules are applied manually to pool estimates and calculate total variance.
Degrees of freedom are adjusted using the Barnard-Rubin method.
This function does not use \code{\link[=scf_MIcombine]{scf_MIcombine()}}, which is intended
for vector-valued estimates; direct pooling is more appropriate for
scalar statistics like correlation coefficients.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Estimate correlation between income and net worth
corr <- scf_corr(scf2022, ~income, ~networth)
print(corr)
summary(corr)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_plot_hex]{scf_plot_hex()}}, \code{\link[=scf_ols]{scf_ols()}}
}
