% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHA_int.R, R/MMSE2SMSE.R
\name{calc_pwild}
\alias{calc_pwild}
\alias{calc_pwild_age}
\title{Proportion wild spawners}
\usage{
calc_pwild(pHOS_cur, pHOS_prev, gamma)

calc_pwild_age(NOS_a, HOS_a, fec, gamma)
}
\arguments{
\item{pHOS_cur}{Numeric, proportion of hatchery spawners in current generation}

\item{pHOS_prev}{Numeric, proportion of hatchery spawners in previous generation}

\item{gamma}{Numeric, reduced reproductive success of hatchery spawners}

\item{NOS_a}{Array \verb{[nsim, maxage, years]} for natural spawners}

\item{HOS_a}{Array \verb{[nsim, maxage, years]} for hatchery spawners}

\item{fec}{Array \verb{[nsim, maxage, years]} for age class fecundity}
}
\value{
\code{calc_pwild_age()} a matrix of pWILD by simulation and year. \code{calc_pwild()} returns a numeric
}
\description{
Calculate the proportion of wild spawners from a time series of spawners
\itemize{
\item \code{calc_pwild()} is the simple calculation based on the proportion of hatchery spawners
\item \code{calc_pwild_age()} performs the calculation weighted by age class fecundity
}
}
\keyword{internal}
