% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternaryDiagAbline.R
\name{ternaryDiagAbline}
\alias{ternaryDiagAbline}
\title{Adds a line to a ternary diagram.}
\usage{
ternaryDiagAbline(x, ...)
}
\arguments{
\item{x}{Two-dimensional data set in isometric log-ratio transformed space.}

\item{\dots}{Additional graphical parameters passed through.}
}
\value{
no values are returned.
}
\description{
A low-level plot function which adds a line to a high-level ternary diagram.
}
\details{
This is a small utility function which helps to add a line in a ternary plot
from two given points in an isometric transformed space.
}
\examples{

data(coffee)
x <- coffee[,2:4]
ternaryDiag(x, grid=FALSE)
ternaryDiagAbline(data.frame(z1=c(0.01,0.5), z2=c(0.4,0.8)), col="red")

}
\seealso{
\code{\link{ternaryDiag}}
}
\author{
Matthias Templ
}
\keyword{aplot}
