% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readEot.R
\name{readEot}
\alias{readEot}
\title{Read \code{Eot}* files from disk}
\usage{
readEot(x, prefix = "remote", suffix = "grd")
}
\arguments{
\item{x}{\code{character}, search path for \code{Eot}* related files passed
to \code{\link[=list.files]{list.files()}}.}

\item{prefix}{\code{character}, see \code{\link[=writeEot]{writeEot()}} for details.
Should be the same as previously supplied to \code{\link[=eot]{eot()}}.}

\item{suffix}{\code{character}, file extension depending on the output file
type of locally stored \code{Eot}* files, see \code{\link[raster:writeRaster]{raster::writeRaster()}}.}
}
\value{
An \code{Eot}* object.
}
\description{
Read \code{Eot}* related files from disk, e.g. for further use with
\code{\link[=predict]{predict()}} or \code{\link[=plot]{plot()}}.
}
\examples{
\dontrun{
## calculate 3 leading modes
data(vdendool)
nh_modes <- eot(x = vdendool, n = 3, standardised = FALSE, 
                write.out = TRUE, path.out = "~/data")
                
## reimport related files
rm(nh_modes)
nh_modes <- readEot("~/data")
nh_modes
}

}
\seealso{
\code{\link[=eot]{eot()}}, \code{\link[=writeEot]{writeEot()}},
\code{\link[raster:writeRaster]{raster::writeRaster()}}.
}
\author{
Florian Detsch
}
