% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{validate_data}
\alias{validate_data}
\title{Validate Data Before Imputation}
\usage{
validate_data(data, vars, data_ice = NULL)
}
\arguments{
\item{data}{A data.frame containing the analysis dataset.}

\item{vars}{A \code{vars} object as created by \code{\link[rbmi:set_vars]{rbmi::set_vars()}}.}

\item{data_ice}{An optional data.frame of intercurrent events. If provided,
must contain columns corresponding to \code{vars$subjid}, \code{vars$visit}, and
\code{vars$strategy}. Can be created using \code{\link[=prepare_data_ice]{prepare_data_ice()}}.}
}
\value{
Invisibly returns \code{TRUE} if all checks pass. Throws an error with
collected messages if any issues are found.
}
\description{
Pre-flight validation of data, variable specification, and intercurrent event
data before calling \code{\link[rbmi:draws]{rbmi::draws()}}. Collects all issues and reports them
together in a single error message.
}
\details{
The following checks are performed:
\itemize{
\item \code{data} is a data.frame
\item All columns named in \code{vars} exist in \code{data}
\item \code{subjid}, \code{visit}, and \code{group} columns are factors
\item \code{outcome} column is numeric
\item Covariate columns have no missing values
\item Data has one row per subject-visit combination
\item If \code{data_ice} is provided: correct columns, valid subjects, valid
visits, recognised strategies, and at most one row per subject
}

\strong{Recommended Workflow:}
\enumerate{
\item Call \code{validate_data()} to check your data
\item Use \code{\link[=prepare_data_ice]{prepare_data_ice()}} to create ICE data if needed
\item Review missingness with \code{\link[=summarise_missingness]{summarise_missingness()}}
\item Proceed with \code{\link[rbmi:draws]{rbmi::draws()}} for imputation
}
}
\examples{
library(rbmi)

dat <- data.frame(
  USUBJID = factor(rep(c("S1", "S2", "S3"), each = 3)),
  AVISIT = factor(rep(c("Week 4", "Week 8", "Week 12"), 3),
                  levels = c("Week 4", "Week 8", "Week 12")),
  TRT = factor(rep(c("Placebo", "Drug A", "Drug A"), each = 3)),
  CHG = c(1.1, 2.2, 3.3, 0.5, NA, NA, 1.0, 2.0, NA),
  BASE = rep(c(10, 12, 11), each = 3),
  STRATA = factor(rep(c("A", "B", "A"), each = 3))
)

vars <- set_vars(
  subjid = "USUBJID",
  visit = "AVISIT",
  group = "TRT",
  outcome = "CHG",
  covariates = c("BASE", "STRATA")
)

validate_data(dat, vars)

}
\seealso{
\itemize{
\item \code{\link[rbmi:draws]{rbmi::draws()}} which requires validated input data
\item \code{\link[=prepare_data_ice]{prepare_data_ice()}} to create intercurrent event data from flags
\item \code{\link[=summarise_missingness]{summarise_missingness()}} to understand missing data patterns
}
}
